/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CsvLogEventLayout", category="Core", elementType="layout", printObject=true)
public class CsvLogEventLayout
extends AbstractCsvLayout {
    public static CsvLogEventLayout createDefaultLayout() {
        return new CsvLogEventLayout(null, Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static CsvLogEventLayout createLayout(CSVFormat format2) {
        return new CsvLogEventLayout(null, Charset.forName("UTF-8"), format2, null, null);
    }

    @PluginFactory
    public static CsvLogEventLayout createLayout(@PluginConfiguration Configuration config2, @PluginAttribute(value="format", defaultString="Default") String format2, @PluginAttribute(value="delimiter") Character delimiter, @PluginAttribute(value="escape") Character escape, @PluginAttribute(value="quote") Character quote, @PluginAttribute(value="quoteMode") QuoteMode quoteMode, @PluginAttribute(value="nullString") String nullString, @PluginAttribute(value="recordSeparator") String recordSeparator, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        CSVFormat csvFormat = CsvLogEventLayout.createFormat(format2, delimiter, escape, quote, quoteMode, nullString, recordSeparator);
        return new CsvLogEventLayout(config2, charset, csvFormat, header, footer);
    }

    protected CsvLogEventLayout(Configuration config2, Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(config2, charset, csvFormat, header, footer);
    }

    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder buffer = CsvLogEventLayout.getStringBuilder();
        CSVFormat format2 = this.getFormat();
        try {
            format2.print((Object)event.getNanoTime(), (Appendable)buffer, true);
            format2.print((Object)event.getTimeMillis(), (Appendable)buffer, false);
            format2.print((Object)event.getLevel(), (Appendable)buffer, false);
            format2.print((Object)event.getThreadId(), (Appendable)buffer, false);
            format2.print((Object)event.getThreadName(), (Appendable)buffer, false);
            format2.print((Object)event.getThreadPriority(), (Appendable)buffer, false);
            format2.print((Object)event.getMessage().getFormattedMessage(), (Appendable)buffer, false);
            format2.print((Object)event.getLoggerFqcn(), (Appendable)buffer, false);
            format2.print((Object)event.getLoggerName(), (Appendable)buffer, false);
            format2.print((Object)event.getMarker(), (Appendable)buffer, false);
            format2.print((Object)event.getThrownProxy(), (Appendable)buffer, false);
            format2.print((Object)event.getSource(), (Appendable)buffer, false);
            format2.print((Object)event.getContextData(), (Appendable)buffer, false);
            format2.print((Object)event.getContextStack(), (Appendable)buffer, false);
            format2.println((Appendable)buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            StatusLogger.getLogger().error(event.toString(), (Throwable)e);
            return format2.getCommentMarker() + " " + e;
        }
    }
}

