/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.UtilsKt;
import io.ktor.http.cio.websocket.WebSocketInternalAPI;
import io.ktor.util.NIOKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocketInternalAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004J\u0015\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/cio/websocket/SimpleFrameCollector;", "", "()V", "buffer", "Ljava/nio/ByteBuffer;", "hasRemaining", "", "getHasRemaining", "()Z", "maskBuffer", "kotlin.jvm.PlatformType", "remaining", "", "handle", "", "bb", "start", "length", "take", "maskKey", "(Ljava/lang/Integer;)Ljava/nio/ByteBuffer;", "ktor-http-cio"})
public final class SimpleFrameCollector {
    private int remaining;
    @Nullable
    private ByteBuffer buffer;
    private final ByteBuffer maskBuffer = ByteBuffer.allocate(4);

    public final boolean getHasRemaining() {
        return this.remaining > 0;
    }

    public final void start(int length2, @NotNull ByteBuffer bb) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(bb, "bb");
                boolean bl = this.remaining == 0;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    throw new IllegalStateException("remaining should be 0");
                }
                this.remaining = length2;
                if (this.buffer == null) break block4;
                ByteBuffer byteBuffer = this.buffer;
                Intrinsics.checkNotNull(byteBuffer);
                if (byteBuffer.capacity() >= length2) break block5;
            }
            this.buffer = ByteBuffer.allocate(length2);
        }
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer);
        byteBuffer.clear();
        this.handle(bb);
    }

    public final void handle(@NotNull ByteBuffer bb) {
        Intrinsics.checkNotNullParameter(bb, "bb");
        SimpleFrameCollector simpleFrameCollector = this;
        int n = simpleFrameCollector.remaining;
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer);
        simpleFrameCollector.remaining = n - NIOKt.moveTo(bb, byteBuffer, this.remaining);
    }

    @NotNull
    public final ByteBuffer take(@Nullable Integer maskKey) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer);
        ByteBuffer byteBuffer2 = byteBuffer;
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$take_u24lambda_u2d1 = byteBuffer2;
        boolean bl3 = false;
        $this$take_u24lambda_u2d1.flip();
        ByteBuffer view = $this$take_u24lambda_u2d1.slice();
        if (maskKey != null) {
            this.maskBuffer.clear();
            this.maskBuffer.asIntBuffer().put(maskKey);
            this.maskBuffer.clear();
            Intrinsics.checkNotNullExpressionValue(view, "view");
            ByteBuffer byteBuffer3 = this.maskBuffer;
            Intrinsics.checkNotNullExpressionValue(byteBuffer3, "maskBuffer");
            UtilsKt.xor(view, byteBuffer3);
        }
        this.buffer = null;
        ByteBuffer byteBuffer4 = view.asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue(byteBuffer4, "buffer!!.run {\n        f\u2026.asReadOnlyBuffer()\n    }");
        return byteBuffer4;
    }
}

