/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002\u001a$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0002H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0002H\u0002\u001a\u001c\u0010\u001b\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\f\u0010\u001e\u001a\u00020\u000f*\u00020\u000fH\u0002\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0004\"\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0004\"\u0016\u0010\n\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0004\u00a8\u0006\u001f"}, d2={"TOKEN68_EXTRA", "", "", "getTOKEN68_EXTRA$annotations", "()V", "TOKEN_EXTRA", "getTOKEN_EXTRA$annotations", "escapeRegex", "Lkotlin/text/Regex;", "getEscapeRegex$annotations", "token68Pattern", "getToken68Pattern$annotations", "matchParameter", "", "headerValue", "", "startIndex", "parameters", "", "matchParameters", "", "matchToken68", "parseAuthorizationHeader", "Lio/ktor/http/auth/HttpAuthHeader;", "isToken", "", "isToken68", "skipDelimiter", "delimiter", "skipSpaces", "unescaped", "ktor-http"})
public final class HttpAuthHeaderKt {
    @NotNull
    private static final Set<Character> TOKEN_EXTRA;
    @NotNull
    private static final Set<Character> TOKEN68_EXTRA;
    @NotNull
    private static final Regex token68Pattern;
    @NotNull
    private static final Regex escapeRegex;

    private static /* synthetic */ void getTOKEN_EXTRA$annotations() {
    }

    private static /* synthetic */ void getTOKEN68_EXTRA$annotations() {
    }

    private static /* synthetic */ void getToken68Pattern$annotations() {
    }

    private static /* synthetic */ void getEscapeRegex$annotations() {
    }

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull String headerValue) {
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        int index = 0;
        int tokenStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        while (index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index))) {
            int n = index;
            index = n + 1;
        }
        String authScheme = StringsKt.substring(headerValue, RangesKt.until(tokenStartIndex, index));
        tokenStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        if (StringsKt.isBlank(authScheme)) {
            return null;
        }
        if (headerValue.length() == index) {
            return new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null);
        }
        String token68 = HttpAuthHeaderKt.matchToken68(headerValue, index);
        if (token68 != null) {
            return new HttpAuthHeader.Single(authScheme, token68);
        }
        Map<String, String> parameters2 = HttpAuthHeaderKt.matchParameters(headerValue, tokenStartIndex);
        return new HttpAuthHeader.Parameterized(authScheme, parameters2, null, 4, null);
    }

    private static final Map<String, String> matchParameters(String headerValue, int startIndex) {
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        int index = startIndex;
        while (index > 0 && index < headerValue.length()) {
            index = HttpAuthHeaderKt.matchParameter(headerValue, index, result2);
            index = HttpAuthHeaderKt.skipDelimiter(headerValue, index, ',');
        }
        return result2;
    }

    private static final int matchParameter(String headerValue, int startIndex, Map<String, String> parameters2) {
        int escaped;
        int keyStart;
        int index = keyStart = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex);
        while (index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index))) {
            int n = index;
            index = n + 1;
        }
        String key = StringsKt.substring(headerValue, RangesKt.until(keyStart, index));
        if ((index = HttpAuthHeaderKt.skipSpaces(headerValue, index)) >= headerValue.length() || headerValue.charAt(index) != '=') {
            throw new ParseException("Expected `=` after parameter key '" + key + "': " + headerValue, null, 2, null);
        }
        int n = index;
        index = n + 1;
        index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        boolean quoted = false;
        int valueStart = index;
        if (headerValue.charAt(index) == '\"') {
            quoted = true;
            int n2 = index;
            valueStart = index = n2 + 1;
            escaped = 0;
            while (index < headerValue.length() && (headerValue.charAt(index) != '\"' || escaped != 0)) {
                escaped = escaped == 0 && headerValue.charAt(index) == '\\' ? 1 : 0;
                int n3 = index;
                index = n3 + 1;
            }
            if (index == headerValue.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter: " + headerValue + ' ', null, 2, null);
            }
        } else {
            while (index < headerValue.length() && headerValue.charAt(index) != ' ' && headerValue.charAt(index) != ',') {
                escaped = index;
                index = escaped + 1;
            }
        }
        String value = StringsKt.substring(headerValue, RangesKt.until(valueStart, index));
        Map<String, String> map2 = parameters2;
        String string = quoted ? HttpAuthHeaderKt.unescaped(value) : value;
        boolean bl = false;
        map2.put(key, string);
        if (quoted) {
            int n4 = index;
            index = n4 + 1;
        }
        return index;
    }

    private static final String matchToken68(String headerValue, int startIndex) {
        boolean onlySpaceRemaining;
        int index;
        block6: {
            boolean bl;
            int n;
            index = startIndex;
            while (index < headerValue.length() && HttpAuthHeaderKt.isToken68(headerValue.charAt(index))) {
                n = index;
                index = n + 1;
            }
            while (index < headerValue.length() && headerValue.charAt(index) == '=') {
                n = index;
                index = n + 1;
            }
            Iterable $this$all$iv = RangesKt.until(index, headerValue.length());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (headerValue.charAt(it) == ' ') continue;
                    bl = false;
                    break block6;
                }
                bl = onlySpaceRemaining = true;
            }
        }
        if (onlySpaceRemaining) {
            return StringsKt.substring(headerValue, RangesKt.until(startIndex, index));
        }
        return null;
    }

    private static final String unescaped(String $this$unescaped) {
        CharSequence charSequence = $this$unescaped;
        Regex regex = escapeRegex;
        Function1 function1 = unescaped.1.INSTANCE;
        boolean bl = false;
        return regex.replace(charSequence, function1);
    }

    private static final int skipDelimiter(String $this$skipDelimiter, int startIndex, char delimiter) {
        int n;
        int index = HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, startIndex);
        while (index < $this$skipDelimiter.length() && $this$skipDelimiter.charAt(index) != delimiter) {
            n = index;
            index = n + 1;
        }
        if (index == $this$skipDelimiter.length()) {
            return -1;
        }
        n = index;
        index = n + 1;
        return HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, index);
    }

    private static final int skipSpaces(String $this$skipSpaces, int startIndex) {
        int index = startIndex;
        while (index < $this$skipSpaces.length() && $this$skipSpaces.charAt(index) == ' ') {
            int n = index;
            index = n + 1;
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken68(char $this$isToken68) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken68) {
            if ($this$isToken68 <= 'z') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken68) {
            if ($this$isToken68 <= 'Z') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken68)) return true;
        if (!TOKEN68_EXTRA.contains(Character.valueOf($this$isToken68))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken(char $this$isToken) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken) {
            if ($this$isToken <= 'z') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken) {
            if ($this$isToken <= 'Z') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken)) return true;
        if (!TOKEN_EXTRA.contains(Character.valueOf($this$isToken))) return false;
        return true;
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Object object = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        TOKEN_EXTRA = SetsKt.setOf(object);
        object = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+'), Character.valueOf('/')};
        TOKEN68_EXTRA = SetsKt.setOf(object);
        object = "[a-zA-Z0-9\\-._~+/]+=*";
        boolean bl = false;
        token68Pattern = new Regex((String)object);
        object = "\\\\.";
        bl = false;
        escapeRegex = new Regex((String)object);
    }
}

