/*
 * Copyright 2019-2021 Mamoe Technologies and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license that can be found through the following link.
 *
 * https://github.com/mamoe/mirai/blob/dev/LICENSE
 */

package net.mamoe.mirai.utils

import kotlin.test.Test
import kotlin.test.assertEquals

internal class HtmlEscapeTest {
    @Test
    fun testDecode() {
        val ALL = "&#xCF;&#xBD;&#8719;&#xAB;&uuml;&#8901;&Phi;&#8707;&#8804;&ccedil;&#x203E;&#x2209;&Eta;&#246;&#234;&#222;&#210;&Ocirc;&#xAA;&rceil;&icirc;&nsub;&#xCE;&#xBC;&#8805;&szlig;&and;&iacute;&#x3E;&macr;&#235;&#223;&#211;&#xBB;&#x3BA;&#247;&clubs;&#xDF;&zeta;&#xCD;&#8709;&#9002;&eta;&Prime;&infin;&#92;&Ograve;&ecirc;&Oslash;&#x2308;&#220;&Iuml;&#244;&#x3BB;&spades;&#232;&phi;&#xCC;&deg;&#xBA;&#xDE;&#9001;&ograve;&Otilde;&prod;&#x3C;&trade;&#x2190;&perp;&#x391;&#x2309;&#245;&#233;&#221;&#x3BC;&#xDD;&#8482;&#xCB;&ordm;&ang;&#xEF;&empty;&#242;&#230;&#919;&#169;&Upsilon;&#254;&#x2665;&#xEE;&Epsilon;&#8592;&#xDC;&#x2229;&#xCA;&#x2217;&#x2205;&cup;&hArr;&ntilde;&eth;&Delta;&#8472;&#8593;&#231;&#8230;&Acirc;&#8242;&#8254;&#918;&#255;&#x2666;&#243;&Eacute;&#xFF;&#xED;&#xDB;&acirc;&or;&uArr;&curren;&divide;&para;&thorn;&epsilon;&#60;&#8594;&hearts;&otimes;&#x192;&#252;&lowast;&#240;&#8243;&#929;&#179;&#917;&#167;&#xFE;&#x2207;&#xEC;&#xDA;&plusmn;&Tau;&egrave;&yen;&#8595;&#253;&tau;&#241;&asymp;&#168;&#928;&#916;&#x2208;&#x2329;&#xFD;&#xEB;&uarr;&otilde;&reg;&#219;&#207;&#982;&#xE1;&Oacute;&#8747;&#62;&Ecirc;&#8711;&#xF3;&Iota;&psi;&int;&#206;&#x396;&#208;&upsilon;&middot;&ge;&sim;&#xF2;&#xE0;&#x221D;&#8736;&#x220B;&#8712;&ucirc;&#8869;&piv;&ETH;&sube;&Lambda;&oslash;&#x397;&#9824;&#x2282;&uml;&#229;&eacute;&Psi;&#8713;&#x221E;&#8834;&#xF1;&pound;&alefsym;&Ccedil;&lang;&frac34;&cent;&Iacute;&#9827;&ouml;&#228;&Nu;&#216;&Alpha;&#x398;&#204;&#x2295;&#x2283;&#218;&#8835;&#xF0;&#x230A;&sub;&#8629;&#8968;&laquo;&sigmaf;&part;&Xi;&#x399;&#x25CA;&#217;&nu;&#205;&copy;&darr;&#xAF;&beta;&cap;&igrave;&#8800;&#8969;&#x2191;&#8715;&#8836;&omicron;&#8727;&frac12;&#x392;&#x223C;&#x222A;&Rho;&xi;&#202;&#x3BD;&#9829;&#238;&#226;&#214;&Mu;&#xAE;&#x3BF;&#8801;&#x211C;&#x2192;&AElig;&#8704;&Atilde;&#x393;&#x222B;&kappa;&#x3BE;&delta;&#239;&#227;&supe;&#215;&#203;&fnof;&mu;&#xBF;&#xAD;&#x2193;&rho;&sdot;&Omicron;&#8838;&aelig;&frac14;&#x394;&#x221A;&#224;&#212;&#200;&aring;&frasl;&#248;&lt;&#236;&Auml;&#xBE;&#xAC;&#x2194;&Gamma;&Omega;&#8706;&#8839;&nbsp;&#x232A;&#213;&euml;&ordf;&#201;&#8260;&#249;&#237;&#x395;&#225;&#954;&#x2022;&Aacute;&#x2264;&atilde;&#xA1;&brvbar;&#x3C2;&#xE9;&#193;&#xD7;&#181;&#xC5;&#xB3;&#x21D3;&rArr;&#967;&#955;&#965;&Zeta;&#953;&yacute;&#x2265;&#x3C3;&#xB2;&#xA0;&#x3B1;&lambda;&#194;&#182;&#xE8;&#170;&Igrave;&#xD6;&#xC4;&#x21D4;&#10;&diams;&sum;&sigma;&#978;&#966;&#964;&#9830;&#x39A;&#952;&#x3D6;&#x3B2;&rarr;&#x3C4;&#8656;&#xC3;&#xB1;&#x3A0;&Theta;&#xF9;&#xE7;&#8970;&#191;&#xD5;&#8764;&#8776;&amp;&upsih;&#977;&gamma;&dArr;&image;&#963;&#x2122;&#x39B;&#951;&#x3C5;&#x3A1;&#8657;&#x3B3;&#xD4;&#xC2;&#xB0;&#192;&#xF8;&#180;&#xE6;&#8971;&ugrave;&#x2135;&#x2026;&#x2284;&prime;&#x2260;&#962;&#950;&#8658;&#x230B;&lceil;&#xE5;&#xD3;&#xC1;&Ugrave;&#xF7;&#8730;&exist;&equiv;&sup;&loz;&#x2261;&#961;&not;&#x2297;&Ucirc;&#8659;&#8744;&#8756;&#190;&#xF6;&#xE4;&sect;&#xD2;&#x220F;&#xC0;&#x3D1;&oacute;&#38;&#x21D0;&#8501;&#8743;&real;&#x2032;&#209;&#x2044;&yuml;&#960;&#x2286;&lArr;&#8733;&#8745;&#x3D2;&#xF5;&#xE3;&#xD1;&#x3C0;&#x21D1;&#8853;&#402;&#x2033;&oline;&#x2287;&#xD0;&#8746;&Uuml;&#8722;&aacute;&#8734;&#8855;&#x3C1;&#xF4;&#xE2;&weierp;&#8721;&iota;&larr;&#x21D2;&lfloor;&nabla;&#x2200;&#x2660;&auml;&#9674;&theta;&#8596;&iquest;&#165;&#xA9;&#x3B8;&#250;&#x3A6;&#xEA;&gt;&#189;&#927;&#177;&#915;&forall;&iexcl;&#xFC;&crarr;&Uacute;&cong;&isin;&#x3A7;&#xA8;&#x3B9;&#251;&#8476;&Ouml;&#xFB;&#178;&#x2202;&#166;&#926;&thetasym;&#914;&acute;&times;&harr;&cedil;&Pi;&shy;&bull;&#187;&#175;&#xB9;&#x3A8;&#163;&#xA7;&#8465;&#xFA;&#x2118;&#x2203;&minus;&#x2663;&#949;&#199;&#937;&#925;&#913;&#x2227;&Icirc;&raquo;&omega;&Agrave;&#x22A5;&Chi;&Beta;&ne;&pi;&agrave;&#x3A9;&#8660;&#176;&#164;&THORN;&#xB8;&#xA6;&#188;&#948;&chi;&#936;&#924;&#x2228;&#x39C;&#x2111;&#x2220;&#x3B4;&#x3C6;&oplus;&Yacute;&#161;&#xA5;&uacute;&#197;&#185;&#xC9;&#173;&#xB7;&alpha;&#959;&#x2245;&#947;&rfloor;&Euml;&#935;&notin;&#923;&Aring;&ocirc;&#921;&#x39D;&Kappa;&#x3A3;&#x3B5;&#xB6;&#xA4;&sup3;&#8226;&#198;&Ntilde;&#186;&#174;&#x3C7;&#162;&#xC8;&Sigma;&#x2234;&iuml;&#958;&#946;&micro;&#934;&#922;&#x26;&#932;&#920;&hellip;&Egrave;&#x3A4;&#x21B5;&#x39E;&#183;&#xC7;&#171;&#xB5;&#xA3;&sup2;&#x3B6;&#195;&#xD9;&#x3C8;&#969;&#957;&#945;&#933;&#931;&rang;&#x2211;&prop;&ni;&radic;&#x22C5;&le;&#x39F;&#172;&#xD8;&#160;&sup1;&#xC6;&#xB4;&#xA2;&#x3C9;&#196;&#x3A5;&#8773;&#184;&#x3B7;&#x2248;&there4;&#x2212;&#968;&#956;"
        val RESP = "\u00cf\u00bd\u220f\u00ab\u00fc\u22c5\u03a6\u2203\u2264\u00e7\u203e\u2209\u0397\u00f6\u00ea\u00de\u00d2\u00d4\u00aa\u2309\u00ee\u2284\u00ce\u00bc\u2265\u00df\u2227\u00ed\u003e\u00af\u00eb\u00df\u00d3\u00bb\u03ba\u00f7\u2663\u00df\u03b6\u00cd\u2205\u232a\u03b7\u2033\u221e\u005c\u00d2\u00ea\u00d8\u2308\u00dc\u00cf\u00f4\u03bb\u2660\u00e8\u03c6\u00cc\u00b0\u00ba\u00de\u2329\u00f2\u00d5\u220f\u003c\u2122\u2190\u22a5\u0391\u2309\u00f5\u00e9\u00dd\u03bc\u00dd\u2122\u00cb\u00ba\u2220\u00ef\u2205\u00f2\u00e6\u0397\u00a9\u03a5\u00fe\u2665\u00ee\u0395\u2190\u00dc\u2229\u00ca\u2217\u2205\u222a\u21d4\u00f1\u00f0\u0394\u2118\u2191\u00e7\u2026\u00c2\u2032\u203e\u0396\u00ff\u2666\u00f3\u00c9\u00ff\u00ed\u00db\u00e2\u2228\u21d1\u00a4\u00f7\u00b6\u00fe\u03b5\u003c\u2192\u2665\u2297\u0192\u00fc\u2217\u00f0\u2033\u03a1\u00b3\u0395\u00a7\u00fe\u2207\u00ec\u00da\u00b1\u03a4\u00e8\u00a5\u2193\u00fd\u03c4\u00f1\u2248\u00a8\u03a0\u0394\u2208\u2329\u00fd\u00eb\u2191\u00f5\u00ae\u00db\u00cf\u03d6\u00e1\u00d3\u222b\u003e\u00ca\u2207\u00f3\u0399\u03c8\u222b\u00ce\u0396\u00d0\u03c5\u00b7\u2265\u223c\u00f2\u00e0\u221d\u2220\u220b\u2208\u00fb\u22a5\u03d6\u00d0\u2286\u039b\u00f8\u0397\u2660\u2282\u00a8\u00e5\u00e9\u03a8\u2209\u221e\u2282\u00f1\u00a3\u2135\u00c7\u2329\u00be\u00a2\u00cd\u2663\u00f6\u00e4\u039d\u00d8\u0391\u0398\u00cc\u2295\u2283\u00da\u2283\u00f0\u230a\u2282\u21b5\u2308\u00ab\u03c2\u2202\u039e\u0399\u25ca\u00d9\u03bd\u00cd\u00a9\u2193\u00af\u03b2\u2229\u00ec\u2260\u2309\u2191\u220b\u2284\u03bf\u2217\u00bd\u0392\u223c\u222a\u03a1\u03be\u00ca\u03bd\u2665\u00ee\u00e2\u00d6\u039c\u00ae\u03bf\u2261\u211c\u2192\u00c6\u2200\u00c3\u0393\u222b\u03ba\u03be\u03b4\u00ef\u00e3\u2287\u00d7\u00cb\u0192\u03bc\u00bf\u00ad\u2193\u03c1\u22c5\u039f\u2286\u00e6\u00bc\u0394\u221a\u00e0\u00d4\u00c8\u00e5\u2044\u00f8\u003c\u00ec\u00c4\u00be\u00ac\u2194\u0393\u03a9\u2202\u2287\u00a0\u232a\u00d5\u00eb\u00aa\u00c9\u2044\u00f9\u00ed\u0395\u00e1\u03ba\u2022\u00c1\u2264\u00e3\u00a1\u00a6\u03c2\u00e9\u00c1\u00d7\u00b5\u00c5\u00b3\u21d3\u21d2\u03c7\u03bb\u03c5\u0396\u03b9\u00fd\u2265\u03c3\u00b2\u00a0\u03b1\u03bb\u00c2\u00b6\u00e8\u00aa\u00cc\u00d6\u00c4\u21d4\u000a\u2666\u2211\u03c3\u03d2\u03c6\u03c4\u2666\u039a\u03b8\u03d6\u03b2\u2192\u03c4\u21d0\u00c3\u00b1\u03a0\u0398\u00f9\u00e7\u230a\u00bf\u00d5\u223c\u2248\u0026\u03d2\u03d1\u03b3\u21d3\u2111\u03c3\u2122\u039b\u03b7\u03c5\u03a1\u21d1\u03b3\u00d4\u00c2\u00b0\u00c0\u00f8\u00b4\u00e6\u230b\u00f9\u2135\u2026\u2284\u2032\u2260\u03c2\u03b6\u21d2\u230b\u2308\u00e5\u00d3\u00c1\u00d9\u00f7\u221a\u2203\u2261\u2283\u25ca\u2261\u03c1\u00ac\u2297\u00db\u21d3\u2228\u2234\u00be\u00f6\u00e4\u00a7\u00d2\u220f\u00c0\u03d1\u00f3\u0026\u21d0\u2135\u2227\u211c\u2032\u00d1\u2044\u00ff\u03c0\u2286\u21d0\u221d\u2229\u03d2\u00f5\u00e3\u00d1\u03c0\u21d1\u2295\u0192\u2033\u203e\u2287\u00d0\u222a\u00dc\u2212\u00e1\u221e\u2297\u03c1\u00f4\u00e2\u2118\u2211\u03b9\u2190\u21d2\u230a\u2207\u2200\u2660\u00e4\u25ca\u03b8\u2194\u00bf\u00a5\u00a9\u03b8\u00fa\u03a6\u00ea\u003e\u00bd\u039f\u00b1\u0393\u2200\u00a1\u00fc\u21b5\u00da\u2245\u2208\u03a7\u00a8\u03b9\u00fb\u211c\u00d6\u00fb\u00b2\u2202\u00a6\u039e\u03d1\u0392\u00b4\u00d7\u2194\u00b8\u03a0\u00ad\u2022\u00bb\u00af\u00b9\u03a8\u00a3\u00a7\u2111\u00fa\u2118\u2203\u2212\u2663\u03b5\u00c7\u03a9\u039d\u0391\u2227\u00ce\u00bb\u03c9\u00c0\u22a5\u03a7\u0392\u2260\u03c0\u00e0\u03a9\u21d4\u00b0\u00a4\u00de\u00b8\u00a6\u00bc\u03b4\u03c7\u03a8\u039c\u2228\u039c\u2111\u2220\u03b4\u03c6\u2295\u00dd\u00a1\u00a5\u00fa\u00c5\u00b9\u00c9\u00ad\u00b7\u03b1\u03bf\u2245\u03b3\u230b\u00cb\u03a7\u2209\u039b\u00c5\u00f4\u0399\u039d\u039a\u03a3\u03b5\u00b6\u00a4\u00b3\u2022\u00c6\u00d1\u00ba\u00ae\u03c7\u00a2\u00c8\u03a3\u2234\u00ef\u03be\u03b2\u00b5\u03a6\u039a\u0026\u03a4\u0398\u2026\u00c8\u03a4\u21b5\u039e\u00b7\u00c7\u00ab\u00b5\u00a3\u00b2\u03b6\u00c3\u00d9\u03c8\u03c9\u03bd\u03b1\u03a5\u03a3\u232a\u2211\u221d\u220b\u221a\u22c5\u2264\u039f\u00ac\u00d8\u00a0\u00b9\u00c6\u00b4\u00a2\u03c9\u00c4\u03a5\u2245\u00b8\u03b7\u2248\u2234\u2212\u03c8\u03bc"
        assertEquals(
            RESP,
            ALL.decodeHtmlEscape()
        )
    }

    @Test
    fun testEncode() {
        val str = buildString {
            for (i in 1 until 2048) {
                append(i.toChar())
            }
        }
        val escaped = str.encodeHtmlEscape()
        // println(escaped)
        assertEquals(escaped.decodeHtmlEscape(), str)
    }
}