/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.DslMarker;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.mamoe.mirai.utils.ExceptionCollector;
import net.mamoe.mirai.utils.MiraiUtils;
import net.mamoe.mirai.utils.TestOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0007\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0006\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0007R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnet/mamoe/mirai/utils/ExceptionCollector;", "", "()V", "initial", "", "(Ljava/lang/Throwable;)V", "initials", "", "([Ljava/lang/Throwable;)V", "hashCodes", "", "", "last", "addSuppressed", "", "receiver", "e", "asSequence", "Lkotlin/sequences/Sequence;", "beforeCollect", "throwable", "collect", "", "collectException", "collectGet", "collectThrow", "", "exception", "dispose", "getLast", "hash", "", "element", "Ljava/lang/StackTraceElement;", "throwLast", "Companion", "TerminalOperation", "mirai-core-utils"})
public class ExceptionCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Throwable last;
    @NotNull
    private final Set<Long> hashCodes;

    public ExceptionCollector() {
        this.hashCodes = new LinkedHashSet();
    }

    public ExceptionCollector(@Nullable Throwable initial) {
        this.hashCodes = new LinkedHashSet();
        this.collect(initial);
    }

    public ExceptionCollector(Throwable ... initials) {
        Intrinsics.checkNotNullParameter((Object)initials, (String)"initials");
        this.hashCodes = new LinkedHashSet();
        for (Throwable initial : initials) {
            this.collect(initial);
        }
    }

    protected void beforeCollect(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
    }

    public final synchronized boolean collect(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (!this.hashCodes.add(this.hash(e))) {
            return false;
        }
        this.beforeCollect(e);
        Throwable throwable = this.last;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.addSuppressed(e, it);
        }
        this.last = e;
        return true;
    }

    protected void addSuppressed(@NotNull Throwable receiver, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ExceptionsKt.addSuppressed((Throwable)receiver, (Throwable)e);
    }

    /*
     * WARNING - void declaration
     */
    private final long hash(Throwable e) {
        void $this$fold$iv;
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
        Object[] objectArray = stackTraceElementArray;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void stackTraceElement;
            StackTraceElement stackTraceElement2 = (StackTraceElement)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            long l = acc * (long)31;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"stackTraceElement");
            accumulator$iv = l + MiraiUtils.toLongUnsigned(this.hash((StackTraceElement)stackTraceElement));
        }
        return accumulator$iv;
    }

    private final int hash(StackTraceElement element) {
        return Integer.hashCode(element.getLineNumber()) ^ element.getClassName().hashCode() ^ element.getMethodName().hashCode();
    }

    @NotNull
    public final Throwable collectGet(@Nullable Throwable e) {
        this.collect(e);
        Throwable throwable = this.getLast();
        Intrinsics.checkNotNull((Object)throwable);
        return throwable;
    }

    public final boolean collectException(@Nullable Throwable e) {
        return this.collect(e);
    }

    @Nullable
    public final Throwable getLast() {
        return this.last;
    }

    @TerminalOperation
    @NotNull
    public final Void collectThrow(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.collect(exception);
        Throwable throwable = this.getLast();
        Intrinsics.checkNotNull((Object)throwable);
        throw throwable;
    }

    @TerminalOperation
    @NotNull
    public final Void throwLast() {
        Throwable throwable = this.getLast();
        if (throwable == null) {
            throw new IllegalStateException("Internal error: expected at least one exception collected.".toString());
        }
        throw throwable;
    }

    @TestOnly
    @NotNull
    public final Sequence<Throwable> asSequence() {
        Throwable throwable = this.getLast();
        if (throwable == null) {
            return SequencesKt.emptySequence();
        }
        Throwable last = throwable;
        return (Sequence)new Sequence<Throwable>(last){
            final /* synthetic */ Throwable $last$inlined;
            {
                this.$last$inlined = throwable;
            }

            @NotNull
            public Iterator<Throwable> iterator() {
                boolean bl = false;
                return ExceptionCollector.access$asSequence$itr(this.$last$inlined);
            }
        };
    }

    public final synchronized void dispose() {
        this.last = null;
        this.hashCodes.clear();
    }

    private static final Iterator<Throwable> asSequence$itr(Throwable $this$asSequence_u24itr) {
        Object[] objectArray = new Throwable[]{$this$asSequence_u24itr};
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
        Throwable[] throwableArray = $this$asSequence_u24itr.getSuppressed();
        Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"this.suppressed");
        return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])throwableArray), (Function1)asSequence.itr.1.INSTANCE)).iterator();
    }

    public static final /* synthetic */ Iterator access$asSequence$itr(Throwable $receiver) {
        return ExceptionCollector.asSequence$itr($receiver);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lnet/mamoe/mirai/utils/ExceptionCollector$TerminalOperation;", "", "mirai-core-utils"})
    @DslMarker
    private static @interface TerminalOperation {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lnet/mamoe/mirai/utils/ExceptionCollector$Companion;", "", "()V", "compressExceptions", "", "exceptions", "", "([Ljava/lang/Throwable;)Ljava/lang/Throwable;", "exception", "(Ljava/lang/Throwable;[Ljava/lang/Throwable;)Ljava/lang/Throwable;", "mirai-core-utils"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Throwable compressExceptions(@NotNull Throwable[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
            return new ExceptionCollector(Arrays.copyOf(exceptions, exceptions.length)).getLast();
        }

        @NotNull
        public final Throwable compressExceptions(@NotNull Throwable exception, Throwable ... exceptions) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)exception);
            spreadBuilder.addSpread((Object)exceptions);
            Throwable throwable = new ExceptionCollector((Throwable[])spreadBuilder.toArray((Object[])new Throwable[spreadBuilder.size()])).getLast();
            Intrinsics.checkNotNull((Object)throwable);
            return throwable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

