/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/mamoe/mirai/internal/deps/io/ktor/utils/io/core/internal/CharArraySequence;", "", "array", "", "offset", "", "length", "([CII)V", "getLength", "()I", "get", "", "index", "indexOutOfBounds", "", "subSequence", "startIndex", "endIndex", "ktor-io"})
public final class CharArraySequence
implements CharSequence {
    @NotNull
    private final char[] array;
    private final int offset;
    private final int length;

    public CharArraySequence(@NotNull char[] array, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    public final char get(int index) {
        if (index >= this.length) {
            this.indexOutOfBounds(index);
            throw new KotlinNothingValueException();
        }
        return this.array[index + this.offset];
    }

    @Override
    @NotNull
    public final CharSequence subSequence(int startIndex, int endIndex) {
        if (!(startIndex >= 0)) {
            boolean $i$a$-require-CharArraySequence$subSequence$52 = false;
            String $i$a$-require-CharArraySequence$subSequence$52 = "startIndex shouldn't be negative: " + startIndex;
            throw new IllegalArgumentException($i$a$-require-CharArraySequence$subSequence$52.toString());
        }
        if (!(startIndex <= this.length)) {
            boolean $i$a$-require-CharArraySequence$subSequence$62 = false;
            String $i$a$-require-CharArraySequence$subSequence$62 = "startIndex is too large: " + startIndex + " > " + this.length;
            throw new IllegalArgumentException($i$a$-require-CharArraySequence$subSequence$62.toString());
        }
        if (!(startIndex + endIndex <= this.length)) {
            boolean $i$a$-require-CharArraySequence$subSequence$72 = false;
            String $i$a$-require-CharArraySequence$subSequence$72 = "endIndex is too large: " + endIndex + " > " + this.length;
            throw new IllegalArgumentException($i$a$-require-CharArraySequence$subSequence$72.toString());
        }
        if (!(endIndex >= startIndex)) {
            boolean bl = false;
            String string = "endIndex should be greater or equal to startIndex: " + startIndex + " > " + endIndex;
            throw new IllegalArgumentException(string.toString());
        }
        return new CharArraySequence(this.array, this.offset + startIndex, endIndex - startIndex);
    }

    private final Void indexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException("String index out of bounds: " + index + " > " + this.length);
    }
}

