/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.ExternalResourceHolder;
import net.mamoe.mirai.internal.utils.ExternalResourceImplsKt;
import net.mamoe.mirai.internal.utils.ExternalResourceInternal;
import net.mamoe.mirai.internal.utils.ExternalResourceLeakObserver;
import net.mamoe.mirai.utils.ExternalResource;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/mamoe/mirai/internal/utils/ExternalResourceLeakObserver;", "Ljava/lang/Runnable;", "()V", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "logger$delegate", "Lkotlin/Lazy;", "queue", "Ljava/lang/ref/ReferenceQueue;", "", "references", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lnet/mamoe/mirai/internal/utils/ExternalResourceLeakObserver$ERReference;", "register", "", "resource", "Lnet/mamoe/mirai/utils/ExternalResource;", "holder", "Lnet/mamoe/mirai/internal/utils/ExternalResourceHolder;", "run", "ERReference", "ExternalResourceCreateStackTrace", "mirai-core-api"})
public final class ExternalResourceLeakObserver
implements Runnable {
    @NotNull
    public static final ExternalResourceLeakObserver INSTANCE = new ExternalResourceLeakObserver();
    @NotNull
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    @NotNull
    private static final ConcurrentLinkedDeque<ERReference> references = new ConcurrentLinkedDeque();
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private ExternalResourceLeakObserver() {
    }

    private final MiraiLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (MiraiLogger)lazy.getValue();
    }

    @JvmStatic
    public static final void register(@NotNull ExternalResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (!(resource instanceof ExternalResourceInternal)) {
            return;
        }
        references.add(new ERReference((ExternalResourceInternal)resource));
    }

    @JvmStatic
    public static final void register(@NotNull ExternalResource resource, @NotNull ExternalResourceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        references.add(new ERReference(resource, holder));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (queue.poll() != null) {
                    Object $i$a$-runCatching-ExternalResourceLeakObserver$run$52;
                    ExternalResourceCreateStackTrace externalResourceCreateStackTrace;
                    Reference<Object> reference;
                    if (!(reference instanceof ERReference)) {
                        MiraiLogger $this$warning$iv = this.getLogger();
                        boolean $i$f$warning = false;
                        if ($this$warning$iv.isWarningEnabled()) {
                            MiraiLogger miraiLogger = $this$warning$iv;
                            boolean bl = false;
                            miraiLogger.warning("Unknown reference " + reference + " (#" + reference.getClass() + ") was entered queue. Skipping");
                        }
                        reference.clear();
                        continue;
                    }
                    ExternalResourceHolder holder = ((ERReference)reference).holder;
                    reference.clear();
                    references.remove(reference);
                    if (holder.isClosed()) continue;
                    if (holder.getCreateStackTrace() != null) {
                        StackTraceElement[] stack;
                        ExternalResourceCreateStackTrace externalResourceCreateStackTrace2;
                        boolean bl = false;
                        ExternalResourceCreateStackTrace it = externalResourceCreateStackTrace2 = new ExternalResourceCreateStackTrace();
                        boolean bl2 = false;
                        it.setStackTrace(stack);
                        externalResourceCreateStackTrace = externalResourceCreateStackTrace2;
                    } else {
                        externalResourceCreateStackTrace = null;
                    }
                    ExternalResourceCreateStackTrace stackException = externalResourceCreateStackTrace;
                    try {
                        boolean $i$a$-runCatching-ExternalResourceLeakObserver$run$52 = false;
                        MiraiLogger $this$error$iv = INSTANCE.getLogger();
                        boolean $i$f$error = false;
                        if ($this$error$iv.isErrorEnabled()) {
                            MiraiLogger bl = $this$error$iv;
                            boolean bl3 = false;
                            bl.error("A resource leak occurred, use ExternalResource.close to avoid it!! (holder=" + holder + ')' + (ExternalResourceImplsKt.isExternalResourceCreationStackEnabled() ? "" : ". Add jvm option `-Dmirai.resource.creation.stack.enabled=true` to show creation stack track"), stackException);
                        }
                        $i$a$-runCatching-ExternalResourceLeakObserver$run$52 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable $this$error$iv) {
                        $i$a$-runCatching-ExternalResourceLeakObserver$run$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$error$iv));
                    }
                    try {
                        holder.close();
                    }
                    catch (Throwable exceptionInClose) {
                        Object object;
                        try {
                            void $this$error$iv;
                            Throwable bl;
                            boolean bl4 = false;
                            MiraiLogger $i$f$error = INSTANCE.getLogger();
                            Throwable it = bl = exceptionInClose;
                            boolean bl5 = false;
                            if (stackException != null) {
                                ExceptionsKt.addSuppressed((Throwable)it, (Throwable)stackException);
                            }
                            boolean $i$f$error2 = false;
                            if ($this$error$iv.isErrorEnabled()) {
                                void e$iv;
                                void var10_28 = $this$error$iv;
                                boolean bl6 = false;
                                var10_28.error("Exception in closing a leaked resource (holder=" + holder + ')', (Throwable)e$iv);
                            }
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object object;
                try {
                    boolean bl = false;
                    INSTANCE.getLogger().error("Exception in queue loop", throwable);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
            }
            Thread.sleep(60000L);
        }
    }

    static {
        Thread thread = new Thread((Runnable)INSTANCE, "Mirai ExternalResource Leak Observer Thread");
        thread.setDaemon(true);
        thread.start();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/mamoe/mirai/internal/utils/ExternalResourceLeakObserver$ERReference;", "Ljava/lang/ref/WeakReference;", "", "resource", "Lnet/mamoe/mirai/internal/utils/ExternalResourceInternal;", "(Lnet/mamoe/mirai/internal/utils/ExternalResourceInternal;)V", "Lnet/mamoe/mirai/utils/ExternalResource;", "holder", "Lnet/mamoe/mirai/internal/utils/ExternalResourceHolder;", "(Lnet/mamoe/mirai/utils/ExternalResource;Lnet/mamoe/mirai/internal/utils/ExternalResourceHolder;)V", "mirai-core-api"})
    public static final class ERReference
    extends WeakReference<Object> {
        @JvmField
        @NotNull
        public final ExternalResourceHolder holder;

        public ERReference(@NotNull ExternalResourceInternal resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            super(resource, queue);
            this.holder = resource.getHolder();
        }

        public ERReference(@NotNull ExternalResource resource, @NotNull ExternalResourceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(resource, queue);
            this.holder = holder;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016\u00a8\u0006\u0004"}, d2={"Lnet/mamoe/mirai/internal/utils/ExternalResourceLeakObserver$ExternalResourceCreateStackTrace;", "", "()V", "fillInStackTrace", "mirai-core-api"})
    public static final class ExternalResourceCreateStackTrace
    extends Throwable {
        @Override
        @NotNull
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

