/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import net.mamoe.mirai.internal.network.ContactListCacheKt;
import net.mamoe.mirai.internal.network.component.ComponentStorage;
import net.mamoe.mirai.internal.network.components.BdhSession;
import net.mamoe.mirai.internal.network.components.BdhSessionSyncer;
import net.mamoe.mirai.internal.network.components.BdhSessionSyncerKt;
import net.mamoe.mirai.internal.network.components.ServerAddress;
import net.mamoe.mirai.internal.network.components.ServerList;
import net.mamoe.mirai.internal.utils.BotConfigurationExtKt;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\""}, d2={"Lnet/mamoe/mirai/internal/network/components/BdhSessionSyncerImpl;", "Lnet/mamoe/mirai/internal/network/components/BdhSessionSyncer;", "configuration", "Lnet/mamoe/mirai/utils/BotConfiguration;", "context", "Lnet/mamoe/mirai/internal/network/component/ComponentStorage;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/utils/BotConfiguration;Lnet/mamoe/mirai/internal/network/component/ComponentStorage;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "bdhSession", "Lkotlinx/coroutines/CompletableDeferred;", "Lnet/mamoe/mirai/internal/network/components/BdhSession;", "getBdhSession", "()Lkotlinx/coroutines/CompletableDeferred;", "setBdhSession", "(Lkotlinx/coroutines/CompletableDeferred;)V", "hasSession", "", "getHasSession", "()Z", "serverListCacheFile", "Ljava/io/File;", "getServerListCacheFile", "()Ljava/io/File;", "sessionCacheFile", "getSessionCacheFile", "loadFromCache", "", "loadServerListFromCache", "overrideSession", "session", "doSave", "saveServerListToCache", "saveToCache", "mirai-core"})
public final class BdhSessionSyncerImpl
implements BdhSessionSyncer {
    @NotNull
    private final BotConfiguration configuration;
    @NotNull
    private final ComponentStorage context;
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private volatile CompletableDeferred<BdhSession> bdhSession;

    public BdhSessionSyncerImpl(@NotNull BotConfiguration configuration, @NotNull ComponentStorage context, @NotNull MiraiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.configuration = configuration;
        this.context = context;
        this.logger = logger;
        this.bdhSession = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @Override
    @NotNull
    public CompletableDeferred<BdhSession> getBdhSession() {
        return this.bdhSession;
    }

    public void setBdhSession(@NotNull CompletableDeferred<BdhSession> completableDeferred) {
        Intrinsics.checkNotNullParameter(completableDeferred, (String)"<set-?>");
        this.bdhSession = completableDeferred;
    }

    @Override
    public boolean getHasSession() {
        Object object;
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            BdhSession bdhSession = (BdhSession)this.getBdhSession().getCompleted();
            boolean bl3 = false;
            object = Result.constructor-impl((Object)bdhSession);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    @Override
    public void overrideSession(@NotNull BdhSession session, boolean doSave) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.getBdhSession().complete((Object)session);
        this.setBdhSession((CompletableDeferred<BdhSession>)CompletableDeferredKt.CompletableDeferred((Object)session));
        if (doSave) {
            this.saveToCache();
        }
    }

    private final File getSessionCacheFile() {
        return FilesKt.resolve((File)BotConfigurationExtKt.actualCacheDir(this.configuration), (String)"session.bin");
    }

    private final File getServerListCacheFile() {
        return FilesKt.resolve((File)BotConfigurationExtKt.actualCacheDir(this.configuration), (String)"servers.json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadServerListFromCache() {
        File serverListCacheFile = this.getServerListCacheFile();
        if (serverListCacheFile.isFile()) {
            Object object;
            Object object2;
            this.logger.verbose("Loading server list from cache.");
            boolean bl = false;
            try {
                Collection<ServerAddress> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object2 = Result.Companion;
                boolean bl2 = false;
                Set list2 = (Set)ContactListCacheKt.getJsonForCache().decodeFromString((DeserializationStrategy)BdhSessionSyncerKt.access$getServerListSerializer$p(), FilesKt.readText$default((File)serverListCacheFile, null, (int)1, null));
                Iterable iterable = list2;
                object = (ServerList)this.context.get(ServerList.Companion);
                boolean $i$f$map = false;
                void var9_20 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ServerAddress serverAddress = (ServerAddress)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    ServerAddress serverAddress2 = new ServerAddress(it.getHost(), it.getPort());
                    collection.add(serverAddress2);
                }
                collection = (List)destination$iv$iv;
                object.setPreferred(collection);
                Unit unit = Unit.INSTANCE;
                boolean bl4 = false;
                object2 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object2;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl8 = false;
                boolean bl9 = false;
                object = throwable2;
                boolean bl10 = false;
                Object it = object;
                boolean bl11 = false;
                this.logger.warning("Error in loading server list from cache", (Throwable)it);
            }
        } else {
            this.logger.verbose("No server list cached.");
        }
    }

    @Override
    public void loadFromCache() {
        File sessionCacheFile = this.getSessionCacheFile();
        if (sessionCacheFile.isFile()) {
            boolean bl;
            boolean bl2;
            Object object;
            this.logger.verbose("Loading BdhSession from cache file");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                this.overrideSession((BdhSession)ContactListCacheKt.getProtoBufForCache().decodeFromByteArray((DeserializationStrategy)BdhSession.Companion.serializer(), FilesKt.readBytes((File)sessionCacheFile)), false);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                bl2 = false;
                bl = false;
                Throwable throwable3 = throwable2;
                boolean bl7 = false;
                Throwable it = throwable3;
                boolean bl8 = false;
                boolean bl9 = false;
                try {
                    Object object3 = Result.Companion;
                    boolean bl10 = false;
                    Boolean bl11 = sessionCacheFile.delete();
                    boolean bl12 = false;
                    object3 = Result.constructor-impl((Object)bl11);
                }
                catch (Throwable throwable4) {
                    Result.Companion companion = Result.Companion;
                    boolean bl13 = false;
                    Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                }
                this.logger.warning("Error in loading BdhSession from cache", it);
            }
        } else {
            this.logger.verbose("No BdhSession cache");
        }
    }

    @Override
    public void saveServerListToCache() {
        block3: {
            boolean bl;
            boolean bl2;
            Object object;
            File serverListCacheFile = this.getServerListCacheFile();
            File file = serverListCacheFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            this.logger.verbose("Saving server list to cache");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                FilesKt.writeText$default((File)serverListCacheFile, (String)ContactListCacheKt.getJsonForCache().encodeToString((SerializationStrategy)BdhSessionSyncerKt.access$getServerListSerializer$p(), ((ServerList)this.context.get(ServerList.Companion)).getPreferred()), null, (int)2, null);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warning("Error in saving ServerList to cache.", it);
        }
    }

    @Override
    public void saveToCache() {
        File sessionCacheFile = this.getSessionCacheFile();
        File file = sessionCacheFile.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        if (this.getBdhSession().isCompleted()) {
            boolean bl;
            boolean bl2;
            Object object;
            this.logger.verbose("Saving bdh session to cache");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                FilesKt.writeBytes((File)sessionCacheFile, (byte[])ContactListCacheKt.getProtoBufForCache().encodeToByteArray((SerializationStrategy)BdhSession.Companion.serializer(), this.getBdhSession().getCompleted()));
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                bl2 = false;
                bl = false;
                Throwable throwable3 = throwable2;
                boolean bl7 = false;
                Throwable it = throwable3;
                boolean bl8 = false;
                this.logger.warning("Error in saving BdhSession to cache.", it);
            }
        } else {
            sessionCacheFile.delete();
            this.logger.verbose("No BdhSession to save to cache");
        }
    }
}

