/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.handler.state;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.network.handler.NetworkHandler;
import net.mamoe.mirai.internal.network.handler.NetworkHandlerSupport;
import net.mamoe.mirai.internal.network.handler.state.SafeStateObserver;
import net.mamoe.mirai.internal.network.handler.state.StateObserver;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u000eR\u00020\u000f2\n\u0010\u0015\u001a\u00060\u000eR\u00020\u000fH\u0016J\u001c\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0016J$\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u000eR\u00020\u000f2\n\u0010\u0015\u001a\u00060\u000eR\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lnet/mamoe/mirai/internal/network/handler/state/LoggingStateObserver;", "Lnet/mamoe/mirai/internal/network/handler/state/StateObserver;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "showStacktrace", "", "(Lnet/mamoe/mirai/utils/MiraiLogger;Z)V", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "afterStateResume", "", "networkHandler", "Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;", "state", "Lnet/mamoe/mirai/internal/network/handler/NetworkHandlerSupport$BaseStateImpl;", "Lnet/mamoe/mirai/internal/network/handler/NetworkHandlerSupport;", "result", "Lkotlin/Result;", "(Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;Lnet/mamoe/mirai/internal/network/handler/NetworkHandlerSupport$BaseStateImpl;Ljava/lang/Object;)V", "beforeStateChanged", "previous", "new", "beforeStateResume", "exceptionOnCreatingNewState", "previousState", "exception", "", "stateChanged", "toString", "", "Companion", "mirai-core"})
public final class LoggingStateObserver
implements StateObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MiraiLogger logger;
    private final boolean showStacktrace;
    @NotNull
    private static String ENABLED;

    public LoggingStateObserver(@NotNull MiraiLogger logger, boolean showStacktrace) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.showStacktrace = showStacktrace;
    }

    public /* synthetic */ LoggingStateObserver(MiraiLogger miraiLogger, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(miraiLogger, bl);
    }

    @NotNull
    public final MiraiLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public String toString() {
        return "LoggingStateObserver(logger=" + this.logger.getIdentity() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeStateChanged(@NotNull NetworkHandlerSupport networkHandler, @NotNull NetworkHandlerSupport.BaseStateImpl previous, @NotNull NetworkHandlerSupport.BaseStateImpl baseStateImpl) {
        void $this$debug$iv;
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)baseStateImpl, (String)"new");
        MiraiLogger miraiLogger = this.logger;
        Throwable throwable = this.showStacktrace ? new Exception("Show stacktrace") : null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            void e$iv;
            void var8_7 = $this$debug$iv;
            boolean bl = false;
            String string = "Before change: " + (Object)((Object)previous.getCorrespondingState()) + " -> " + (Object)((Object)baseStateImpl.getCorrespondingState());
            var8_7.debug(string, (Throwable)e$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stateChanged(@NotNull NetworkHandlerSupport networkHandler, @NotNull NetworkHandlerSupport.BaseStateImpl previous, @NotNull NetworkHandlerSupport.BaseStateImpl baseStateImpl) {
        void $this$debug$iv;
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)baseStateImpl, (String)"new");
        MiraiLogger miraiLogger = this.logger;
        Throwable throwable = this.showStacktrace ? new Exception("Show stacktrace") : null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            void e$iv;
            void var8_7 = $this$debug$iv;
            boolean bl = false;
            String string = "State changed: " + (Object)((Object)previous.getCorrespondingState()) + " -> " + (Object)((Object)baseStateImpl.getCorrespondingState());
            var8_7.debug(string, (Throwable)e$iv);
        }
    }

    @Override
    public void exceptionOnCreatingNewState(@NotNull NetworkHandlerSupport networkHandler, @NotNull NetworkHandlerSupport.BaseStateImpl previousState, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)previousState, (String)"previousState");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$debug$iv;
            boolean bl = false;
            String string = "State changed: " + (Object)((Object)previousState.getCorrespondingState()) + " -> " + exception;
            miraiLogger.debug(string);
        }
    }

    @Override
    public void beforeStateResume(@NotNull NetworkHandler networkHandler, @NotNull NetworkHandlerSupport.BaseStateImpl state) {
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$debug$iv;
            boolean bl = false;
            String string = "State resuming: " + (Object)((Object)state.getCorrespondingState()) + '.';
            miraiLogger.debug(string);
        }
    }

    @Override
    public void afterStateResume(@NotNull NetworkHandler networkHandler, @NotNull NetworkHandlerSupport.BaseStateImpl state, @NotNull Object result2) {
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = result2;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            Unit it = (Unit)object;
            boolean bl3 = false;
            MiraiLogger $this$debug$iv = this.getLogger();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isEnabled()) {
                MiraiLogger miraiLogger = $this$debug$iv;
                boolean bl4 = false;
                String string = "State resumed: " + (Object)((Object)state.getCorrespondingState()) + '.';
                miraiLogger.debug(string);
            }
        } else {
            Throwable it = throwable;
            boolean bl5 = false;
            MiraiLogger $this$debug$iv = this.getLogger();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isEnabled()) {
                MiraiLogger miraiLogger = $this$debug$iv;
                boolean bl6 = false;
                String string = "State resumed: " + (Object)((Object)state.getCorrespondingState()) + ' ' + Result.exceptionOrNull-impl((Object)result2);
                miraiLogger.debug(string);
            }
        }
    }

    static {
        String string = MiraiUtils.systemProp((String)"mirai.debug.network.state.observer.logging", (String)"off");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        ENABLED = string3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/mamoe/mirai/internal/network/handler/state/LoggingStateObserver$Companion;", "", "()V", "ENABLED", "", "getENABLED", "()Ljava/lang/String;", "setENABLED", "(Ljava/lang/String;)V", "createLoggingIfEnabled", "Lnet/mamoe/mirai/internal/network/handler/state/StateObserver;", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getENABLED() {
            return ENABLED;
        }

        public final void setENABLED(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            ENABLED = string;
        }

        @Nullable
        public final StateObserver createLoggingIfEnabled() {
            StateObserver stateObserver;
            switch (this.getENABLED()) {
                case "full": {
                    stateObserver = new SafeStateObserver(new LoggingStateObserver(MiraiLogger.Companion.create("States"), true), MiraiLogger.Companion.create("LoggingStateObserver errors"));
                    break;
                }
                case "true": 
                case "on": {
                    stateObserver = new SafeStateObserver(new LoggingStateObserver(MiraiLogger.Companion.create("States"), false), MiraiLogger.Companion.create("LoggingStateObserver errors"));
                    break;
                }
                default: {
                    stateObserver = null;
                }
            }
            return stateObserver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

