/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.handler.selector;

import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.YieldKt;
import net.mamoe.mirai.internal.network.handler.NetworkHandler;
import net.mamoe.mirai.internal.network.handler.NetworkHandlerKt;
import net.mamoe.mirai.internal.network.handler.selector.AbstractKeepAliveNetworkHandlerSelector;
import net.mamoe.mirai.internal.network.handler.selector.MaxAttemptsReachedException;
import net.mamoe.mirai.internal.network.handler.selector.NetworkHandlerSelector;
import net.mamoe.mirai.network.LoginFailedException;
import net.mamoe.mirai.network.RetryLaterException;
import net.mamoe.mirai.utils.ExceptionCollector;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import net.mamoe.mirai.utils.TestOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\b \u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0017\u0018B\u0017\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00028\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00028\u0000H\u0086\u0010\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000H\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lnet/mamoe/mirai/internal/network/handler/selector/AbstractKeepAliveNetworkHandlerSelector;", "H", "Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;", "Lnet/mamoe/mirai/internal/network/handler/selector/NetworkHandlerSelector;", "maxAttempts", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(ILnet/mamoe/mirai/utils/MiraiLogger;)V", "current", "Lkotlinx/atomicfu/AtomicRef;", "awaitResumeInstance", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createInstance", "()Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;", "getCurrentInstanceOrCreate", "getCurrentInstanceOrNull", "refreshInstance", "", "setCurrent", "h", "setCurrent$mirai_core", "(Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;)V", "AwaitResumeInstance", "Companion", "mirai-core"})
public abstract class AbstractKeepAliveNetworkHandlerSelector<H extends NetworkHandler>
implements NetworkHandlerSelector<H> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxAttempts;
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private final AtomicRef<H> current;
    @JvmField
    public static int DEFAULT_MAX_ATTEMPTS = (int)RangesKt.coerceIn((long)MiraiUtils.systemProp((String)"mirai.network.handler.selector.max.attempts", (long)Long.MAX_VALUE), (ClosedRange)((ClosedRange)new LongRange(1L, MiraiUtils.toLongUnsigned((int)Integer.MAX_VALUE))));
    @JvmField
    public static long RECONNECT_DELAY = MiraiUtils.systemProp((String)"mirai.network.reconnect.delay", (long)3000L);
    @JvmField
    public static boolean SELECTOR_LOGGING = MiraiUtils.systemProp((String)"mirai.network.handle.selector.logging", (boolean)false);

    public AbstractKeepAliveNetworkHandlerSelector(int maxAttempts, @NotNull MiraiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.maxAttempts = maxAttempts;
        this.logger = logger;
        boolean bl = this.maxAttempts >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxAttempts must >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.current = AtomicFU.atomic(null);
    }

    public /* synthetic */ AbstractKeepAliveNetworkHandlerSelector(int n, MiraiLogger miraiLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = DEFAULT_MAX_ATTEMPTS;
        }
        this(n, miraiLogger);
    }

    @TestOnly
    public final void setCurrent$mirai_core(@NotNull H h) {
        Intrinsics.checkNotNullParameter(h, (String)"h");
        this.current.setValue(h);
    }

    @NotNull
    protected abstract H createInstance();

    @Override
    @Nullable
    public final H getCurrentInstanceOrNull() {
        return (H)((NetworkHandler)this.current.getValue());
    }

    @Override
    @NotNull
    public final H getCurrentInstanceOrCreate() {
        AbstractKeepAliveNetworkHandlerSelector abstractKeepAliveNetworkHandlerSelector = this;
        while (true) {
            AbstractKeepAliveNetworkHandlerSelector abstractKeepAliveNetworkHandlerSelector2;
            H h;
            if ((h = (abstractKeepAliveNetworkHandlerSelector2 = abstractKeepAliveNetworkHandlerSelector).getCurrentInstanceOrNull()) != null) {
                H h2 = h;
                boolean bl = false;
                boolean bl2 = false;
                H it = h2;
                boolean bl3 = false;
                return it;
            }
            abstractKeepAliveNetworkHandlerSelector2.refreshInstance();
            abstractKeepAliveNetworkHandlerSelector = abstractKeepAliveNetworkHandlerSelector2;
        }
    }

    @Override
    @Nullable
    public final Object awaitResumeInstance(@NotNull Continuation<? super H> $completion) {
        return new AwaitResumeInstance().run($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshInstance() {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            if (this.getCurrentInstanceOrNull() == null) {
                this.current.compareAndSet(null, this.createInstance());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ int access$getMaxAttempts$p(AbstractKeepAliveNetworkHandlerSelector $this) {
        return $this.maxAttempts;
    }

    public static final /* synthetic */ AtomicRef access$getCurrent$p(AbstractKeepAliveNetworkHandlerSelector $this) {
        return $this.current;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0082\bJ\u0011\u0010\u000e\u001a\u00028\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00028\u0000H\u0082P\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lnet/mamoe/mirai/internal/network/handler/selector/AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance;", "", "(Lnet/mamoe/mirai/internal/network/handler/selector/AbstractKeepAliveNetworkHandlerSelector;)V", "attempted", "", "exceptionCollector", "Lnet/mamoe/mirai/utils/ExceptionCollector;", "lastNetwork", "Lnet/mamoe/mirai/internal/network/handler/NetworkHandler;", "logIfEnabled", "", "block", "Lkotlin/Function0;", "", "run", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runImpl", "mirai-core"})
    private final class AwaitResumeInstance {
        private int attempted;
        @Nullable
        private H lastNetwork;
        @NotNull
        private final ExceptionCollector exceptionCollector;

        public AwaitResumeInstance() {
            Intrinsics.checkNotNullParameter((Object)AbstractKeepAliveNetworkHandlerSelector.this, (String)"this$0");
            this.exceptionCollector = new ExceptionCollector(this){
                final /* synthetic */ AwaitResumeInstance this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void beforeCollect(@NotNull Throwable throwable) {
                    MiraiLogger miraiLogger;
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    NetworkHandler networkHandler = AwaitResumeInstance.access$getLastNetwork$p(this.this$0);
                    if (networkHandler != null && (miraiLogger = NetworkHandlerKt.getLogger(networkHandler)) != null) {
                        miraiLogger.warning(throwable);
                    }
                }
            };
        }

        private final void logIfEnabled(Function0<String> block) {
            boolean $i$f$logIfEnabled = false;
            if (SELECTOR_LOGGING) {
                MiraiLogger $this$debug$iv = AbstractKeepAliveNetworkHandlerSelector.this.logger;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$debug$iv;
                    boolean bl = false;
                    String string = "Attempt #" + this.attempted + ": " + (String)block.invoke();
                    miraiLogger.debug(string);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object run(@NotNull Continuation<? super H> var1_1) {
            if (!(var1_1 instanceof run.1)) ** GOTO lbl-1000
            var8_2 = var1_1;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AwaitResumeInstance this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.run((Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.runImpl((Continuation<? super H>)$continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (AwaitResumeInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    var2_5 = v0;
                    var3_6 = false;
                    var4_7 = false;
                    it = (NetworkHandler)var2_5;
                    $i$a$-also-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$run$2 = false;
                    this.exceptionCollector.dispose();
                    this.lastNetwork = null;
                    return var2_5;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private final Object runImpl(Continuation<? super H> var1_1) {
            if (!(var1_1 instanceof runImpl.1)) ** GOTO lbl-1000
            var18_2 = var1_1;
            if ((var18_2.label & -2147483648) != 0) {
                var18_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AwaitResumeInstance this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AwaitResumeInstance.access$runImpl(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var2_5 = this;
                    break;
                }
                case 1: {
                    var3_6 = (AwaitResumeInstance)$continuation.L$1;
                    this = (AwaitResumeInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl121
                }
                case 2: {
                    var3_6 = (AwaitResumeInstance)$continuation.L$1;
                    this = (AwaitResumeInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl25:
                    // 3 sources

                    while (true) {
                        this_$iv = var3_6;
                        ++this_$iv.attempted;
                        var2_5 = var3_6;
                        break block0;
                        break;
                    }
                }
                case 3: {
                    var3_6 = (AwaitResumeInstance)$continuation.L$1;
                    this = (AwaitResumeInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    while (true) {
                        var2_5 = var3_6;
                        break block0;
                        break;
                    }
                }
                case 4: {
                    var4_7 = (NetworkHandler)$continuation.L$1;
                    var3_6 = (AwaitResumeInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    while (true) {
                        this_$iv = var3_6;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING == false) return var4_7;
                        $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                        $i$f$debug = false;
                        if ($this$debug$iv$iv.isEnabled() == false) return var4_7;
                        $i$f$debug = $this$debug$iv$iv;
                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                        var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$10 = false;
                        var16_90 = "RETURN";
                        var13_86 = var15_89.append(var16_90).toString();
                        $i$f$debug.debug(var13_86);
                        return var4_7;
                    }
                }
                default: {
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
            }
            while (true) {
                block42: {
                    var3_6 = var2_5;
                    if (var3_6.attempted >= AbstractKeepAliveNetworkHandlerSelector.access$getMaxAttempts$p(AbstractKeepAliveNetworkHandlerSelector.this)) {
                        var4_7 = var3_6;
                        var5_11 = AbstractKeepAliveNetworkHandlerSelector.this;
                        $i$f$logIfEnabled = 0;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var9_39 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p((AwaitResumeInstance)this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$2 = false;
                                var16_90 = "Max attempt " + AbstractKeepAliveNetworkHandlerSelector.access$getMaxAttempts$p((AbstractKeepAliveNetworkHandlerSelector)var5_11) + " reached.";
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$2 = var15_89.append(var16_90).toString();
                                var9_39.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$2);
                            }
                        }
                        var5_11 = var3_6.exceptionCollector.getLast();
                        if (var5_11 == null) {
                            v4 = null;
                        } else {
                            $i$f$logIfEnabled = var5_11;
                            $this$debug$iv$iv = false;
                            $i$f$debug = false;
                            $this$runImpl_u24lambda_u2d3 = $i$f$logIfEnabled;
                            $i$a$-apply-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$3 = false;
                            ExceptionsKt.addSuppressed((Throwable)$this$runImpl_u24lambda_u2d3, (Throwable)new MaxAttemptsReachedException(null));
                            v4 = this_$iv = $i$f$logIfEnabled;
                        }
                        if (this_$iv == null) {
                            v5 = new MaxAttemptsReachedException(null);
                            throw v5;
                        }
                        v5 = this_$iv;
                        throw v5;
                    }
                    $i$f$currentCoroutineContext = false;
                    if (!JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                        this_$iv = var3_6;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                $i$f$debug = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$4 = false;
                                var16_90 = "Cancellation detected.";
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$4 = var15_89.append(var16_90).toString();
                                $i$f$debug.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$4);
                            }
                        }
                        $continuation.L$0 = this;
                        $continuation.L$1 = var3_6;
                        $continuation.label = 1;
                        v0 = YieldKt.yield((Continuation)$continuation);
                        if (v0 == var19_4) {
                            return var19_4;
                        }
                    }
lbl121:
                    // 5 sources

                    current = AbstractKeepAliveNetworkHandlerSelector.this.getCurrentInstanceOrNull();
                    var3_6.lastNetwork = current;
                    this_$iv = var3_6;
                    $i$f$logIfEnabled = 0;
                    if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                        $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                        $i$f$debug = false;
                        if ($this$debug$iv$iv.isEnabled()) {
                            $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = $this$debug$iv$iv;
                            $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                            var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p((AwaitResumeInstance)this_$iv)).append(": ");
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$5 = false;
                            var12_73 = current;
                            var16_90 = Intrinsics.stringPlus((String)"current.state = ", (Object)(var12_73 == null ? null : var12_73.getState()));
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$5 = var15_89.append(var16_90).toString();
                            $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$5);
                        }
                    }
                    if (current == null) break block42;
                    this_$iv = current.getState();
                    $i$f$logIfEnabled = WhenMappings.$EnumSwitchMapping$0[this_$iv.ordinal()];
                    switch ($i$f$logIfEnabled) {
                        case 1: {
                            if (AbstractKeepAliveNetworkHandlerSelector.access$getCurrent$p(AbstractKeepAliveNetworkHandlerSelector.this).compareAndSet(current, null)) {
                                this_$iv = var3_6;
                                $i$f$logIfEnabled = false;
                                if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                                    $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                                    $i$f$debug = false;
                                    if ($this$debug$iv$iv.isEnabled()) {
                                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$5 = $this$debug$iv$iv;
                                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                        var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$6 = false;
                                        var16_90 = "... Set current to null.";
                                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$6 = var15_89.append(var16_90).toString();
                                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$5.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$6);
                                    }
                                }
                                $i$f$logIfEnabled = current.getLastFailure();
                                lastFailure = $i$f$logIfEnabled == null ? null : MiraiUtils.unwrapCancellationException((Throwable)$i$f$logIfEnabled);
                                this_$iv = var3_6;
                                $i$f$logIfEnabled = false;
                                if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                                    $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                                    $i$f$debug = false;
                                    if ($this$debug$iv$iv.isEnabled()) {
                                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = $this$debug$iv$iv;
                                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                        var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$7 = false;
                                        var16_90 = "...    Last failure was " + lastFailure + '.';
                                        var14_87 = var15_89.append(var16_90).toString();
                                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv.debug(var14_87);
                                    }
                                }
                                var3_6.exceptionCollector.collectException(lastFailure);
                            }
                            if (var3_6.attempted <= 1) ** GOTO lbl25
                            this_$iv = var3_6;
                            $i$f$logIfEnabled = false;
                            if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                                $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                                $i$f$debug = false;
                                if ($this$debug$iv$iv.isEnabled()) {
                                    $i$f$debug = $this$debug$iv$iv;
                                    $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                    var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                    $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$8 = false;
                                    var16_90 = "... Delaying " + MiraiUtils.millisToHumanReadableString((long)AbstractKeepAliveNetworkHandlerSelector.RECONNECT_DELAY) + '.';
                                    $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$8 = var15_89.append(var16_90).toString();
                                    $i$f$debug.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$8);
                                }
                            }
                            $continuation.L$0 = this;
                            $continuation.L$1 = var3_6;
                            $continuation.label = 2;
                            v1 = DelayKt.delay((long)AbstractKeepAliveNetworkHandlerSelector.RECONNECT_DELAY, (Continuation)$continuation);
                            if (v1 == var19_4) ** break;
                            ** continue;
                            return var19_4;
                        }
                        case 2: 
                        case 3: {
                            $continuation.L$0 = this;
                            $continuation.L$1 = var3_6;
                            $continuation.label = 3;
                            if ((v2 = AwaitResumeInstance.runImpl$resumeInstanceCatchingException(var4_7, var3_6, (Continuation<? super Unit>)$continuation)) != var19_4) ** continue;
                            return var19_4;
                        }
                        case 4: {
                            this_$iv = var3_6;
                            $i$f$logIfEnabled = false;
                            if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING == false) return var4_7;
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled() == false) return var4_7;
                            $i$f$debug = $this$debug$iv$iv;
                            $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                            var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$9 = false;
                            var16_90 = "RETURN";
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$9 = var15_89.append(var16_90).toString();
                            $i$f$debug.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$9);
                            return var4_7;
                        }
                        case 5: {
                            $continuation.L$0 = var3_6;
                            $continuation.L$1 = var4_7;
                            $continuation.label = 4;
                            if ((v3 = AwaitResumeInstance.runImpl$resumeInstanceCatchingException(var4_7, var3_6, (Continuation<? super Unit>)$continuation)) != var19_4) ** continue;
                            return var19_4;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                this_$iv = var3_6;
                $i$f$logIfEnabled = 0;
                if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                    $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                    $i$f$debug = false;
                    if ($this$debug$iv$iv.isEnabled()) {
                        var9_47 = $this$debug$iv$iv;
                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                        var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p((AwaitResumeInstance)this_$iv)).append(": ");
                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$11 = false;
                        var16_90 = "Creating new instance.";
                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$11 = var15_89.append(var16_90).toString();
                        var9_47.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$11);
                    }
                }
                AbstractKeepAliveNetworkHandlerSelector.this.refreshInstance();
                this_$iv = var3_6;
                $i$f$logIfEnabled = 0;
                if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                    $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                    $i$f$debug = false;
                    if ($this$debug$iv$iv.isEnabled()) {
                        var9_48 = $this$debug$iv$iv;
                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                        var15_89 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p((AwaitResumeInstance)this_$iv)).append(": ");
                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$12 = false;
                        var16_90 = "... Created.";
                        var11_72 = var15_89.append(var16_90).toString();
                        var9_48.debug(var11_72);
                    }
                }
                var2_5 = var3_6;
            }
        }

        /*
         * Unable to fully structure code
         */
        private static final <H extends NetworkHandler> Object runImpl$resumeInstanceCatchingException(H var0, AwaitResumeInstance var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof runImpl.resumeInstanceCatchingException.1)) ** GOTO lbl-1000
            var14_3 = var2_2;
            if ((var14_3.label & -2147483648) != 0) {
                var14_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AwaitResumeInstance.access$runImpl$resumeInstanceCatchingException(null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this_$iv = this$0;
                    $i$f$logIfEnabled = false;
                    if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                        $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                        $i$f$debug = false;
                        if ($this$debug$iv$iv.isEnabled()) {
                            var7_22 = $this$debug$iv$iv;
                            $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                            var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p((AwaitResumeInstance)this_$iv)).append(": ");
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$2 = false;
                            var12_45 = "Try resumeConnection";
                            $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$2 = var11_36.append(var12_45).toString();
                            var7_22.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$2);
                        }
                    }
                    $continuation.L$0 = $this$runImpl_u24resumeInstanceCatchingException;
                    $continuation.L$1 = this$0;
                    $continuation.label = 1;
                    v0 = $this$runImpl_u24resumeInstanceCatchingException.resumeConnection((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var15_5) goto lbl35
lbl34:
                    // 1 sources

                    return var15_5;
lbl35:
                    // 1 sources

                    ** GOTO lbl143
                }
                case 1: {
                    var1_1 = (AwaitResumeInstance)$continuation.L$1;
                    var0 = (NetworkHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                    }
                    catch (LoginFailedException e) {
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var8_30 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$3 = false;
                                var12_45 = Intrinsics.stringPlus((String)"... failed with LoginFailedException ", (Object)e);
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$3 = var11_36.append(var12_45).toString();
                                var8_30.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$3);
                            }
                        }
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var8_31 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$4 = false;
                                var12_45 = "CLOSING SELECTOR";
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$4 = var11_36.append(var12_45).toString();
                                var8_31.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$4);
                            }
                        }
                        var0.close(e);
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var8_32 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$5 = false;
                                var12_45 = "... CLOSED";
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$5 = var11_36.append(var12_45).toString();
                                var8_32.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$5);
                            }
                        }
                        if (e instanceof RetryLaterException) {
                            return Unit.INSTANCE;
                        }
                        var1_1.exceptionCollector.collectThrow((Throwable)e);
                        throw new KotlinNothingValueException();
                    }
                    catch (Exception e) {
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var8_33 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$6 = false;
                                var12_45 = Intrinsics.stringPlus((String)"... failed with ", (Object)e);
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$6 = var11_36.append(var12_45).toString();
                                var8_33.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$6);
                            }
                        }
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) {
                            $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                            $i$f$debug = false;
                            if ($this$debug$iv$iv.isEnabled()) {
                                var8_34 = $this$debug$iv$iv;
                                $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                                var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$7 = false;
                                var12_45 = "CLOSING SELECTOR";
                                $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$7 = var11_36.append(var12_45).toString();
                                var8_34.debug($i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$7);
                            }
                        }
                        var0.close(e);
                        this_$iv = var1_1;
                        $i$f$logIfEnabled = false;
                        if (!AbstractKeepAliveNetworkHandlerSelector.SELECTOR_LOGGING) ** GOTO lbl143
                        $this$debug$iv$iv = AbstractKeepAliveNetworkHandlerSelector.access$getLogger$p(this_$iv.AbstractKeepAliveNetworkHandlerSelector.this);
                        $i$f$debug = false;
                        if (!$this$debug$iv$iv.isEnabled()) ** GOTO lbl143
                        var8_35 = $this$debug$iv$iv;
                        $i$a$-debug-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$logIfEnabled$1$iv = false;
                        var11_36 = new StringBuilder().append("Attempt #").append(AwaitResumeInstance.access$getAttempted$p(this_$iv)).append(": ");
                        $i$a$-logIfEnabled-AbstractKeepAliveNetworkHandlerSelector$AwaitResumeInstance$runImpl$resumeInstanceCatchingException$8 = false;
                        var12_45 = "... CLOSED";
                        var10_55 = var11_36.append(var12_45).toString();
                        var8_35.debug(var10_55);
                    }
lbl143:
                    // 5 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$runImpl(AwaitResumeInstance $this, Continuation $completion) {
            return $this.runImpl($completion);
        }

        public static final /* synthetic */ Object access$runImpl$resumeInstanceCatchingException(NetworkHandler $receiver, AwaitResumeInstance this$0, Continuation $completion) {
            return AwaitResumeInstance.runImpl$resumeInstanceCatchingException($receiver, this$0, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ NetworkHandler access$getLastNetwork$p(AwaitResumeInstance $this) {
            return $this.lastNetwork;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NetworkHandler.State.values().length];
                nArray[NetworkHandler.State.CLOSED.ordinal()] = 1;
                nArray[NetworkHandler.State.CONNECTING.ordinal()] = 2;
                nArray[NetworkHandler.State.INITIALIZED.ordinal()] = 3;
                nArray[NetworkHandler.State.LOADING.ordinal()] = 4;
                nArray[NetworkHandler.State.OK.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/mamoe/mirai/internal/network/handler/selector/AbstractKeepAliveNetworkHandlerSelector$Companion;", "", "()V", "DEFAULT_MAX_ATTEMPTS", "", "RECONNECT_DELAY", "", "SELECTOR_LOGGING", "", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

