/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import net.mamoe.mirai.internal.BotAccount;
import net.mamoe.mirai.internal.network.components.AccountSecretsManager;
import net.mamoe.mirai.internal.network.context.AccountSecrets;
import net.mamoe.mirai.internal.network.context.AccountSecretsImpl;
import net.mamoe.mirai.internal.network.context.AccountSecretsKt;
import net.mamoe.mirai.internal.utils.crypto.TEA;
import net.mamoe.mirai.internal.utils.io.ProtoBuf;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/internal/network/components/FileCacheAccountSecretsManager;", "Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;", "file", "Ljava/io/File;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Ljava/io/File;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "getFile", "()Ljava/io/File;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "getSecrets", "Lnet/mamoe/mirai/internal/network/context/AccountSecrets;", "account", "Lnet/mamoe/mirai/internal/BotAccount;", "getSecretsImpl", "invalidate", "", "saveSecrets", "secrets", "mirai-core"})
public final class FileCacheAccountSecretsManager
implements AccountSecretsManager {
    @NotNull
    private final File file;
    @NotNull
    private final MiraiLogger logger;

    public FileCacheAccountSecretsManager(@NotNull File file, @NotNull MiraiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.file = file;
        this.logger = logger;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final MiraiLogger getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void saveSecrets(@NotNull BotAccount account, @NotNull AccountSecrets secrets) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
        if (secrets.getWLoginSigInfoField() == null) {
            return;
        }
        FilesKt.writeBytes((File)this.file, (byte[])TEA.encrypt$default(SerializationUtils.toByteArray((ProtoBuf)AccountSecretsKt.AccountSecretsImpl(secrets), (SerializationStrategy)AccountSecretsImpl.Companion.serializer()), account.getPasswordMd5(), 0, 4, null));
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl = false;
            String string = "Saved account secrets to local cache for fast login.";
            miraiLogger.info(string);
        }
    }

    @Override
    @Nullable
    public synchronized AccountSecrets getSecrets(@NotNull BotAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        return this.getSecretsImpl(account);
    }

    private final AccountSecrets getSecretsImpl(BotAccount account) {
        Object object;
        if (!this.file.exists()) {
            return null;
        }
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322 = false;
            AccountSecretsImpl $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322 = (AccountSecretsImpl)SerializationUtils.loadAs(TEA.decrypt$default(FilesKt.readBytes((File)this.getFile()), account.getPasswordMd5(), 0, 4, null), (DeserializationStrategy)AccountSecretsImpl.Companion.serializer());
            boolean bl2 = false;
            object = Result.constructor-impl((Object)$i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322);
        }
        catch (Throwable $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322) {
            Result.Companion companion = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322));
        }
        Object object2 = object;
        boolean bl4 = false;
        boolean $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322 = false;
        Throwable $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322 = Result.exceptionOrNull-impl((Object)object2);
        if ($i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322 != null) {
            Throwable e = $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$322;
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Field 'ecdhInitialPublicKey' is required for type with serial name 'net.mamoe.mirai.internal.network.context.AccountSecretsImpl', but it was missing")) {
                MiraiLogger $this$info$iv = this.getLogger();
                boolean $i$f$info = false;
                if ($this$info$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$info$iv;
                    boolean bl6 = false;
                    String string = "Detected old account secrets, invalidating...";
                    miraiLogger.info(string);
                }
            } else {
                this.getLogger().error("Failed to load account secrets from local cache. Invalidating cache...", e);
            }
            this.getFile().delete();
            return null;
        }
        AccountSecretsImpl loaded = (AccountSecretsImpl)object2;
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl7 = false;
            String string = "Loaded account secrets from local cache.";
            miraiLogger.info(string);
        }
        return loaded;
    }

    @Override
    public synchronized void invalidate() {
        this.file.delete();
    }
}

