/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.BotAccount;
import net.mamoe.mirai.internal.network.components.AccountSecretsManager;
import net.mamoe.mirai.internal.network.context.AccountSecrets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/internal/network/components/CombinedAccountSecretsManager;", "Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;", "primary", "alternative", "(Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;)V", "getSecrets", "Lnet/mamoe/mirai/internal/network/context/AccountSecrets;", "account", "Lnet/mamoe/mirai/internal/BotAccount;", "invalidate", "", "saveSecrets", "secrets", "mirai-core"})
public final class CombinedAccountSecretsManager
implements AccountSecretsManager {
    @NotNull
    private final AccountSecretsManager primary;
    @NotNull
    private final AccountSecretsManager alternative;

    public CombinedAccountSecretsManager(@NotNull AccountSecretsManager primary, @NotNull AccountSecretsManager alternative) {
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)alternative, (String)"alternative");
        this.primary = primary;
        this.alternative = alternative;
    }

    @Override
    public void saveSecrets(@NotNull BotAccount account, @NotNull AccountSecrets secrets) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
        this.primary.saveSecrets(account, secrets);
        this.alternative.saveSecrets(account, secrets);
    }

    @Override
    @Nullable
    public AccountSecrets getSecrets(@NotNull BotAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AccountSecrets accountSecrets = this.primary.getSecrets(account);
        return accountSecrets == null ? this.alternative.getSecrets(account) : accountSecrets;
    }

    @Override
    public void invalidate() {
        this.primary.invalidate();
        this.alternative.invalidate();
    }
}

