/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.network.components.ServerAddress;
import net.mamoe.mirai.internal.network.components.ServerList;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/mamoe/mirai/internal/network/components/ServerListImpl;", "Lnet/mamoe/mirai/internal/network/components/ServerList;", "initial", "", "Lnet/mamoe/mirai/internal/network/components/ServerAddress;", "(Ljava/util/Collection;)V", "()V", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/utils/MiraiLogger;Ljava/util/Collection;)V", "current", "Ljava/util/Queue;", "preferred", "", "getPreferred", "pollAny", "pollCurrent", "refresh", "", "setPreferred", "list", "toString", "", "mirai-core"})
public final class ServerListImpl
implements ServerList {
    private volatile Set<ServerAddress> preferred;
    private volatile Queue<ServerAddress> current;
    private final MiraiLogger logger;

    @Override
    public synchronized void setPreferred(@NotNull Collection<ServerAddress> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        boolean bl = false;
        if ($this$info$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl2 = false;
            String string = "Server list: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null) + '.';
            miraiLogger.info(string);
        }
        Collection<ServerAddress> collection = list;
        boolean bl3 = false;
        boolean bl4 = !collection.isEmpty();
        bl3 = false;
        bl = false;
        if (!bl4) {
            boolean bl5 = false;
            String string = "list cannot be empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.preferred = CollectionsKt.toSet((Iterable)list);
    }

    @Override
    @NotNull
    public Set<ServerAddress> getPreferred() {
        return this.preferred;
    }

    @Override
    public synchronized void refresh() {
        this.current = (Queue)CollectionsKt.toCollection((Iterable)this.preferred, (Collection)new ArrayDeque(this.current.size()));
        Collection collection = this.current;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Internal error: failed to fill server list. No server available.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    @Nullable
    public synchronized ServerAddress pollCurrent() {
        return this.current.poll();
    }

    @Override
    @NotNull
    public synchronized ServerAddress pollAny() {
        if (this.current.isEmpty()) {
            this.refresh();
        }
        ServerAddress serverAddress = this.current.remove();
        Intrinsics.checkNotNullExpressionValue((Object)serverAddress, (String)"current.remove()");
        return serverAddress;
    }

    @NotNull
    public String toString() {
        return "ServerListImpl(current.size=" + this.current.size() + ')';
    }

    public ServerListImpl(@NotNull MiraiLogger logger, @NotNull Collection<ServerAddress> initial) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this.logger = logger;
        this.preferred = ServerList.Companion.getDEFAULT_SERVER_LIST();
        this.current = new ArrayDeque<ServerAddress>(initial);
        this.refresh();
    }

    public /* synthetic */ ServerListImpl(MiraiLogger miraiLogger, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(miraiLogger, collection);
    }

    public ServerListImpl(@NotNull Collection<ServerAddress> initial) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this(MiraiLogger.Companion.getTopLevel(), initial);
    }

    public ServerListImpl() {
        this(MiraiLogger.Companion.getTopLevel(), null, 2, null);
    }
}

