/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.contact;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.ContactOrBot;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.MessageTooLargeException;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.FriendMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.GroupMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupTempMessageEvent;
import net.mamoe.mirai.event.events.GroupTempMessageSyncEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.event.events.OtherClientMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageSyncEvent;
import net.mamoe.mirai.internal.contact.GroupImpl;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.utils.TypeKt;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageContent;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0016*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\f\u0010\u001c\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u0003*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0013H\u0000\u001a \u0010\u001f\u001a\u0004\u0018\u0001H \"\n\b\u0000\u0010 \u0018\u0001*\u00020!*\u00020\u001bH\u0080\b\u00a2\u0006\u0002\u0010\"\u001a\u001c\u0010#\u001a\u00020\u0013*\u00020\u00142\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0019H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0019\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\f8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\u000f8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006&"}, d2={"charMappings", "", "", "", "getCharMappings", "()Ljava/util/Map;", "groupCode", "", "Lnet/mamoe/mirai/contact/Group;", "getGroupCode", "(Lnet/mamoe/mirai/contact/Group;)J", "uin", "Lnet/mamoe/mirai/Bot;", "getUin", "(Lnet/mamoe/mirai/Bot;)J", "Lnet/mamoe/mirai/contact/User;", "(Lnet/mamoe/mirai/contact/User;)J", "applyCharMapping", "countImages", "", "Lnet/mamoe/mirai/message/data/MessageChain;", "logMessageReceived", "", "Lnet/mamoe/mirai/event/events/MessageEvent;", "logMessageSent", "Lnet/mamoe/mirai/contact/Contact;", "message", "Lnet/mamoe/mirai/message/data/Message;", "replaceMagicCodes", "takeContent", "length", "takeSingleContent", "T", "Lnet/mamoe/mirai/message/data/MessageContent;", "(Lnet/mamoe/mirai/message/data/Message;)Lnet/mamoe/mirai/message/data/MessageContent;", "verityLength", "originalMessage", "target", "mirai-core"})
public final class UtilKt {
    @NotNull
    private static final Map<Character, String> charMappings = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)""), TuplesKt.to((Object)Character.valueOf('\u202e'), (Object)"<RTL>"), TuplesKt.to((Object)Character.valueOf('\u202d'), (Object)"<LTR>")});

    public static final long getUin(@NotNull Group $this$uin) {
        int $i$f$getUin = 0;
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"$this$uin");
        Group $this$cast$iv = $this$uin;
        boolean $i$f$cast = false;
        return ((GroupImpl)$this$cast$iv).getUin();
    }

    public static final long getGroupCode(@NotNull Group $this$groupCode) {
        int $i$f$getGroupCode = 0;
        Intrinsics.checkNotNullParameter((Object)$this$groupCode, (String)"$this$groupCode");
        return $this$groupCode.getId();
    }

    public static final long getUin(@NotNull User $this$uin) {
        int $i$f$getUin = 0;
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"$this$uin");
        return $this$uin.getId();
    }

    public static final long getUin(@NotNull Bot $this$uin) {
        int $i$f$getUin = 0;
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"$this$uin");
        return $this$uin.getId();
    }

    public static final void logMessageSent(@NotNull Contact $this$logMessageSent, @NotNull Message message2) {
        Intrinsics.checkNotNullParameter((Object)$this$logMessageSent, (String)"$this$logMessageSent");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!(message2 instanceof LongMessageInternal)) {
            $this$logMessageSent.getBot().getLogger().verbose(UtilKt.replaceMagicCodes($this$logMessageSent + " <- " + message2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int countImages(@NotNull MessageChain $this$countImages) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$countImages, (String)"$this$countImages");
        Iterable $this$count$iv = (Iterable)$this$countImages;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SingleMessage it = (SingleMessage)element$iv;
                boolean bl = false;
                if (!(it instanceof Image)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public static final int verityLength(@NotNull MessageChain $this$verityLength, @NotNull Message originalMessage2, @NotNull Contact target) {
        Intrinsics.checkNotNullParameter((Object)$this$verityLength, (String)"$this$verityLength");
        Intrinsics.checkNotNullParameter((Object)originalMessage2, (String)"originalMessage");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MessageChain chain2 = $this$verityLength;
        int length2 = TypeKt.estimateLength($this$verityLength, (ContactOrBot)target, 15001);
        if (length2 > 15000 || UtilKt.countImages($this$verityLength) > 50) {
            throw (Throwable)new MessageTooLargeException(target, originalMessage2, (Message)$this$verityLength, "message(" + CollectionsKt.joinToString$default((Iterable)((Iterable)chain2), (CharSequence)"", null, null, (int)10, null, null, (int)54, null) + ") is too large. Allow up to 50 images or 5000 chars");
        }
        return length2;
    }

    public static final void logMessageReceived(@NotNull MessageEvent $this$logMessageReceived) {
        Intrinsics.checkNotNullParameter((Object)$this$logMessageReceived, (String)"$this$logMessageReceived");
        logMessageReceived.1 $fun$renderMessage$1 = logMessageReceived.1.INSTANCE;
        logMessageReceived.2 $fun$renderGroupMessage$2 = logMessageReceived.2.INSTANCE;
        logMessageReceived.3 $fun$renderGroupTempMessage$3 = logMessageReceived.3.INSTANCE;
        logMessageReceived.4 $fun$renderStrangerMessage$4 = logMessageReceived.4.INSTANCE;
        logMessageReceived.5 $fun$renderFriendMessage$5 = logMessageReceived.5.INSTANCE;
        Function1<OtherClient, String> $fun$renderOtherClientMessage$6 = new Function1<OtherClient, String>($this$logMessageReceived){
            final /* synthetic */ MessageEvent $this_logMessageReceived;

            @NotNull
            public final String invoke(@NotNull OtherClient client2) {
                Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
                OtherClient $this$platform$iv = client2;
                boolean $i$f$getPlatform = false;
                return $this$platform$iv.getInfo().getPlatform() + " -> " + logMessageReceived.1.INSTANCE.invoke(this.$this_logMessageReceived.getMessage());
            }
            {
                this.$this_logMessageReceived = messageEvent;
                super(1);
            }
        };
        MiraiLogger $this$verbose$iv = $this$logMessageReceived.getBot().getLogger();
        boolean $i$f$verbose = false;
        boolean bl = false;
        if ($this$verbose$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl2 = false;
            MessageEvent messageEvent = $this$logMessageReceived;
            String string = UtilKt.replaceMagicCodes(messageEvent instanceof GroupMessageEvent ? logMessageReceived.2.INSTANCE.invoke(((GroupMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), ((GroupMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupMessageSyncEvent ? logMessageReceived.2.INSTANCE.invoke(((GroupMessageSyncEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), ((GroupMessageSyncEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageEvent ? logMessageReceived.3.INSTANCE.invoke(((GroupTempMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), (Member)((GroupTempMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageSyncEvent ? logMessageReceived.3.INSTANCE.invoke(((GroupTempMessageSyncEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), (Member)((GroupTempMessageSyncEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof StrangerMessageEvent || messageEvent instanceof StrangerMessageSyncEvent ? logMessageReceived.4.INSTANCE.invoke($this$logMessageReceived.getSenderName(), $this$logMessageReceived.getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof FriendMessageEvent || messageEvent instanceof FriendMessageSyncEvent ? logMessageReceived.5.INSTANCE.invoke($this$logMessageReceived.getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof OtherClientMessageEvent ? $fun$renderOtherClientMessage$6.invoke(((OtherClientMessageEvent)$this$logMessageReceived).getClient()) : $this$logMessageReceived.toString())))))));
            miraiLogger.verbose(string);
        }
    }

    @NotNull
    public static final Map<Character, String> getCharMappings() {
        return charMappings;
    }

    @NotNull
    public static final String applyCharMapping(@NotNull String $this$applyCharMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCharMapping, (String)"$this$applyCharMapping");
        int n = $this$applyCharMapping.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence $this$forEach$iv = $this$applyCharMapping;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int j = 0; j < charSequence.length(); ++j) {
            char element$iv;
            char c = element$iv = charSequence.charAt(j);
            boolean bl6 = false;
            Object object = charMappings.get(Character.valueOf(c));
            if (object == null) {
                object = Character.valueOf(c);
            }
            $this$buildString.append(object);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String replaceMagicCodes(@NotNull String $this$replaceMagicCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceMagicCodes, (String)"$this$replaceMagicCodes");
        return UtilKt.applyCharMapping($this$replaceMagicCodes);
    }

    @NotNull
    public static final String takeContent(@NotNull Message $this$takeContent, int length2) {
        Intrinsics.checkNotNullParameter((Object)$this$takeContent, (String)"$this$takeContent");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)MessageUtils.newChain((Message)$this$takeContent)), (CharSequence)"", null, null, (int)length2, null, (Function1)takeContent.1.INSTANCE, (int)22, null);
    }

    public static final /* synthetic */ <T extends MessageContent> T takeSingleContent(Message $this$takeSingleContent) {
        int $i$f$takeSingleContent = 0;
        Intrinsics.checkNotNullParameter((Object)$this$takeSingleContent, (String)"$this$takeSingleContent");
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        MessageContent messageContent = (MessageContent)$this$takeSingleContent;
        if (messageContent == null) {
            Message $this$castOrNull$iv = $this$takeSingleContent;
            boolean $i$f$castOrNull = false;
            Message message2 = $this$castOrNull$iv;
            if (!(message2 instanceof MessageChain)) {
                message2 = null;
            }
            MessageChain messageChain = (MessageChain)message2;
            if (messageChain != null) {
                Object v3;
                block5: {
                    MessageChain $this$findIsInstance$iv = messageChain;
                    boolean $i$f$findIsInstance = false;
                    Iterable iterable = (Iterable)$this$findIsInstance$iv;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        SingleMessage it$iv = (SingleMessage)t;
                        boolean bl3 = false;
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T?");
                        if (!(it$iv instanceof SingleMessage)) continue;
                        v3 = t;
                        break block5;
                    }
                    v3 = null;
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                messageContent = (MessageContent)((SingleMessage)v3);
            } else {
                messageContent = null;
            }
        }
        return (T)messageContent;
    }
}

