/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketExtensionsKt;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.internal.message.ContextualBugReportExceptionKt;
import net.mamoe.mirai.internal.message.FileMessageImpl;
import net.mamoe.mirai.internal.message.ForwardMessageInternal;
import net.mamoe.mirai.internal.message.LightAppInternal;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.message.MarketFaceInternal;
import net.mamoe.mirai.internal.message.MessageSourceInternal;
import net.mamoe.mirai.internal.message.MessageToElemsKt;
import net.mamoe.mirai.internal.message.OfflineSourceImplKt;
import net.mamoe.mirai.internal.message.OnlineFriendImageImpl;
import net.mamoe.mirai.internal.message.OnlineGroupImageImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromFriendImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromGroupImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromStrangerImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromTempImpl;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer$WhenMappings;
import net.mamoe.mirai.internal.network.protocol.data.proto.CustomFace;
import net.mamoe.mirai.internal.network.protocol.data.proto.HummerCommelem;
import net.mamoe.mirai.internal.network.protocol.data.proto.ImMsgBody;
import net.mamoe.mirai.internal.network.protocol.data.proto.MsgComm;
import net.mamoe.mirai.internal.network.protocol.data.proto.ObjMsg;
import net.mamoe.mirai.internal.utils.io.ProtoBuf;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.CustomMessage;
import net.mamoe.mirai.message.data.Face;
import net.mamoe.mirai.message.data.FlashImage;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageSourceKind;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.PokeMessage;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.ServiceMessage;
import net.mamoe.mirai.message.data.ShowImageFlag;
import net.mamoe.mirai.message.data.SimpleServiceMessage;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.message.data.VipFace;
import net.mamoe.mirai.message.data.Voice;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J0\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010/\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u000e2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0015J0\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u0002012\u0006\u0010(\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\n\u00104\u001a\u000205*\u000205J\n\u00106\u001a\u00020\u0011*\u00020\u0015J\n\u00107\u001a\u000208*\u000209R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lnet/mamoe/mirai/internal/message/ReceiveMessageTransformer;", "", "()V", "jsonForFileDecode", "Lkotlinx/serialization/json/Json;", "createMessageSource", "Lnet/mamoe/mirai/message/data/MessageSource;", "bot", "Lnet/mamoe/mirai/Bot;", "onlineSource", "", "messageSourceKind", "Lnet/mamoe/mirai/message/data/MessageSourceKind;", "messageList", "", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/MsgComm$Msg;", "decodeCommonElem", "", "commonElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CommonElem;", "list", "Lnet/mamoe/mirai/message/data/MessageChainBuilder;", "decodeCustomElem", "customElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomElem;", "decodeCustomFace", "customFace", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomFace;", "builder", "decodeLightApp", "lightApp", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$LightAppElem;", "decodeRichMessage", "richMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$RichMsg;", "decodeSrcMsg", "srcMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$SourceMsg;", "botId", "", "groupIdOrZero", "decodeText", "text", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Text;", "decodeTransElem", "transElement", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$TransElem;", "joinToMessageChain", "elements", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Elem;", "transformElement", "element", "cleanupRubbishMessageElements", "Lnet/mamoe/mirai/message/data/MessageChain;", "compressContinuousPlainText", "toVoice", "Lnet/mamoe/mirai/message/data/Voice;", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Ptt;", "mirai-core"})
final class ReceiveMessageTransformer {
    private static final Json jsonForFileDecode;
    @NotNull
    public static final ReceiveMessageTransformer INSTANCE;

    @NotNull
    public final MessageSource createMessageSource(@NotNull Bot bot, boolean onlineSource, @NotNull MessageSourceKind messageSourceKind, @NotNull List<MsgComm.Msg> messageList) {
        MessageSource messageSource;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter(messageList, (String)"messageList");
        boolean bl = onlineSource;
        if (bl) {
            MessageSourceInternal messageSourceInternal;
            switch (ReceiveMessageTransformer$WhenMappings.$EnumSwitchMapping$0[messageSourceKind.ordinal()]) {
                case 1: {
                    messageSourceInternal = new OnlineMessageSourceFromTempImpl(bot, messageList);
                    break;
                }
                case 2: {
                    messageSourceInternal = new OnlineMessageSourceFromGroupImpl(bot, messageList);
                    break;
                }
                case 3: {
                    messageSourceInternal = new OnlineMessageSourceFromFriendImpl(bot, messageList);
                    break;
                }
                case 4: {
                    messageSourceInternal = new OnlineMessageSourceFromStrangerImpl(bot, messageList);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            messageSource = (MessageSource)messageSourceInternal;
        } else if (!bl) {
            messageSource = (MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(bot, messageList, messageSourceKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageSource;
    }

    public final void joinToMessageChain(@NotNull List<ImMsgBody.Elem> elements, long groupIdOrZero, @NotNull MessageSourceKind messageSourceKind, long botId, @NotNull MessageChainBuilder builder) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        for (ImMsgBody.Elem element : elements) {
            this.transformElement(element, groupIdOrZero, messageSourceKind, botId, builder);
            if (element.richMsg == null) continue;
            this.decodeRichMessage(element.richMsg, builder);
        }
    }

    private final void transformElement(ImMsgBody.Elem element, long groupIdOrZero, MessageSourceKind messageSourceKind, long botId, MessageChainBuilder builder) {
        if (element.srcMsg != null) {
            this.decodeSrcMsg(element.srcMsg, builder, botId, messageSourceKind, groupIdOrZero);
        } else if (element.notOnlineImage != null) {
            builder.add((SingleMessage)new OnlineFriendImageImpl(element.notOnlineImage));
        } else if (element.customFace != null) {
            this.decodeCustomFace(element.customFace, builder);
        } else if (element.face != null) {
            builder.add((SingleMessage)new Face(element.face.index));
        } else if (element.text != null) {
            this.decodeText(element.text, builder);
        } else if (element.marketFace != null) {
            builder.add((SingleMessage)new MarketFaceInternal(element.marketFace));
        } else if (element.lightApp != null) {
            this.decodeLightApp(element.lightApp, builder);
        } else if (element.customElem != null) {
            this.decodeCustomElem(element.customElem, builder);
        } else if (element.commonElem != null) {
            this.decodeCommonElem(element.commonElem, builder);
        } else if (element.transElemInfo != null) {
            this.decodeTransElem(element.transElemInfo, builder);
        } else if (element.elemFlags2 != null || element.extraInfo != null || element.generalFlags == null) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void compressContinuousPlainText(@NotNull MessageChainBuilder $this$compressContinuousPlainText) {
        Intrinsics.checkNotNullParameter((Object)$this$compressContinuousPlainText, (String)"$this$compressContinuousPlainText");
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index + 1 < $this$compressContinuousPlainText.size()) {
            SingleMessage elm0 = $this$compressContinuousPlainText.get(index);
            SingleMessage elm1 = $this$compressContinuousPlainText.get(index + 1);
            if (elm0 instanceof PlainText && elm1 instanceof PlainText) {
                void i2;
                SingleMessage elm;
                builder.setLength(0);
                int end = -1;
                int n = index;
                int n2 = $this$compressContinuousPlainText.size();
                while (n < n2 && (elm = $this$compressContinuousPlainText.get((int)i2)) instanceof PlainText) {
                    end = i2++;
                    builder.append(((PlainText)elm).getContent());
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                $this$compressContinuousPlainText.set(index, (SingleMessage)new PlainText(string));
                int index1 = index + 1;
                n2 = end - index;
                boolean bl = false;
                int n3 = 0;
                n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int it = n3++;
                    boolean bl2 = false;
                    $this$compressContinuousPlainText.remove(index1);
                }
            }
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MessageChain cleanupRubbishMessageElements(@NotNull MessageChain $this$cleanupRubbishMessageElements) {
        void initialSize$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cleanupRubbishMessageElements, (String)"$this$cleanupRubbishMessageElements");
        SingleMessage previousLast = null;
        SingleMessage last = null;
        Collection collection = (Collection)$this$cleanupRubbishMessageElements;
        boolean bl = false;
        int n = collection.size();
        boolean $i$f$buildMessageChain = false;
        boolean bl2 = false;
        MessageChainBuilder messageChainBuilder = new MessageChainBuilder((int)initialSize$iv);
        boolean bl3 = false;
        boolean bl4 = false;
        MessageChainBuilder $this$buildMessageChain = messageChainBuilder;
        boolean bl5 = false;
        Iterable $this$forEach$iv = (Iterable)$this$cleanupRubbishMessageElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n2;
            SingleMessage element = (SingleMessage)element$iv;
            boolean bl6 = false;
            if (last instanceof LongMessageInternal && element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_MERGED_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (last instanceof PokeMessage && element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_POKE_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (last instanceof VipFace && element instanceof PlainText) {
                SingleMessage singleMessage = last;
                if (singleMessage == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.mamoe.mirai.message.data.VipFace");
                }
                VipFace l = (VipFace)singleMessage;
                if (((PlainText)element).getContent().length() == 4 + l.getCount() / 10 + l.getKind().getName().length()) {
                    previousLast = last;
                    last = element;
                    continue;
                }
            }
            if (element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_VOICE_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (element instanceof PlainText && last instanceof At && previousLast instanceof QuoteReply && StringsKt.startsWith$default((CharSequence)((PlainText)element).getContent(), (char)' ', (boolean)false, (int)2, null)) {
                CollectionsKt.removeLastOrNull((List)((List)$this$buildMessageChain));
                String string = ((PlainText)element).getContent();
                n2 = 1;
                boolean bl7 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                PlainText plainText = new PlainText(string3);
                $this$buildMessageChain.add((SingleMessage)plainText);
                previousLast = null;
                last = (SingleMessage)plainText;
                continue;
            }
            if (element instanceof QuoteReply && (SingleMessage)CollectionsKt.removeLastOrNull((List)((List)$this$buildMessageChain)) != null) {
                SingleMessage singleMessage;
                boolean bl8 = false;
                n2 = 0;
                SingleMessage rm = singleMessage;
                boolean bl9 = false;
                SingleMessage singleMessage2 = rm;
                if (!(singleMessage2 instanceof PlainText)) {
                    singleMessage2 = null;
                }
                PlainText plainText = (PlainText)singleMessage2;
                if (Intrinsics.areEqual((Object)(plainText != null ? plainText.getContent() : null), (Object)" ") ^ true) {
                    $this$buildMessageChain.add(rm);
                } else if ((SingleMessage)CollectionsKt.removeLastOrNull((List)((List)$this$buildMessageChain)) != null) {
                    SingleMessage singleMessage3;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    SingleMessage rm2 = singleMessage3;
                    boolean bl12 = false;
                    if (!(rm2 instanceof At)) {
                        $this$buildMessageChain.add(rm2);
                    }
                }
            }
            $this$buildMessageChain.append(element);
            previousLast = last;
            last = element;
        }
        INSTANCE.compressContinuousPlainText($this$buildMessageChain);
        return messageChainBuilder.asMessageChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeText(ImMsgBody.Text text, MessageChainBuilder list) {
        byte[] byArray = text.attr6Buf;
        boolean bl = false;
        if (byArray.length == 0) {
            list.add((SingleMessage)new PlainText(text.str));
        } else {
            void $this$withUse$iv$iv;
            long id2 = 0L;
            byte[] $this$read$iv = text.attr6Buf;
            boolean $i$f$read = false;
            boolean bl2 = false;
            Object $this$toReadPacket$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket$iv$iv).length - offset$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
            boolean $i$f$withUse = false;
            boolean bl3 = false;
            void var9_12 = $this$withUse$iv$iv;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$read = (ByteReadPacket)var9_12;
                boolean bl6 = false;
                InputKt.discardExact((Input)((Input)$this$read), (int)7);
                Input $this$readUInt$iv = (Input)$this$read;
                boolean $i$f$readUInt = false;
                int n = $this$readUInt$iv.readInt();
                boolean bl7 = false;
                int n2 = UInt.constructor-impl((int)n);
                boolean bl8 = false;
                id2 = (long)n2 & 0xFFFFFFFFL;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var9_12, (Throwable)throwable);
            }
            if (id2 == 0L) {
                list.add((SingleMessage)AtAll.INSTANCE);
            } else {
                list.add((SingleMessage)new At(id2));
            }
        }
    }

    private final void decodeSrcMsg(ImMsgBody.SourceMsg srcMsg, MessageChainBuilder list, long botId, MessageSourceKind messageSourceKind, long groupIdOrZero) {
        list.add((SingleMessage)new QuoteReply((MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(srcMsg, botId, messageSourceKind, groupIdOrZero)));
    }

    private final void decodeCustomFace(ImMsgBody.CustomFace customFace, MessageChainBuilder builder) {
        builder.add((SingleMessage)new OnlineGroupImageImpl(customFace));
        byte[] byArray = customFace.pbReserve;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        byte[] byArray2 = it;
        boolean bl4 = false;
        byte[] byArray3 = byArray2;
        boolean bl5 = false;
        if (!(byArray3.length == 0) && ((CustomFace.ResvAttr)SerializationUtils.loadAs((byte[])it, (DeserializationStrategy)CustomFace.ResvAttr.Companion.serializer())).msgImageShow != null) {
            builder.add((SingleMessage)ShowImageFlag.INSTANCE);
        }
    }

    private final void decodeLightApp(ImMsgBody.LightAppElem lightApp, MessageChainBuilder list) {
        boolean bl;
        Object object;
        String string = "\u89e3\u6790 lightApp";
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        try {
            String string2;
            object = Result.Companion;
            boolean bl4 = false;
            switch (lightApp.data[0]) {
                case 0: {
                    byte[] $this$encodeToString$iv;
                    byte[] byArray = lightApp.data;
                    int offset$iv = 1;
                    Charset charset$iv = Charsets.UTF_8;
                    boolean $i$f$encodeToString = false;
                    int length$iv$iv = $this$encodeToString$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv, offset$iv, length$iv$iv, charset$iv);
                    break;
                }
                case 1: {
                    byte[] $this$encodeToString$iv = MiraiUtils.unzip$default((byte[])lightApp.data, (int)1, (int)0, (int)2, null);
                    int offset$iv = 0;
                    Charset charset$iv = Charsets.UTF_8;
                    boolean $i$f$encodeToString = false;
                    int length$iv$iv = $this$encodeToString$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv, offset$iv, length$iv$iv, charset$iv);
                    break;
                }
                default: {
                    String string3 = "unknown compression flag=" + lightApp.data[0];
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            String string4 = string2;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)string4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl7 = false;
        boolean bl8 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl = false;
            String string5 = string;
            boolean bl9 = false;
            String string6 = "resId=" + lightApp.msgResid + "data=" + MiraiUtils.toUHexString$default((byte[])lightApp.data, null, (int)0, (int)0, (int)7, null);
            throw (Throwable)ContextualBugReportExceptionKt.contextualBugReportException$default(string5, string6, throwable2, null, 8, null);
        }
        String content = (String)object2;
        list.add((SingleMessage)new LightAppInternal(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeCustomElem(ImMsgBody.CustomElem customElem, MessageChainBuilder list) {
        void $this$withUse$iv$iv;
        byte[] $this$read$iv = customElem.data;
        boolean $i$f$read = false;
        boolean bl = false;
        Object $this$toReadPacket$iv$iv = $this$read$iv;
        int offset$iv$iv = 0;
        int length$iv$iv = ((byte[])$this$toReadPacket$iv$iv).length - offset$iv$iv;
        boolean $i$f$toReadPacket = false;
        boolean $i$f$ByteReadPacket = false;
        boolean $i$f$ByteReadPacket2 = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv, offset$iv$iv, length$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
        $this$toReadPacket$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv){
            final /* synthetic */ byte[] $array;
            {
                this.$array = byArray;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                byte[] it2 = this.$array;
                boolean bl = false;
            }
        }));
        boolean $i$f$withUse = false;
        boolean bl2 = false;
        void var7_9 = $this$withUse$iv$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            Object object;
            ByteReadPacket $this$read = (ByteReadPacket)var7_9;
            boolean bl5 = false;
            boolean bl6 = false;
            try {
                object = Result.Companion;
                boolean bl7 = false;
                CustomMessage customMessage = CustomMessage.Companion.load($this$read);
                boolean bl8 = false;
                object = Result.constructor-impl((Object)customMessage);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object object2 = object;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                CustomMessage it = (CustomMessage)object2;
                boolean bl12 = false;
                if (it != null) {
                    list.add((SingleMessage)it);
                }
            } else {
                Throwable it = throwable3;
                boolean bl13 = false;
                if (it instanceof CustomMessage.Companion.CustomMessageFullDataDeserializeInternalException) {
                    throw (Throwable)new IllegalStateException("Internal error: exception while deserializing CustomMessage head data," + " data=" + MiraiUtils.toUHexString$default((byte[])customElem.data, null, (int)0, (int)0, (int)7, null), it);
                }
                CustomMessage.Companion.CustomMessageFullDataDeserializeUserException cfr_ignored_0 = (CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it;
                throw (Throwable)new IllegalStateException("User error: exception while deserializing CustomMessage body," + " body=" + MiraiUtils.toUHexString$default((byte[])((CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it).getBody(), null, (int)0, (int)0, (int)7, null), it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var7_9, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeTransElem(ImMsgBody.TransElem transElement, MessageChainBuilder list) {
        switch (transElement.elemType) {
            case 24: {
                void $this$withUse$iv$iv;
                byte[] $this$read$iv = transElement.elemValue;
                boolean $i$f$read = false;
                boolean bl = false;
                Object $this$toReadPacket$iv$iv = $this$read$iv;
                int offset$iv$iv = 0;
                int length$iv$iv = ((byte[])$this$toReadPacket$iv$iv).length - offset$iv$iv;
                boolean $i$f$toReadPacket = false;
                boolean $i$f$ByteReadPacket = false;
                boolean $i$f$ByteReadPacket2 = false;
                ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv, offset$iv$iv, length$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
                $this$toReadPacket$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv){
                    final /* synthetic */ byte[] $array;
                    {
                        this.$array = byArray;
                        super(1);
                    }

                    public final void invoke(@NotNull ByteBuffer it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        byte[] it2 = this.$array;
                        boolean bl = false;
                    }
                }));
                boolean $i$f$withUse = false;
                boolean bl2 = false;
                void var7_9 = $this$withUse$iv$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    ByteReadPacket $this$read = (ByteReadPacket)var7_9;
                    boolean bl5 = false;
                    byte var7 = $this$read.readByte();
                    if (var7 == (byte)1) {
                        while ($this$read.getRemaining() > (long)2) {
                            Input $this$readUShort$iv22 = (Input)$this$read;
                            boolean $i$f$readUShort = false;
                            short s = $this$readUShort$iv22.readShort();
                            boolean bl6 = false;
                            short $this$readUShort$iv22 = UShort.constructor-impl((short)s);
                            boolean bl7 = false;
                            ObjMsg.ObjMsg proto = (ObjMsg.ObjMsg)SerializationUtils.readProtoBuf($this$read, (DeserializationStrategy)ObjMsg.ObjMsg.Companion.serializer(), $this$readUShort$iv22 & 0xFFFF);
                            ProtoBuf protoBuf = (ObjMsg.MsgContentInfo)CollectionsKt.firstOrNull(proto.msgContentInfo);
                            if (protoBuf == null || (protoBuf = protoBuf.msgFile) == null) {
                                continue;
                            }
                            ProtoBuf file = protoBuf;
                            list.add((SingleMessage)new FileMessageImpl(((ObjMsg.MsgContentInfo.MsgFile)file).fileName, ((ObjMsg.MsgContentInfo.MsgFile)file).filePath, ((ObjMsg.MsgContentInfo.MsgFile)file).fileSize, ((ObjMsg.MsgContentInfo.MsgFile)file).busId));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_9, (Throwable)throwable);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void decodeCommonElem(ImMsgBody.CommonElem commonElem, MessageChainBuilder list) {
        switch (commonElem.serviceType) {
            case 23: {
                proto = (HummerCommelem.MsgElemInfoServtype23)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype23.Companion.serializer());
                list.add((SingleMessage)new VipFace(new VipFace.Kind(proto.faceType, proto.faceSummary), proto.faceBubbleCount));
                break;
            }
            case 2: {
                proto = (HummerCommelem.MsgElemInfoServtype2)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype2.Companion.serializer());
                var4_7 /* !! */  = proto.vaspokeName;
                var5_8 = false;
                var6_9 = false;
                var7_11 = var4_7 /* !! */ ;
                var12_13 = list;
                $i$a$-takeIf-ReceiveMessageTransformer$decodeCommonElem$1 = false;
                var9_15 = (CharSequence)it;
                var10_16 = false;
                var15_18 = var9_15.length() > 0;
                v0 = var12_13;
                v1 /* !! */  = var15_18 != false ? var4_7 /* !! */  : null;
                if (v1 /* !! */  != null) ** GOTO lbl41
                var4_7 /* !! */  = PokeMessage.values;
                var12_13 = v0;
                $i$f$firstOrNull = false;
                var6_10 = $this$firstOrNull$iv;
                var7_12 = ((void)var6_10).length;
                for (var8_14 = 0; var8_14 < var7_12; ++var8_14) {
                    it = element$iv = var6_10[var8_14];
                    $i$a$-firstOrNull-ReceiveMessageTransformer$decodeCommonElem$2 = false;
                    if (!(it.getId() == proto.vaspokeId && it.getPokeType() == proto.pokeType)) continue;
                    v2 = element$iv;
                    ** GOTO lbl33
                }
                v2 = null;
lbl33:
                // 2 sources

                var15_19 = v2;
                v0 = var12_13;
                v3 = var15_19;
                var4_7 /* !! */  = v3 != null ? v3.getName() : null;
                var5_8 = false;
                v1 /* !! */  = var4_7 /* !! */ ;
                if (var4_7 /* !! */  == null) {
                    v1 /* !! */  = "";
                }
lbl41:
                // 4 sources

                var16_21 = proto.vaspokeId;
                var17_22 = proto.pokeType;
                var18_23 = v1 /* !! */ ;
                v0.add((SingleMessage)new PokeMessage((String)var18_23, var17_22, var16_21));
                break;
            }
            case 3: {
                proto = (HummerCommelem.MsgElemInfoServtype3)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype3.Companion.serializer());
                if (proto.flashTroopPic != null) {
                    list.add((SingleMessage)new FlashImage((Image)new OnlineGroupImageImpl(proto.flashTroopPic)));
                }
                if (proto.flashC2cPic == null) break;
                list.add((SingleMessage)new FlashImage((Image)new OnlineFriendImageImpl(proto.flashC2cPic)));
                break;
            }
            case 33: {
                proto = (HummerCommelem.MsgElemInfoServtype33)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype33.Companion.serializer());
                list.add((SingleMessage)new Face(proto.index));
                break;
            }
        }
    }

    private final void decodeRichMessage(ImMsgBody.RichMsg richMsg, MessageChainBuilder builder) {
        boolean bl;
        Object object;
        String string = "\u89e3\u6790 richMsg";
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        try {
            String string2;
            object = Result.Companion;
            boolean bl4 = false;
            switch (richMsg.template1[0]) {
                case 0: {
                    byte[] $this$encodeToString$iv;
                    byte[] byArray = richMsg.template1;
                    int offset$iv = 1;
                    Charset charset$iv = Charsets.UTF_8;
                    boolean $i$f$encodeToString = false;
                    int length$iv$iv = $this$encodeToString$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv, offset$iv, length$iv$iv, charset$iv);
                    break;
                }
                case 1: {
                    byte[] $this$encodeToString$iv = MiraiUtils.unzip$default((byte[])richMsg.template1, (int)1, (int)0, (int)2, null);
                    int offset$iv = 0;
                    Charset charset$iv = Charsets.UTF_8;
                    boolean $i$f$encodeToString = false;
                    int length$iv$iv = $this$encodeToString$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv, offset$iv, length$iv$iv, charset$iv);
                    break;
                }
                default: {
                    String string3 = "unknown compression flag=" + richMsg.template1[0];
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            String string4 = string2;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)string4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl7 = false;
        boolean bl8 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl = false;
            String string5 = string;
            boolean bl9 = false;
            String string6 = MiraiUtils.toUHexString$default((byte[])richMsg.template1, null, (int)0, (int)0, (int)7, null);
            throw (Throwable)ContextualBugReportExceptionKt.contextualBugReportException$default(string5, string6, throwable2, null, 8, null);
        }
        String content = (String)object2;
        switch (richMsg.serviceId) {
            case 1: {
                builder.add((SingleMessage)new SimpleServiceMessage(1, content));
                break;
            }
            case 35: {
                ServiceMessage serviceMessage;
                Function1<String, String> $fun$findStringProperty$1 = new Function1<String, String>(content){
                    final /* synthetic */ String $content;

                    @NotNull
                    public final String invoke(@NotNull String name2) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        return StringsKt.substringBefore((String)StringsKt.substringAfter((String)this.$content, (String)(name2 + "=\""), (String)""), (String)"\"", (String)"");
                    }
                    {
                        this.$content = string;
                        super(1);
                    }
                };
                String resId = $fun$findStringProperty$1.invoke("m_resid");
                Object object3 = resId;
                boolean bl10 = false;
                if (object3.length() == 0) {
                    serviceMessage = (ServiceMessage)new SimpleServiceMessage(35, content);
                } else {
                    Object object4 = object3 = StringsKt.toIntOrNull((String)$fun$findStringProperty$1.invoke("multiMsgFlag"));
                    if (object4 != null && (Integer)object4 == 1) {
                        serviceMessage = (ServiceMessage)new LongMessageInternal(content, resId);
                    } else {
                        Object object5 = object3;
                        serviceMessage = object5 != null && (Integer)object5 == 0 ? (ServiceMessage)new ForwardMessageInternal(content, resId) : (Intrinsics.areEqual((Object)$fun$findStringProperty$1.invoke("action"), (Object)"viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content, resId) : (ServiceMessage)new SimpleServiceMessage(35, content));
                    }
                }
                ServiceMessage msg = serviceMessage;
                builder.add((SingleMessage)msg);
                break;
            }
            default: {
                builder.add((SingleMessage)new SimpleServiceMessage(richMsg.serviceId, content));
            }
        }
    }

    @NotNull
    public final Voice toVoice(@NotNull ImMsgBody.Ptt $this$toVoice) {
        Intrinsics.checkNotNullParameter((Object)$this$toVoice, (String)"$this$toVoice");
        byte[] bytes$iv = $this$toVoice.fileName;
        int offset$iv = 0;
        int length$iv = bytes$iv.length;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$String = false;
        String string = new String(bytes$iv, offset$iv, length$iv, charset$iv);
        bytes$iv = $this$toVoice.downPara;
        offset$iv = 0;
        length$iv = bytes$iv.length;
        charset$iv = Charsets.UTF_8;
        $i$f$String = false;
        return new Voice(string, $this$toVoice.fileMd5, (long)$this$toVoice.fileSize, $this$toVoice.format, new String(bytes$iv, offset$iv, length$iv, charset$iv));
    }

    private ReceiveMessageTransformer() {
    }

    static {
        ReceiveMessageTransformer receiveMessageTransformer;
        INSTANCE = receiveMessageTransformer = new ReceiveMessageTransformer();
        jsonForFileDecode = JsonKt.Json$default(null, (Function1)jsonForFileDecode.1.INSTANCE, (int)1, null);
    }
}

