/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.charsets.CharsetJVMKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.BytePacketBuilder;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.ByteReadPacket;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.Output;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.OutputKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.OutputPrimitivesKt;
import net.mamoe.mirai.internal.network.ContactListCacheKt;
import net.mamoe.mirai.internal.network.components.CacheValidator;
import net.mamoe.mirai.internal.network.components.Cacheable;
import net.mamoe.mirai.internal.network.components.SsoProcessorContext;
import net.mamoe.mirai.internal.utils.MiraiProtocolInternal;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.DeviceInfo;
import net.mamoe.mirai.utils.FileKt;
import net.mamoe.mirai.utils.MiraiFile;
import net.mamoe.mirai.utils.MiraiFileKt;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/mamoe/mirai/internal/network/components/CacheValidatorImpl;", "Lnet/mamoe/mirai/internal/network/components/CacheValidator;", "ssoProcessorContext", "Lnet/mamoe/mirai/internal/network/components/SsoProcessorContext;", "hashFile", "Lnet/mamoe/mirai/utils/MiraiFile;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/internal/network/components/SsoProcessorContext;Lnet/mamoe/mirai/utils/MiraiFile;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "caches", "", "Lnet/mamoe/mirai/internal/network/components/Cacheable;", "invalidate", "", "register", "cache", "validate", "mirai-core"})
public final class CacheValidatorImpl
implements CacheValidator {
    @NotNull
    private final SsoProcessorContext ssoProcessorContext;
    @NotNull
    private final MiraiFile hashFile;
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private final List<Cacheable> caches;

    public CacheValidatorImpl(@NotNull SsoProcessorContext ssoProcessorContext, @NotNull MiraiFile hashFile, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)ssoProcessorContext, (String)"ssoProcessorContext");
        Intrinsics.checkNotNullParameter((Object)hashFile, (String)"hashFile");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.ssoProcessorContext = ssoProcessorContext;
        this.hashFile = hashFile;
        this.logger = logger2;
        this.caches = new ArrayList();
    }

    @Override
    public void register(@NotNull Cacheable cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.caches.add(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void validate() {
        byte[] byArray5;
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            byte[] byArray2;
            byte[] byArray3;
            void byteArray$iv$iv;
            BytePacketBuilder $this$writeShortLVByteArray$iv$iv;
            byte[] byArray4;
            BytePacketBuilder $this$writeShortLVString$iv;
            BytePacketBuilder $this$validate_u24lambda_u2d0 = builder$iv;
            boolean byArray5 = false;
            BotConfiguration botConf = this.ssoProcessorContext.getConfiguration();
            OutputPrimitivesKt.writeInt((Output)((Output)$this$validate_u24lambda_u2d0), (int)botConf.getProtocol().ordinal());
            MiraiProtocolInternal internalProtocol = MiraiProtocolInternal.Companion.get(botConf.getProtocol());
            BytePacketBuilder bytePacketBuilder = $this$validate_u24lambda_u2d0;
            String str$iv = internalProtocol.apkId;
            boolean $i$f$writeShortLVString = false;
            void var11_32 = $this$writeShortLVString$iv;
            Object $this$toByteArray_u24default$iv$iv = str$iv;
            Charset charset$iv$iv = Charsets.UTF_8;
            boolean $i$f$toByteArray = false;
            if (Intrinsics.areEqual((Object)charset$iv$iv, (Object)Charsets.UTF_8)) {
                byArray4 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray4 = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray_u24default$iv$iv), (int)0, (int)((String)$this$toByteArray_u24default$iv$iv).length());
            }
            $this$toByteArray_u24default$iv$iv = byArray4;
            boolean $i$f$writeShortLVByteArray = false;
            OutputPrimitivesKt.writeShort((Output)((Output)$this$writeShortLVByteArray$iv$iv), (short)((short)((void)byteArray$iv$iv).length));
            OutputKt.writeFully$default((Output)((Output)$this$writeShortLVByteArray$iv$iv), (byte[])byteArray$iv$iv, (int)0, (int)0, (int)6, null);
            int cfr_ignored_0 = ((void)byteArray$iv$iv).length;
            OutputPrimitivesKt.writeLong((Output)((Output)$this$validate_u24lambda_u2d0), (long)internalProtocol.id);
            $this$writeShortLVString$iv = $this$validate_u24lambda_u2d0;
            str$iv = internalProtocol.sdkVer;
            $i$f$writeShortLVString = false;
            $this$writeShortLVByteArray$iv$iv = $this$writeShortLVString$iv;
            $this$toByteArray_u24default$iv$iv = str$iv;
            charset$iv$iv = Charsets.UTF_8;
            $i$f$toByteArray = false;
            if (Intrinsics.areEqual((Object)charset$iv$iv, (Object)Charsets.UTF_8)) {
                byArray3 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray3 = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray_u24default$iv$iv), (int)0, (int)((String)$this$toByteArray_u24default$iv$iv).length());
            }
            $this$toByteArray_u24default$iv$iv = byArray3;
            $i$f$writeShortLVByteArray = false;
            OutputPrimitivesKt.writeShort((Output)((Output)$this$writeShortLVByteArray$iv$iv), (short)((short)((void)byteArray$iv$iv).length));
            OutputKt.writeFully$default((Output)((Output)$this$writeShortLVByteArray$iv$iv), (byte[])byteArray$iv$iv, (int)0, (int)0, (int)6, null);
            int cfr_ignored_1 = ((void)byteArray$iv$iv).length;
            OutputPrimitivesKt.writeInt((Output)((Output)$this$validate_u24lambda_u2d0), (int)internalProtocol.miscBitMap);
            OutputPrimitivesKt.writeInt((Output)((Output)$this$validate_u24lambda_u2d0), (int)internalProtocol.subSigMap);
            OutputPrimitivesKt.writeInt((Output)((Output)$this$validate_u24lambda_u2d0), (int)internalProtocol.mainSigMap);
            $this$writeShortLVString$iv = $this$validate_u24lambda_u2d0;
            str$iv = internalProtocol.sign;
            $i$f$writeShortLVString = false;
            $this$writeShortLVByteArray$iv$iv = $this$writeShortLVString$iv;
            $this$toByteArray_u24default$iv$iv = str$iv;
            charset$iv$iv = Charsets.UTF_8;
            $i$f$toByteArray = false;
            if (Intrinsics.areEqual((Object)charset$iv$iv, (Object)Charsets.UTF_8)) {
                byArray2 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray2 = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray_u24default$iv$iv), (int)0, (int)((String)$this$toByteArray_u24default$iv$iv).length());
            }
            $this$toByteArray_u24default$iv$iv = byArray2;
            $i$f$writeShortLVByteArray = false;
            OutputPrimitivesKt.writeShort((Output)((Output)$this$writeShortLVByteArray$iv$iv), (short)((short)((void)byteArray$iv$iv).length));
            OutputKt.writeFully$default((Output)((Output)$this$writeShortLVByteArray$iv$iv), (byte[])byteArray$iv$iv, (int)0, (int)0, (int)6, null);
            int cfr_ignored_2 = ((void)byteArray$iv$iv).length;
            OutputPrimitivesKt.writeLong((Output)((Output)$this$validate_u24lambda_u2d0), (long)internalProtocol.buildTime);
            OutputPrimitivesKt.writeInt((Output)((Output)$this$validate_u24lambda_u2d0), (int)internalProtocol.ssoVersion);
            DeviceInfo device = this.ssoProcessorContext.getDevice();
            OutputKt.writeFully$default((Output)((Output)$this$validate_u24lambda_u2d0), (byte[])ContactListCacheKt.getProtoBufForCache().encodeToByteArray((SerializationStrategy)DeviceInfo.Companion.serializer(), (Object)device), (int)0, (int)0, (int)6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket pkg = byteReadPacket;
        boolean bl = false;
        try {
            byArray5 = net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.StringsKt.readBytes$default((ByteReadPacket)pkg, (int)0, (int)1, null);
        }
        finally {
            pkg.release();
        }
        byte[] hash = MiraiUtils.sha1$default((byte[])byArray5, (int)0, (int)0, (int)3, null);
        if (!this.hashFile.exists()) {
            Object $i$a$-runCatching-CacheValidatorImpl$validate$32;
            MiraiLogger $this$verbose$iv = this.logger;
            boolean $i$f$verbose22 = false;
            if ($this$verbose$iv.isVerboseEnabled()) {
                MiraiLogger miraiLogger = $this$verbose$iv;
                boolean bl2 = false;
                miraiLogger.verbose("Invalidate caches because hash file not available.");
            }
            this.invalidate();
            try {
                boolean $i$a$-runCatching-CacheValidatorImpl$validate$32 = false;
                FileKt.writeBytes((MiraiFile)this.hashFile, (byte[])hash);
                $i$a$-runCatching-CacheValidatorImpl$validate$32 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable $i$f$verbose22) {
                $i$a$-runCatching-CacheValidatorImpl$validate$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$verbose22));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-CacheValidatorImpl$validate$32);
            if (throwable != null) {
                Throwable it = $i$f$verbose22 = throwable;
                boolean bl3 = false;
                this.logger.warning("Exception in writing hash to validation file", it);
            }
            return;
        }
        if (!this.hashFile.isFile()) {
            Object $i$a$-runCatching-CacheValidatorImpl$validate$62;
            MiraiLogger $this$verbose$iv = this.logger;
            boolean $i$f$verbose32 = false;
            if ($this$verbose$iv.isVerboseEnabled()) {
                MiraiLogger miraiLogger = $this$verbose$iv;
                boolean bl4 = false;
                miraiLogger.verbose("hash file isn't a file.");
            }
            this.invalidate();
            try {
                boolean $i$a$-runCatching-CacheValidatorImpl$validate$62 = false;
                MiraiFileKt.deleteRecursively((MiraiFile)this.hashFile);
                FileKt.writeBytes((MiraiFile)this.hashFile, (byte[])hash);
                $i$a$-runCatching-CacheValidatorImpl$validate$62 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable $i$f$verbose32) {
                $i$a$-runCatching-CacheValidatorImpl$validate$62 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$verbose32));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-CacheValidatorImpl$validate$62);
            if (throwable != null) {
                Throwable it = $i$f$verbose32 = throwable;
                boolean bl5 = false;
                this.logger.warning("Exception in writing hash to validation file", it);
            }
            return;
        }
        try {
            boolean $i$f$verbose;
            MiraiLogger $this$verbose$iv;
            byte[] hashInFile = FileKt.readBytes((MiraiFile)this.hashFile);
            if (Arrays.equals(hashInFile, hash)) {
                $this$verbose$iv = this.logger;
                $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl6 = false;
                    miraiLogger.verbose("Validated caches.");
                }
                return;
            }
            $this$verbose$iv = this.logger;
            $i$f$verbose = false;
            if ($this$verbose$iv.isVerboseEnabled()) {
                MiraiLogger miraiLogger = $this$verbose$iv;
                boolean bl7 = false;
                miraiLogger.verbose("Hash not match. Invaliding caches.....");
            }
            this.invalidate();
            FileKt.writeBytes((MiraiFile)this.hashFile, (byte[])hash);
        }
        catch (Throwable e) {
            this.logger.warning("Exception in validation. Invalidating.....", e);
            this.invalidate();
        }
    }

    private final void invalidate() {
        Iterable $this$forEach$iv = this.caches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Cacheable it = (Cacheable)element$iv;
            boolean bl = false;
            it.invalidate();
        }
    }
}

