/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.client.engine.okhttp;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import net.mamoe.mirai.internal.deps.io.ktor.client.engine.okhttp.OkHttpCallback;
import net.mamoe.mirai.internal.deps.io.ktor.client.plugins.HttpTimeoutKt;
import net.mamoe.mirai.internal.deps.io.ktor.client.request.HttpRequestData;
import net.mamoe.mirai.internal.deps.io.ktor.http.Headers;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpProtocolVersion;
import net.mamoe.mirai.internal.deps.okhttp3.Call;
import net.mamoe.mirai.internal.deps.okhttp3.OkHttpClient;
import net.mamoe.mirai.internal.deps.okhttp3.Protocol;
import net.mamoe.mirai.internal.deps.okhttp3.Request;
import net.mamoe.mirai.internal.deps.okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a%\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a\f\u0010\f\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0005H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"mapOkHttpException", "", "requestData", "Lnet/mamoe/mirai/internal/deps/io/ktor/client/request/HttpRequestData;", "origin", "Ljava/io/IOException;", "execute", "Lnet/mamoe/mirai/internal/deps/okhttp3/Response;", "Lnet/mamoe/mirai/internal/deps/okhttp3/OkHttpClient;", "request", "Lnet/mamoe/mirai/internal/deps/okhttp3/Request;", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fromOkHttp", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/Headers;", "Lnet/mamoe/mirai/internal/deps/okhttp3/Headers;", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpProtocolVersion;", "Lnet/mamoe/mirai/internal/deps/okhttp3/Protocol;", "isConnectException", "", "unwrapSuppressed", "ktor-client-okhttp"})
public final class OkUtilsKt {
    @Nullable
    public static final Object execute(@NotNull OkHttpClient $this$execute, @NotNull Request request2, @NotNull HttpRequestData requestData, @NotNull Continuation<? super Response> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Response> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation2 = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Call call = $this$execute.newCall(request2);
        call.enqueue(new OkHttpCallback(requestData, (CancellableContinuation<? super Response>)continuation2));
        continuation2.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(call){
            final /* synthetic */ Call $call;
            {
                this.$call = $call;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.$call.cancel();
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @NotNull
    public static final Headers fromOkHttp(@NotNull net.mamoe.mirai.internal.deps.okhttp3.Headers $this$fromOkHttp) {
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        return new Headers($this$fromOkHttp){
            private final boolean caseInsensitiveName;
            final /* synthetic */ net.mamoe.mirai.internal.deps.okhttp3.Headers $this_fromOkHttp;
            {
                this.$this_fromOkHttp = $receiver;
                this.caseInsensitiveName = true;
            }

            public boolean getCaseInsensitiveName() {
                return this.caseInsensitiveName;
            }

            @Nullable
            public List<String> getAll(@NotNull String name) {
                List<String> list2;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List<String> it = list2 = this.$this_fromOkHttp.values(name);
                boolean bl = false;
                return !((Collection)it).isEmpty() ? list2 : null;
            }

            @NotNull
            public Set<String> names() {
                return this.$this_fromOkHttp.names();
            }

            @NotNull
            public Set<Map.Entry<String, List<String>>> entries() {
                return this.$this_fromOkHttp.toMultimap().entrySet();
            }

            public boolean isEmpty() {
                return this.$this_fromOkHttp.size() == 0;
            }

            public boolean contains(@NotNull String name) {
                return Headers.DefaultImpls.contains(this, name);
            }

            public boolean contains(@NotNull String name, @NotNull String value) {
                return Headers.DefaultImpls.contains(this, name, value);
            }

            public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body2) {
                Headers.DefaultImpls.forEach(this, body2);
            }

            @Nullable
            public String get(@NotNull String name) {
                return Headers.DefaultImpls.get(this, name);
            }
        };
    }

    @NotNull
    public static final HttpProtocolVersion fromOkHttp(@NotNull Protocol $this$fromOkHttp) {
        HttpProtocolVersion httpProtocolVersion;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$fromOkHttp), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$fromOkHttp.ordinal()]) {
            case 1: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_0();
                break;
            }
            case 2: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_1();
                break;
            }
            case 3: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getSPDY_3();
                break;
            }
            case 4: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 5: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 6: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getQUIC();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpProtocolVersion;
    }

    /*
     * WARNING - void declaration
     */
    private static final Throwable mapOkHttpException(HttpRequestData requestData, IOException origin) {
        void var2_2;
        Throwable cause = OkUtilsKt.unwrapSuppressed(origin);
        return cause instanceof SocketTimeoutException ? (Throwable)(OkUtilsKt.isConnectException((IOException)cause) ? (IOException)HttpTimeoutKt.ConnectTimeoutException(requestData, cause) : (IOException)HttpTimeoutKt.SocketTimeoutException(requestData, cause)) : var2_2;
    }

    private static final boolean isConnectException(IOException $this$isConnectException) {
        String string = $this$isConnectException.getMessage();
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"connect", (boolean)true) : false;
    }

    private static final Throwable unwrapSuppressed(IOException $this$unwrapSuppressed) {
        Throwable[] throwableArray = $this$unwrapSuppressed.getSuppressed();
        Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"suppressed");
        if (!(((Object[])throwableArray).length == 0)) {
            Throwable throwable = $this$unwrapSuppressed.getSuppressed()[0];
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"suppressed[0]");
            return throwable;
        }
        return $this$unwrapSuppressed;
    }

    public static final /* synthetic */ Throwable access$mapOkHttpException(HttpRequestData requestData, IOException origin) {
        return OkUtilsKt.mapOkHttpException(requestData, origin);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Protocol.values().length];
            nArray[Protocol.HTTP_1_0.ordinal()] = 1;
            nArray[Protocol.HTTP_1_1.ordinal()] = 2;
            nArray[Protocol.SPDY_3.ordinal()] = 3;
            nArray[Protocol.HTTP_2.ordinal()] = 4;
            nArray[Protocol.H2_PRIOR_KNOWLEDGE.ordinal()] = 5;
            nArray[Protocol.QUIC.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

