/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.Ecdh;
import net.mamoe.mirai.internal.utils.crypto.EcdhKeyPair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013H\u0014J\u0010\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00160\u0016H\u0014J\u0010\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00180\u0018H\u0014J\u0010\u0010\u0019\u001a\n \u0014*\u0004\u0018\u00010\u001a0\u001aH\u0014\u00a8\u0006\u001b"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/JceEcdh;", "Lnet/mamoe/mirai/internal/utils/crypto/Ecdh;", "Ljava/security/interfaces/ECPublicKey;", "Ljava/security/interfaces/ECPrivateKey;", "()V", "calculateShareKey", "", "peerKey", "privateKey", "countLeadingZeros", "", "bytes", "exportPublicKey", "key", "generateKeyPair", "Lnet/mamoe/mirai/internal/utils/crypto/EcdhKeyPair;", "importPublicKey", "encoded", "newECAlgorithmParameters", "Ljava/security/AlgorithmParameters;", "kotlin.jvm.PlatformType", "newECDHKeyAgreement", "Ljavax/crypto/KeyAgreement;", "newECKeyFactory", "Ljava/security/KeyFactory;", "newECKeyPairGenerator", "Ljava/security/KeyPairGenerator;", "mirai-core"})
public class JceEcdh
implements Ecdh<ECPublicKey, ECPrivateKey> {
    protected KeyPairGenerator newECKeyPairGenerator() {
        return KeyPairGenerator.getInstance("EC");
    }

    protected KeyFactory newECKeyFactory() {
        return KeyFactory.getInstance("EC");
    }

    protected AlgorithmParameters newECAlgorithmParameters() {
        return AlgorithmParameters.getInstance("EC");
    }

    protected KeyAgreement newECDHKeyAgreement() {
        return KeyAgreement.getInstance("ECDH");
    }

    @Override
    @NotNull
    public EcdhKeyPair<ECPublicKey, ECPrivateKey> generateKeyPair() {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator $this$generateKeyPair_u24lambda_u2d0 = keyPairGenerator = this.newECKeyPairGenerator();
        boolean bl = false;
        $this$generateKeyPair_u24lambda_u2d0.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair it = keyPairGenerator.genKeyPair();
        boolean bl2 = false;
        PublicKey publicKey = it.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        PrivateKey privateKey = it.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        return new EcdhKeyPair<ECPublicKey, ECPrivateKey>(eCPublicKey, (ECPrivateKey)privateKey);
    }

    @Override
    @NotNull
    public byte[] calculateShareKey(@NotNull ECPublicKey peerKey, @NotNull ECPrivateKey privateKey) {
        KeyAgreement keyAgreement;
        Intrinsics.checkNotNullParameter((Object)peerKey, (String)"peerKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        KeyAgreement $this$calculateShareKey_u24lambda_u2d2 = keyAgreement = this.newECDHKeyAgreement();
        boolean bl = false;
        $this$calculateShareKey_u24lambda_u2d2.init(privateKey);
        $this$calculateShareKey_u24lambda_u2d2.doPhase(peerKey, true);
        byte[] byArray = keyAgreement.generateSecret();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"newECDHKeyAgreement().ap\u2026       }.generateSecret()");
        return byArray;
    }

    @Override
    @NotNull
    public ECPublicKey importPublicKey(@NotNull byte[] encoded) {
        AlgorithmParameters algorithmParameters;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        AlgorithmParameters $this$importPublicKey_u24lambda_u2d3 = algorithmParameters = this.newECAlgorithmParameters();
        boolean bl = false;
        $this$importPublicKey_u24lambda_u2d3.init(new ECGenParameterSpec("secp256r1"));
        ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"newECAlgorithmParameters\u2026arameterSpec::class.java)");
        ECParameterSpec params = eCParameterSpec;
        if (!(encoded[0] == 4)) {
            boolean $i$a$-require-JceEcdh$importPublicKey$22 = false;
            String $i$a$-require-JceEcdh$importPublicKey$22 = "Only uncompressed format is supported";
            throw new IllegalArgumentException($i$a$-require-JceEcdh$importPublicKey$22.toString());
        }
        int fieldSize = params.getCurve().getField().getFieldSize();
        int elementSize = (fieldSize + 7) / 8;
        byte[] affineXBytes = new byte[elementSize];
        byte[] affineYBytes = new byte[elementSize];
        System.arraycopy(encoded, 1, affineXBytes, 0, elementSize);
        System.arraycopy(encoded, elementSize + 1, affineYBytes, 0, elementSize);
        ECPoint point = new ECPoint(new BigInteger(1, affineXBytes), new BigInteger(1, affineYBytes));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, params);
        PublicKey publicKey = this.newECKeyFactory().generatePublic(keySpec);
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return (ECPublicKey)publicKey;
    }

    @Override
    @NotNull
    public byte[] exportPublicKey(@NotNull ECPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ECPoint point = key.getW();
        int fieldSize = key.getParams().getCurve().getField().getFieldSize();
        int elementSize = (fieldSize + 7) / 8;
        byte[] x = point.getAffineX().toByteArray();
        byte[] y = point.getAffineY().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int startOfX = this.countLeadingZeros(x);
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        int startOfY = this.countLeadingZeros(y);
        byte[] encoded = new byte[elementSize * 2 + 1];
        encoded[0] = 4;
        System.arraycopy(x, startOfX, encoded, elementSize - x.length + startOfX + 1, x.length - startOfX);
        System.arraycopy(y, startOfY, encoded, encoded.length - y.length + startOfY, y.length - startOfY);
        return encoded;
    }

    private final int countLeadingZeros(byte[] bytes) {
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            if (bytes[i] == 0) continue;
            return i;
        }
        return bytes.length;
    }
}

