/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.io.serialization.tars.internal;

import java.io.EOFException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.Input;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.InputPrimitivesKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.Output;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.DebugLogger;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.TarsHead;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.TarsOldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0017H\u0002J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020 2\b\b\u0002\u0010\u001e\u001a\u00020\u0001J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0010\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020 H\u0001JI\u0010/\u001a\u0002H0\"\b\b\u0000\u00100*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00192\u000e\b\u0006\u00101\u001a\b\u0012\u0004\u0012\u00020,022\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J7\u00106\u001a\u0004\u0018\u0001H0\"\u0004\b\u0000\u001002\u0006\u0010\u001a\u001a\u00020\u00192\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0013\u00108\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0010J\u000e\u00109\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019J-\u0010:\u001a\u0002H0\"\u0004\b\u0000\u001002\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsInput;", "", "input", "Lnet/mamoe/mirai/internal/deps/io/ktor/utils/io/core/Input;", "charset", "Ljava/nio/charset/Charset;", "Lnet/mamoe/mirai/internal/deps/io/ktor/utils/io/charsets/Charset;", "debugLogger", "Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/DebugLogger;", "(Lio/ktor/utils/io/core/Input;Ljava/nio/charset/Charset;Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/DebugLogger;)V", "_head", "Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsHead;", "_nextHead", "currentHead", "getCurrentHead", "()Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsHead;", "currentHeadOrNull", "getCurrentHeadOrNull", "getInput", "()Lio/ktor/utils/io/core/Input;", "nextHead", "peekNextHead", "prepareNextHead", "", "readInt32", "", "tag", "readNextHeadButDoNotAssignTo_Head", "ignoreNextHead", "readTarsBooleanValue", "head", "readTarsByteValue", "", "readTarsDoubleValue", "", "readTarsFloatValue", "", "readTarsIntValue", "type", "readTarsLongValue", "", "readTarsShortValue", "", "readTarsStringValue", "", "skipField", "", "skipToHeadAndUseIfPossibleOrFail", "R", "message", "Lkotlin/Function0;", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "skipToHeadAndUseIfPossibleOrNull", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "skipToHeadOrNull", "skipToTag", "useHead", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mirai-core"})
public final class TarsInput {
    @NotNull
    private final Input input;
    @NotNull
    private final Charset charset;
    @NotNull
    private final DebugLogger debugLogger;
    @Nullable
    private TarsHead _head;
    @Nullable
    private TarsHead _nextHead;

    public TarsInput(@NotNull Input input, @NotNull Charset charset, @NotNull DebugLogger debugLogger) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)debugLogger, (String)"debugLogger");
        this.input = input;
        this.charset = charset;
        this.debugLogger = debugLogger;
        this.prepareNextHead();
    }

    @NotNull
    public final Input getInput() {
        return this.input;
    }

    @NotNull
    public final TarsHead getCurrentHead() {
        TarsHead tarsHead = this._head;
        if (tarsHead == null) {
            throw new EOFException("No current TarsHead available");
        }
        return tarsHead;
    }

    @Nullable
    public final TarsHead getCurrentHeadOrNull() {
        return this._head;
    }

    @Nullable
    public final TarsHead peekNextHead() {
        TarsHead tarsHead;
        TarsHead tarsHead2 = this._nextHead;
        if (tarsHead2 != null) {
            TarsHead it = tarsHead2;
            boolean bl = false;
            return it;
        }
        TarsHead it = tarsHead = this.readNextHeadButDoNotAssignTo_Head(true);
        boolean bl = false;
        this._nextHead = it;
        it = tarsHead;
        boolean bl2 = false;
        this.debugLogger.println("Peek next head: " + it);
        return tarsHead;
    }

    public final boolean prepareNextHead() {
        TarsHead tarsHead;
        TarsHead it = tarsHead = TarsInput.readNextHeadButDoNotAssignTo_Head$default(this, false, 1, null);
        boolean bl = false;
        this._head = it;
        return tarsHead != null;
    }

    @NotNull
    public final TarsHead nextHead() {
        if (!this.prepareNextHead()) {
            throw new EOFException("No more TarsHead available");
        }
        return this.getCurrentHead();
    }

    private final TarsHead readNextHeadButDoNotAssignTo_Head(boolean ignoreNextHead) {
        byte $this$readUByte$iv22;
        TarsHead n;
        if (!ignoreNextHead && (n = this._nextHead) != null) {
            this._nextHead = null;
            return n;
        }
        if (this.input.getEndOfInput()) {
            return null;
        }
        try {
            Input $this$readUByte$iv22 = this.input;
            boolean $i$f$readUByte = false;
            $this$readUByte$iv22 = UByte.constructor-impl((byte)$this$readUByte$iv22.readByte());
        }
        catch (EOFException e) {
            return null;
        }
        byte var2 = $this$readUByte$iv22;
        byte type = UByte.constructor-impl((byte)((byte)(var2 & 0xF)));
        int tag = UInt.constructor-impl((int)(UInt.constructor-impl((int)(var2 & 0xFF)) >>> 4));
        if (tag == 15) {
            Input $this$readUByte$iv = this.input;
            boolean $i$f$readUByte = false;
            tag = UInt.constructor-impl((int)(UByte.constructor-impl((byte)$this$readUByte$iv.readByte()) & 0xFF));
        }
        return new TarsHead(tag, type);
    }

    static /* synthetic */ TarsHead readNextHeadButDoNotAssignTo_Head$default(TarsInput tarsInput, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return tarsInput.readNextHeadButDoNotAssignTo_Head(bl);
    }

    public final <R> R useHead(@NotNull Function1<? super TarsHead, ? extends R> block2) {
        Object object;
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$useHead = false;
        Object it = object = block2.invoke((Object)this.getCurrentHead());
        boolean bl = false;
        this.prepareNextHead();
        return (R)object;
    }

    @Nullable
    public final <R> R skipToHeadAndUseIfPossibleOrNull(int tag, @NotNull Function1<? super TarsHead, ? extends R> block2) {
        Object object;
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this.skipToHeadOrNull(tag);
        Object it = object = tarsHead != null ? block2.invoke((Object)tarsHead) : null;
        boolean bl = false;
        this.prepareNextHead();
        return (R)object;
    }

    @NotNull
    public final <R> R skipToHeadAndUseIfPossibleOrFail(int tag, @NotNull Function0<String> message2, @NotNull Function1<? super TarsHead, ? extends R> block2) {
        Object object;
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrFail = false;
        TarsInput this_$iv = this;
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this_$iv.skipToHeadOrNull(tag);
        Object it$iv = object = tarsHead != null ? block2.invoke((Object)tarsHead) : null;
        boolean bl = false;
        this_$iv.prepareNextHead();
        Object object2 = object;
        if (object2 == null) {
            Object object3 = message2.invoke();
            throw new IllegalStateException(object3.toString());
        }
        return (R)object2;
    }

    public static /* synthetic */ Object skipToHeadAndUseIfPossibleOrFail$default(TarsInput $this, int tag, Function0 message2, Function1 block2, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            message2 = (Function0)new Function0<String>(tag){
                final /* synthetic */ int $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "tag not found: " + this.$tag;
                }
            };
        }
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrFail = false;
        TarsInput this_$iv = $this;
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this_$iv.skipToHeadOrNull(tag);
        Object it$iv = object2 = tarsHead != null ? block2.invoke((Object)tarsHead) : null;
        boolean bl = false;
        this_$iv.prepareNextHead();
        Object object3 = object2;
        if (object3 == null) {
            Object object4 = message2.invoke();
            throw new IllegalStateException(object4.toString());
        }
        return object3;
    }

    public final boolean skipToTag(int tag) {
        while (this.peekNextHead() != null) {
            TarsHead hd;
            if (tag <= hd.getTag() || hd.getType() == 11) {
                return tag == hd.getTag();
            }
            this.debugLogger.println("Discard " + tag + ", " + hd + ", " + hd.getSize());
            this.input.discardExact(hd.getSize());
            this.skipField(hd.getType());
        }
        return false;
    }

    public final int readInt32(int tag) {
        if (!this.skipToTag(tag)) {
            return 0;
        }
        return this.readTarsIntValue(this.nextHead());
    }

    @Nullable
    public final TarsHead skipToHeadOrNull(int tag) {
        TarsHead tarsHead;
        TarsInput tarsInput = this;
        int n = tag;
        while (true) {
            TarsHead current;
            TarsInput tarsInput2 = tarsInput;
            int n2 = n;
            if (tarsInput2.getCurrentHeadOrNull() == null) {
                return null;
            }
            if (current.getTag() > n2) {
                tarsHead = null;
                break;
            }
            if (current.getTag() == n2) {
                tarsHead = current;
                break;
            }
            tarsInput2.skipField(current.getType());
            if (!tarsInput2.prepareNextHead()) {
                boolean bl = false;
                String string = "cannot skip to tag " + n2 + ", early EOF";
                throw new IllegalStateException(string.toString());
            }
            tarsInput = tarsInput2;
            n = n2;
        }
        return tarsHead;
    }

    @PublishedApi
    public final void skipField(byte type) {
        int n;
        int it;
        int $i$f$readUByte;
        Appendable appendable;
        DebugLogger this_$iv = this.debugLogger;
        boolean $i$f$println = false;
        Output output = this_$iv.getOut();
        if (output != null) {
            StringBuilder stringBuilder = new StringBuilder().append(StringsKt.repeat((CharSequence)"    ", (int)this_$iv.getStructureHierarchy()));
            Appendable appendable2 = output;
            boolean bl = false;
            String string = "skipping " + TarsHead.Companion.findTarsTypeName(type);
            Appendable appendable3 = appendable2.append(stringBuilder.append(string).toString());
            Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(value)");
            Appendable appendable4 = appendable3.append('\n');
            appendable = appendable4;
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append('\\n')");
        } else {
            appendable = null;
        }
        byte by = type;
        if (by == 0) {
            this.input.discardExact(1);
        } else if (by == 1) {
            this.input.discardExact(2);
        } else if (by == 2) {
            this.input.discardExact(4);
        } else if (by == 3) {
            this.input.discardExact(8);
        } else if (by == 4) {
            this.input.discardExact(4);
        } else if (by == 5) {
            this.input.discardExact(8);
        } else if (by == 6) {
            Input $this$readUByte$iv = this.input;
            $i$f$readUByte = 0;
            this.input.discardExact(UByte.constructor-impl((byte)$this$readUByte$iv.readByte()) & 0xFF);
        } else if (by == 7) {
            this.input.discardExact(InputPrimitivesKt.readInt(this.input));
        } else if (by == 8) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            $i$f$readUByte = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy($i$f$readUByte + 1);
            it = $this$readUByte$iv = this.readInt32(0);
            boolean bl = false;
            this.debugLogger.println("SIZE = " + it);
            $this$readUByte$iv *= 2;
            it = 0;
            while (it < $this$readUByte$iv) {
                int it2 = it++;
                boolean bl2 = false;
                this.skipField(this.nextHead().getType());
            }
            $this$readUByte$iv = this.debugLogger;
            it = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(it + -1);
        } else if (by == 9) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            it = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(it + 1);
            it = $this$readUByte$iv = this.readInt32(0);
            boolean bl = false;
            this.debugLogger.println("SIZE = " + it);
            n = 0;
            while (n < $this$readUByte$iv) {
                int it3 = n++;
                boolean bl3 = false;
                this.skipField(this.nextHead().getType());
            }
            $this$readUByte$iv = this.debugLogger;
            n = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(n + -1);
        } else if (by == 10) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            n = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(n + 1);
            TarsHead head2 = null;
            do {
                if ((head2 = this.nextHead()).getType() == 11) {
                    DebugLogger debugLogger = this.debugLogger;
                    int it3 = debugLogger.getStructureHierarchy();
                    debugLogger.setStructureHierarchy(it3 + -1);
                    this.skipField(head2.getType());
                    break;
                }
                this.skipField(head2.getType());
            } while (head2.getType() != 11);
        } else if (!(by == 11 ? true : by == 12)) {
            if (by == 13) {
                Object head2 = this.debugLogger;
                n = ((DebugLogger)head2).getStructureHierarchy();
                ((DebugLogger)head2).setStructureHierarchy(n + 1);
                head2 = null;
                head2 = this.nextHead();
                if (!(((TarsHead)head2).getType() == 0)) {
                    boolean $i$a$-check-TarsInput$skipField$92 = false;
                    String $i$a$-check-TarsInput$skipField$92 = "bad simple list element type: " + ((TarsHead)head2).getType() + ", " + head2;
                    throw new IllegalStateException($i$a$-check-TarsInput$skipField$92.toString());
                }
                if (!(((TarsHead)head2).getTag() == 0)) {
                    boolean $i$a$-check-TarsInput$skipField$102 = false;
                    String $i$a$-check-TarsInput$skipField$102 = "simple list element tag must be 0, but was " + ((TarsHead)head2).getTag();
                    throw new IllegalStateException($i$a$-check-TarsInput$skipField$102.toString());
                }
                head2 = this.nextHead();
                if (!(((TarsHead)head2).getTag() == 0)) {
                    boolean bl = false;
                    String string = "tag for size for simple list must be 0, but was " + ((TarsHead)head2).getTag();
                    throw new IllegalStateException(string.toString());
                }
                this.input.discardExact(this.readTarsIntValue((TarsHead)head2));
                DebugLogger debugLogger = this.debugLogger;
                int n2 = debugLogger.getStructureHierarchy();
                debugLogger.setStructureHierarchy(n2 + -1);
            } else {
                throw new IllegalStateException(("invalid type: " + type).toString());
            }
        }
    }

    public final int readTarsIntValue(@NotNull TarsHead head2) {
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        return this.readTarsIntValue(head2.getType(), head2);
    }

    public final int readTarsIntValue(byte type, @NotNull Object head2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by = type;
        if (by == 12) {
            n = 0;
        } else if (by == 0) {
            n = this.input.readByte();
        } else if (by == 1) {
            n = InputPrimitivesKt.readShort(this.input);
        } else if (by == 2) {
            n = InputPrimitivesKt.readInt(this.input);
        } else {
            throw new IllegalStateException(("type mismatch: " + head2 + ", expecting int.").toString());
        }
        return n;
    }

    public static /* synthetic */ int readTarsIntValue$default(TarsInput tarsInput, byte by, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = by;
        }
        return tarsInput.readTarsIntValue(by, object);
    }

    public final short readTarsShortValue(@NotNull TarsHead head2) {
        short s;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by = head2.getType();
        if (by == 12) {
            s = 0;
        } else if (by == 0) {
            s = this.input.readByte();
        } else if (by == 1) {
            s = InputPrimitivesKt.readShort(this.input);
        } else {
            throw new IllegalStateException(("type mismatch: " + head2 + ", expecting short.").toString());
        }
        return s;
    }

    public final long readTarsLongValue(@NotNull TarsHead head2) {
        long l;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by = head2.getType();
        if (by == 12) {
            l = 0L;
        } else if (by == 0) {
            l = this.input.readByte();
        } else if (by == 1) {
            l = InputPrimitivesKt.readShort(this.input);
        } else if (by == 2) {
            l = InputPrimitivesKt.readInt(this.input);
        } else if (by == 3) {
            l = InputPrimitivesKt.readLong(this.input);
        } else {
            throw new IllegalStateException(("type mismatch " + head2 + ", expecting long.").toString());
        }
        return l;
    }

    public final byte readTarsByteValue(@NotNull TarsHead head2) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by2 = head2.getType();
        if (by2 == 12) {
            by = 0;
        } else if (by2 == 0) {
            by = this.input.readByte();
        } else {
            throw new IllegalStateException(("type mismatch: " + head2 + ", expecting byte.").toString());
        }
        return by;
    }

    public final float readTarsFloatValue(@NotNull TarsHead head2) {
        float f;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by = head2.getType();
        if (by == 12) {
            f = 0.0f;
        } else if (by == 4) {
            f = InputPrimitivesKt.readFloat(this.input);
        } else {
            throw new IllegalStateException(("type mismatch: " + head2 + ", expecting float.").toString());
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readTarsStringValue(@NotNull TarsHead head2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        byte by = head2.getType();
        if (by == 6) {
            Input $this$readUByte$iv = this.input;
            boolean $i$f$readUByte = false;
            string = TarsOldKt.readString(this.input, UByte.constructor-impl((byte)$this$readUByte$iv.readByte()) & 0xFF, this.charset);
        } else if (by == 7) {
            void it;
            int n;
            Input $this$readUInt$iv = this.input;
            int $i$f$readUInt = 0;
            $i$f$readUInt = n = UInt.constructor-impl((int)InputPrimitivesKt.readInt($this$readUInt$iv));
            Input input = this.input;
            boolean bl = false;
            if (!(true <= it ? it < 0x6400000 : false)) {
                boolean bl2 = false;
                String string2 = "bad string length: " + (int)it;
                throw new IllegalArgumentException(string2.toString());
            }
            string = TarsOldKt.readString(input, n, this.charset);
        } else {
            throw new IllegalStateException(("type mismatch: " + head2 + ", expecting 6 or 7 (for string)").toString());
        }
        return string;
    }

    public final double readTarsDoubleValue(@NotNull TarsHead head2) {
        double d;
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        switch (head2.getType()) {
            case 12: {
                d = 0.0;
                break;
            }
            case 4: {
                d = InputPrimitivesKt.readFloat(this.input);
                break;
            }
            case 5: {
                d = InputPrimitivesKt.readDouble(this.input);
                break;
            }
            default: {
                throw new IllegalStateException(("type mismatch: " + head2).toString());
            }
        }
        return d;
    }

    public final boolean readTarsBooleanValue(@NotNull TarsHead head2) {
        Intrinsics.checkNotNullParameter((Object)head2, (String)"head");
        return this.readTarsByteValue(head2) == 1;
    }
}

