/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.ECDH;
import net.mamoe.mirai.internal.utils.crypto.ECDHInitialPublicKey;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPair;
import net.mamoe.mirai.internal.utils.crypto.ECDHKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDHWithPublicKey;", "", "initialPublicKey", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHInitialPublicKey;", "(Lnet/mamoe/mirai/internal/utils/crypto/ECDHInitialPublicKey;)V", "ecdhInstance", "Lnet/mamoe/mirai/internal/utils/crypto/ECDH;", "keyPair", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "getKeyPair", "()Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "version", "", "getVersion", "()I", "calculateShareKeyByPeerPublicKey", "", "peerPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "mirai-core"})
public final class ECDHWithPublicKey {
    @NotNull
    private final ECDHInitialPublicKey initialPublicKey;
    @NotNull
    private final ECDH ecdhInstance;
    private final int version;
    @NotNull
    private final ECDHKeyPair keyPair;

    public ECDHWithPublicKey(@NotNull ECDHInitialPublicKey initialPublicKey2) {
        Intrinsics.checkNotNullParameter((Object)initialPublicKey2, (String)"initialPublicKey");
        this.initialPublicKey = initialPublicKey2;
        this.ecdhInstance = new ECDH(ECDH.Companion.generateKeyPair(this.initialPublicKey.getKey$mirai_core()));
        this.version = this.initialPublicKey.getVersion();
        this.keyPair = this.ecdhInstance.getKeyPair();
    }

    public /* synthetic */ ECDHWithPublicKey(ECDHInitialPublicKey eCDHInitialPublicKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eCDHInitialPublicKey = ECDHKt.getDefaultInitialPublicKey();
        }
        this(eCDHInitialPublicKey);
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final ECDHKeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final byte[] calculateShareKeyByPeerPublicKey(@NotNull PublicKey peerPublicKey) {
        Intrinsics.checkNotNullParameter((Object)peerPublicKey, (String)"peerPublicKey");
        return this.ecdhInstance.calculateShareKeyByPeerPublicKey(peerPublicKey);
    }

    private final ECDHInitialPublicKey component1() {
        return this.initialPublicKey;
    }

    @NotNull
    public final ECDHWithPublicKey copy(@NotNull ECDHInitialPublicKey initialPublicKey2) {
        Intrinsics.checkNotNullParameter((Object)initialPublicKey2, (String)"initialPublicKey");
        return new ECDHWithPublicKey(initialPublicKey2);
    }

    public static /* synthetic */ ECDHWithPublicKey copy$default(ECDHWithPublicKey eCDHWithPublicKey, ECDHInitialPublicKey eCDHInitialPublicKey, int n, Object object) {
        if ((n & 1) != 0) {
            eCDHInitialPublicKey = eCDHWithPublicKey.initialPublicKey;
        }
        return eCDHWithPublicKey.copy(eCDHInitialPublicKey);
    }

    @NotNull
    public String toString() {
        return "ECDHWithPublicKey(initialPublicKey=" + this.initialPublicKey + ')';
    }

    public int hashCode() {
        return this.initialPublicKey.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ECDHWithPublicKey)) {
            return false;
        }
        ECDHWithPublicKey eCDHWithPublicKey = (ECDHWithPublicKey)other;
        return Intrinsics.areEqual((Object)this.initialPublicKey, (Object)eCDHWithPublicKey.initialPublicKey);
    }

    public ECDHWithPublicKey() {
        this(null, 1, null);
    }
}

