/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.http.content;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.mamoe.mirai.internal.deps.io.ktor.http.ContentType;
import net.mamoe.mirai.internal.deps.io.ktor.http.ContentTypesKt;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpStatusCode;
import net.mamoe.mirai.internal.deps.io.ktor.http.content.OutgoingContent;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.charsets.CharsetJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lnet/mamoe/mirai/internal/deps/io/ktor/http/content/TextContent;", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/content/OutgoingContent$ByteArrayContent;", "text", "", "contentType", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/ContentType;", "status", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpStatusCode;", "(Ljava/lang/String;Lio/ktor/http/ContentType;Lio/ktor/http/HttpStatusCode;)V", "bytes", "", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "getText", "()Ljava/lang/String;", "toString", "ktor-http"})
public final class TextContent
extends OutgoingContent.ByteArrayContent {
    @NotNull
    private final String text;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final HttpStatusCode status;
    @NotNull
    private final byte[] bytes;

    /*
     * WARNING - void declaration
     */
    public TextContent(@NotNull String text, @NotNull ContentType contentType2, @Nullable HttpStatusCode status) {
        byte[] byArray;
        void $this$toByteArray$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.text = text;
        this.contentType = contentType2;
        this.status = status;
        String string = this.text;
        Charset charset = ContentTypesKt.charset(this.getContentType());
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        Charset charset$iv = charset;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, (CharSequence)$this$toByteArray$iv, 0, $this$toByteArray$iv.length());
        }
        this.bytes = byArray;
    }

    public /* synthetic */ TextContent(String string, ContentType contentType2, HttpStatusCode httpStatusCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpStatusCode = null;
        }
        this(string, contentType2, httpStatusCode);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return this.bytes.length;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        return "TextContent[" + this.getContentType() + "] \"" + StringsKt.take((String)this.text, (int)30) + '\"';
    }
}

