/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.mamoe.mirai.internal.network.components.ServerAddress;
import net.mamoe.mirai.internal.network.components.ServerList;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.TestOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\rH\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/mamoe/mirai/internal/network/components/ServerListImpl;", "Lnet/mamoe/mirai/internal/network/components/ServerList;", "initial", "", "Lnet/mamoe/mirai/internal/network/components/ServerAddress;", "(Ljava/util/Collection;)V", "()V", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/utils/MiraiLogger;Ljava/util/Collection;)V", "current", "Ljava/util/Queue;", "lastConnectedIP", "", "getLastConnectedIP", "()Ljava/lang/String;", "setLastConnectedIP", "(Ljava/lang/String;)V", "lastDisconnectedIP", "getLastDisconnectedIP", "setLastDisconnectedIP", "lastPolledAddress", "preferred", "", "getLastPolledIP", "getPreferred", "pollAny", "pollCurrent", "refresh", "", "setPreferred", "list", "toString", "mirai-core"})
public final class ServerListImpl
implements ServerList {
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private volatile Set<ServerAddress> preferred;
    @NotNull
    private volatile Queue<ServerAddress> current;
    @Nullable
    private volatile ServerAddress lastPolledAddress;
    @NotNull
    private String lastDisconnectedIP;
    @NotNull
    private String lastConnectedIP;

    public ServerListImpl(@NotNull MiraiLogger logger2, @NotNull Collection<ServerAddress> initial) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this.logger = logger2;
        this.preferred = ServerList.Companion.getDEFAULT_SERVER_LIST();
        this.current = new ArrayDeque<ServerAddress>(initial);
        this.refresh();
        this.lastDisconnectedIP = "";
        this.lastConnectedIP = "";
    }

    public /* synthetic */ ServerListImpl(MiraiLogger miraiLogger, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(miraiLogger, collection);
    }

    @TestOnly
    public ServerListImpl(@NotNull Collection<ServerAddress> initial) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this(MiraiLogger.Factory.INSTANCE.create(Reflection.getOrCreateKotlinClass(ServerListImpl.class)), initial);
    }

    @TestOnly
    public ServerListImpl() {
        this(MiraiLogger.Factory.INSTANCE.create(Reflection.getOrCreateKotlinClass(ServerListImpl.class)), null, 2, null);
    }

    @Override
    public synchronized void setPreferred(@NotNull Collection<ServerAddress> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isInfoEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl = false;
            miraiLogger.info("Server list: " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null) + '.');
        }
        if (!(!list2.isEmpty())) {
            boolean bl = false;
            String string = "list cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        this.preferred = CollectionsKt.toSet((Iterable)list2);
    }

    @Override
    @NotNull
    public Set<ServerAddress> getPreferred() {
        return this.preferred;
    }

    @Override
    public synchronized void refresh() {
        this.current = (Queue)CollectionsKt.toCollection((Iterable)this.preferred, (Collection)new ArrayDeque(this.current.size()));
        if (!(!((Collection)this.current).isEmpty())) {
            boolean bl = false;
            String string = "Internal error: failed to fill server list. No server available.";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public String getLastDisconnectedIP() {
        return this.lastDisconnectedIP;
    }

    @Override
    public void setLastDisconnectedIP(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastDisconnectedIP = string;
    }

    @Override
    @NotNull
    public String getLastConnectedIP() {
        return this.lastConnectedIP;
    }

    @Override
    public void setLastConnectedIP(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastConnectedIP = string;
    }

    @Override
    @NotNull
    public String getLastPolledIP() {
        Object object = this.lastPolledAddress;
        if (object == null || (object = ((ServerAddress)object).getHost()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public synchronized ServerAddress pollCurrent() {
        ServerAddress serverAddress;
        ServerAddress serverAddress2 = this.current.poll();
        if (serverAddress2 != null) {
            ServerAddress serverAddress3;
            ServerAddress address = serverAddress3 = serverAddress2;
            boolean bl = false;
            this.lastPolledAddress = address;
            serverAddress = serverAddress3;
        } else {
            serverAddress = null;
        }
        return serverAddress;
    }

    @Override
    @NotNull
    public synchronized ServerAddress pollAny() {
        ServerAddress serverAddress;
        if (this.current.isEmpty()) {
            this.refresh();
        }
        ServerAddress address = serverAddress = this.current.remove();
        boolean bl = false;
        this.lastPolledAddress = address;
        ServerAddress serverAddress2 = serverAddress;
        Intrinsics.checkNotNullExpressionValue((Object)serverAddress2, (String)"current.remove().also { \u2026dress = address\n        }");
        return serverAddress2;
    }

    @NotNull
    public String toString() {
        return "ServerListImpl(current.size=" + this.current.size() + ')';
    }
}

