/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message.image;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.mamoe.mirai.internal.message.image.ImageInfoKt;
import net.mamoe.mirai.message.data.ImageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lnet/mamoe/mirai/internal/message/image/OnlineImageIds;", "", "()V", "speculateImageType", "Lnet/mamoe/mirai/message/data/ImageType;", "filePath", "", "imageTypeInt", "", "speculateImageTypeFromImageId", "filePathOrImageId", "speculateImageTypeNameFromFilePath", "mirai-core"})
final class OnlineImageIds {
    @NotNull
    public static final OnlineImageIds INSTANCE = new OnlineImageIds();

    private OnlineImageIds() {
    }

    @NotNull
    public final ImageType speculateImageType(@NotNull String filePath, int imageTypeInt) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        ImageType imageType = ImageInfoKt.getImageTypeById(imageTypeInt);
        if (imageType == null && (imageType = this.speculateImageTypeFromImageId(filePath)) == null) {
            imageType = ImageType.UNKNOWN;
        }
        return imageType;
    }

    @Nullable
    public final ImageType speculateImageTypeFromImageId(@NotNull String filePathOrImageId) {
        ImageType imageType;
        Intrinsics.checkNotNullParameter((Object)filePathOrImageId, (String)"filePathOrImageId");
        String string = this.speculateImageTypeNameFromFilePath(filePathOrImageId);
        if (string != null) {
            String it = string;
            boolean bl = false;
            imageType = ImageType.Companion.matchOrNull(it);
        } else {
            imageType = null;
        }
        return imageType;
    }

    @Nullable
    public final String speculateImageTypeNameFromFilePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = StringsKt.substringAfterLast$default((String)filePath, (char)'.', null, (int)2, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String ext = string;
        boolean bl = false;
        return Intrinsics.areEqual((Object)ext, (Object)"null") ? (String)null : ext;
    }
}

