/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message.image;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.message.image.AbstractImageKt;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.ImageType;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"UNKNOWN_IMAGE_TYPE_PROMPT_ENABLED", "", "getUNKNOWN_IMAGE_TYPE_PROMPT_ENABLED", "()Z", "getIdByImageType", "", "imageType", "Lnet/mamoe/mirai/message/data/ImageType;", "getImageType", "", "id", "getImageTypeById", "mirai-core"})
public final class ImageInfoKt {
    private static final boolean UNKNOWN_IMAGE_TYPE_PROMPT_ENABLED = MiraiUtils.systemProp((String)"mirai.unknown.image.type.logging", (boolean)false);

    public static final boolean getUNKNOWN_IMAGE_TYPE_PROMPT_ENABLED() {
        return UNKNOWN_IMAGE_TYPE_PROMPT_ENABLED;
    }

    @Nullable
    public static final ImageType getImageTypeById(int id) {
        return id == 2001 ? ImageType.APNG : ImageType.Companion.matchOrNull(ImageInfoKt.getImageType(id));
    }

    public static final int getIdByImageType(@NotNull ImageType imageType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        switch (WhenMappings.$EnumSwitchMapping$0[imageType.ordinal()]) {
            case 1: {
                n = 1000;
                break;
            }
            case 2: {
                n = 1001;
                break;
            }
            case 3: {
                n = 1005;
                break;
            }
            case 4: {
                n = 2000;
                break;
            }
            case 5: {
                n = 2001;
                break;
            }
            default: {
                n = 1000;
            }
        }
        return n;
    }

    @NotNull
    public static final String getImageType(int id) {
        String string;
        switch (id) {
            case 1000: {
                string = "jpg";
                break;
            }
            case 1001: {
                string = "png";
                break;
            }
            case 1005: {
                string = "bmp";
                break;
            }
            case 3: 
            case 4: 
            case 2000: {
                string = "gif";
                break;
            }
            case 2001: {
                string = "png";
                break;
            }
            default: {
                if (UNKNOWN_IMAGE_TYPE_PROMPT_ENABLED) {
                    AbstractImageKt.getLogger(Image.Key).debug("Unknown image id: " + id + ". Stacktrace:", (Throwable)new Exception());
                }
                string = "mirai";
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.values().length];
            nArray[ImageType.JPG.ordinal()] = 1;
            nArray[ImageType.PNG.ordinal()] = 2;
            nArray[ImageType.BMP.ordinal()] = 3;
            nArray[ImageType.GIF.ordinal()] = 4;
            nArray[ImageType.APNG.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

