/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.mamoe.mirai.internal.utils.crypto.ECDHAndroidKt;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPair;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPairImpl;
import net.mamoe.mirai.internal.utils.crypto.ECDHKt;
import net.mamoe.mirai.utils.ActualsKt;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDH;", "", "keyPair", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "(Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;)V", "getKeyPair", "()Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "calculateShareKeyByPeerPublicKey", "", "peerPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "toString", "", "Companion", "mirai-core"})
public final class ECDH {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ECDHKeyPair keyPair;
    @NotNull
    private static final String curveName = "prime256v1";
    private static final boolean isECDHAvailable;

    public ECDH(@NotNull ECDHKeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.keyPair = keyPair;
    }

    @NotNull
    public final ECDHKeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final byte[] calculateShareKeyByPeerPublicKey(@NotNull PublicKey peerPublicKey) {
        Intrinsics.checkNotNullParameter((Object)peerPublicKey, (String)"peerPublicKey");
        return Companion.calculateShareKey(this.keyPair.getPrivateKey(), peerPublicKey);
    }

    @NotNull
    public String toString() {
        return "ECDH(keyPair=" + this.keyPair + ')';
    }

    private static final void lambda-3$testECDH() {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance("ECDH");
        boolean bl = false;
        it.initialize(new ECGenParameterSpec(curveName));
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(\"ECDH\")\n    \u2026            .genKeyPair()");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        PublicKey publicKey = null;
        KeyPair keyPair2 = keyPair;
        ECDHKeyPairImpl it2 = new ECDHKeyPairImpl(keyPair2, publicKey, n, defaultConstructorMarker);
        boolean bl2 = false;
        Companion.calculateShareKey(it2.getPrivateKey(), it2.getPublicKey());
    }

    static {
        Object object;
        Object object2;
        Companion = new Companion(null);
        try {
            boolean bl = false;
            ECDHAndroidKt.access$getEcKf();
            try {
                boolean bl2 = false;
                ECDH.lambda-3$testECDH();
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (!Result.isSuccess-impl((Object)object2)) {
                ECDH.lambda-3$testECDH();
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = object2 = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        isECDHAvailable = Result.isSuccess-impl((Object)object);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u0012\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\tJ\u0014\u0010\u0012\u001a\u00020\u00132\f\b\u0002\u0010\u0014\u001a\u00060\u000ej\u0002`\u000fJ\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDH$Companion;", "", "()V", "curveName", "", "isECDHAvailable", "", "()Z", "calculateShareKey", "", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "constructPublicKey", "key", "generateKeyPair", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "initialPublicKey", "verifyPublicKey", "version", "", "publicKeySign", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isECDHAvailable() {
            return isECDHAvailable;
        }

        @NotNull
        public final ECDHKeyPair generateKeyPair(@NotNull PublicKey initialPublicKey) {
            KeyPairGenerator keyPairGenerator;
            Intrinsics.checkNotNullParameter((Object)initialPublicKey, (String)"initialPublicKey");
            if (!this.isECDHAvailable()) {
                return ECDHKeyPair.DefaultStub.INSTANCE;
            }
            KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance("ECDH");
            boolean bl = false;
            it.initialize(new ECGenParameterSpec(ECDH.curveName));
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(\"ECDH\")\n    \u2026            .genKeyPair()");
            PublicKey publicKey = initialPublicKey;
            KeyPair keyPair2 = keyPair;
            return new ECDHKeyPairImpl(keyPair2, publicKey);
        }

        public static /* synthetic */ ECDHKeyPair generateKeyPair$default(Companion companion, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = ECDHKt.getDefaultInitialPublicKey().getKey$mirai_core();
            }
            return companion.generateKeyPair(publicKey);
        }

        @NotNull
        public final byte[] calculateShareKey(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            KeyAgreement instance2 = KeyAgreement.getInstance("ECDH", "BC");
            instance2.init(privateKey);
            instance2.doPhase(publicKey, true);
            byte[] byArray = instance2.generateSecret();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"instance.generateSecret()");
            byte[] byArray2 = byArray;
            int n = 16;
            byte[] byArray3 = Arrays.copyOf(byArray2, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
            return MiraiUtils.md5$default((byte[])byArray3, (int)0, (int)0, (int)3, null);
        }

        public final boolean verifyPublicKey(int version, @NotNull String publicKey, @NotNull String publicKeySign) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)publicKeySign, (String)"publicKeySign");
            String string = "305" + version + publicKey;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] arrayForVerify = byArray;
            Signature signInstance = Signature.getInstance("SHA256WithRSA");
            signInstance.initVerify(ECDHKt.getPublicKeyForVerify());
            signInstance.update(arrayForVerify);
            return signInstance.verify(ActualsKt.decodeBase64((String)publicKeySign));
        }

        @NotNull
        public final PublicKey constructPublicKey(@NotNull byte[] key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PublicKey publicKey = ECDHAndroidKt.access$getEcKf().generatePublic(new X509EncodedKeySpec(key));
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"ecKf.generatePublic(X509EncodedKeySpec(key))");
            return publicKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

