/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lnet/mamoe/mirai/internal/utils/FileSystem;", "", "()V", "checkLegitimacy", "", "path", "", "isLegal", "", "normalize", "parent", "name", "mirai-core"})
public final class FileSystem {
    @NotNull
    public static final FileSystem INSTANCE = new FileSystem();

    private FileSystem() {
    }

    public final void checkLegitimacy(@NotNull String path) {
        Character c;
        block2: {
            Character c2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CharSequence $this$firstOrNull$iv = path;
            boolean $i$f$firstOrNull = false;
            CharSequence charSequence = $this$firstOrNull$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)":*?\"<>|", (char)it, (boolean)false, (int)2, null)) continue;
                c2 = Character.valueOf(element$iv);
                break block2;
            }
            c2 = c = null;
        }
        if (c != null) {
            throw new IllegalArgumentException("Chars ':*?\"<>|' are not allowed in path. RemoteFile path contains illegal char: '" + c + "'. path='" + path + '\'');
        }
    }

    public final boolean isLegal(@NotNull String path) {
        Character c;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CharSequence $this$firstOrNull$iv = path;
            boolean $i$f$firstOrNull = false;
            CharSequence charSequence = $this$firstOrNull$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)":*?\"<>|", (char)it, (boolean)false, (int)2, null)) continue;
                c = Character.valueOf(element$iv);
                break block1;
            }
            c = null;
        }
        return c == null;
    }

    @NotNull
    public final String normalize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.checkLegitimacy(path);
        return StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String normalize(@NotNull String parent, @NotNull String name) {
        int slash;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String nName = this.normalize(name);
        if (StringsKt.startsWith$default((CharSequence)nName, (char)'/', (boolean)false, (int)2, null)) {
            return nName;
        }
        nName = StringsKt.removeSuffix((String)nName, (CharSequence)"/");
        String nParent = this.normalize(parent);
        if (Intrinsics.areEqual((Object)nParent, (Object)"/")) {
            return Intrinsics.stringPlus((String)"/", (Object)nName);
        }
        if (!StringsKt.startsWith$default((CharSequence)nParent, (char)'/', (boolean)false, (int)2, null)) {
            nParent = Intrinsics.stringPlus((String)"/", (Object)nParent);
        }
        if ((slash = StringsKt.indexOf$default((CharSequence)nName, (char)'/', (int)0, (boolean)false, (int)6, null)) != -1) {
            char c = '/';
            String string = nName;
            int n = 0;
            String string2 = string.substring(n, slash);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string2;
            nParent = Intrinsics.stringPlus((String)nParent, (Object)(c + string));
            String string3 = nName;
            int n2 = slash + 1;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            nName = string4;
        }
        return nParent + '/' + nName;
    }
}

