/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketExtensionsKt;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.internal.message.ContextualBugReportExceptionKt;
import net.mamoe.mirai.internal.message.FileMessageImpl;
import net.mamoe.mirai.internal.message.ForwardMessageInternal;
import net.mamoe.mirai.internal.message.IncomingMessageSourceInternal;
import net.mamoe.mirai.internal.message.LightAppInternal;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.message.MarketFaceInternal;
import net.mamoe.mirai.internal.message.MessageToElemsKt;
import net.mamoe.mirai.internal.message.OfflineSourceImplKt;
import net.mamoe.mirai.internal.message.OnlineAudioImpl;
import net.mamoe.mirai.internal.message.OnlineFriendImageImpl;
import net.mamoe.mirai.internal.message.OnlineGroupImageImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromFriendImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromGroupImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromStrangerImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromTempImpl;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer;
import net.mamoe.mirai.internal.message.UnsupportedMessageImpl;
import net.mamoe.mirai.internal.network.protocol.data.proto.CustomFace;
import net.mamoe.mirai.internal.network.protocol.data.proto.HummerCommelem;
import net.mamoe.mirai.internal.network.protocol.data.proto.ImMsgBody;
import net.mamoe.mirai.internal.network.protocol.data.proto.MsgComm;
import net.mamoe.mirai.internal.network.protocol.data.proto.ObjMsg;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.AudioCodec;
import net.mamoe.mirai.message.data.CustomMessage;
import net.mamoe.mirai.message.data.Face;
import net.mamoe.mirai.message.data.FlashImage;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageSourceKind;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.PokeMessage;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.ServiceMessage;
import net.mamoe.mirai.message.data.ShowImageFlag;
import net.mamoe.mirai.message.data.SimpleServiceMessage;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.message.data.VipFace;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J0\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015J0\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\n\u00103\u001a\u000204*\u000204J\n\u00105\u001a\u00020\u0011*\u00020\u0015J\n\u00106\u001a\u000207*\u000208R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnet/mamoe/mirai/internal/message/ReceiveMessageTransformer;", "", "()V", "jsonForFileDecode", "Lkotlinx/serialization/json/Json;", "createMessageSource", "Lnet/mamoe/mirai/message/data/MessageSource;", "bot", "Lnet/mamoe/mirai/Bot;", "onlineSource", "", "messageSourceKind", "Lnet/mamoe/mirai/message/data/MessageSourceKind;", "messageList", "", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/MsgComm$Msg;", "decodeCommonElem", "", "commonElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CommonElem;", "list", "Lnet/mamoe/mirai/message/data/MessageChainBuilder;", "decodeCustomElem", "customElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomElem;", "decodeCustomFace", "customFace", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomFace;", "builder", "decodeLightApp", "lightApp", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$LightAppElem;", "decodeRichMessage", "richMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$RichMsg;", "decodeSrcMsg", "srcMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$SourceMsg;", "groupIdOrZero", "", "decodeText", "text", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Text;", "decodeTransElem", "transElement", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$TransElem;", "joinToMessageChain", "elements", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Elem;", "transformElement", "element", "cleanupRubbishMessageElements", "Lnet/mamoe/mirai/message/data/MessageChain;", "compressContinuousPlainText", "toAudio", "Lnet/mamoe/mirai/internal/message/OnlineAudioImpl;", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Ptt;", "mirai-core"})
public final class ReceiveMessageTransformer {
    @NotNull
    public static final ReceiveMessageTransformer INSTANCE = new ReceiveMessageTransformer();
    @NotNull
    private static final Json jsonForFileDecode = JsonKt.Json$default(null, (Function1)jsonForFileDecode.1.INSTANCE, (int)1, null);

    private ReceiveMessageTransformer() {
    }

    @NotNull
    public final MessageSource createMessageSource(@NotNull Bot bot, boolean onlineSource, @NotNull MessageSourceKind messageSourceKind, @NotNull List<MsgComm.Msg> messageList) {
        MessageSource messageSource;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter(messageList, (String)"messageList");
        boolean bl = onlineSource;
        if (bl) {
            IncomingMessageSourceInternal incomingMessageSourceInternal;
            switch (WhenMappings.$EnumSwitchMapping$0[messageSourceKind.ordinal()]) {
                case 1: {
                    incomingMessageSourceInternal = new OnlineMessageSourceFromTempImpl(bot, messageList);
                    break;
                }
                case 2: {
                    incomingMessageSourceInternal = new OnlineMessageSourceFromGroupImpl(bot, messageList);
                    break;
                }
                case 3: {
                    incomingMessageSourceInternal = new OnlineMessageSourceFromFriendImpl(bot, messageList);
                    break;
                }
                case 4: {
                    incomingMessageSourceInternal = new OnlineMessageSourceFromStrangerImpl(bot, messageList);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            messageSource = (MessageSource)incomingMessageSourceInternal;
        } else if (!bl) {
            messageSource = (MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(bot, messageList, messageSourceKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageSource;
    }

    public final void joinToMessageChain(@NotNull List<ImMsgBody.Elem> elements, long groupIdOrZero, @NotNull MessageSourceKind messageSourceKind, @NotNull Bot bot, @NotNull MessageChainBuilder builder) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        for (ImMsgBody.Elem element : elements) {
            this.transformElement(element, groupIdOrZero, messageSourceKind, bot, builder);
            if (element.richMsg == null) continue;
            this.decodeRichMessage(element.richMsg, builder);
        }
    }

    private final void transformElement(ImMsgBody.Elem element, long groupIdOrZero, MessageSourceKind messageSourceKind, Bot bot, MessageChainBuilder builder) {
        if (element.srcMsg != null) {
            this.decodeSrcMsg(element.srcMsg, builder, bot, messageSourceKind, groupIdOrZero);
        } else if (element.notOnlineImage != null) {
            builder.add((SingleMessage)new OnlineFriendImageImpl(element.notOnlineImage));
        } else if (element.customFace != null) {
            this.decodeCustomFace(element.customFace, builder);
        } else if (element.face != null) {
            builder.add((SingleMessage)new Face(element.face.index));
        } else if (element.text != null) {
            this.decodeText(element.text, builder);
        } else if (element.marketFace != null) {
            builder.add((SingleMessage)new MarketFaceInternal(element.marketFace));
        } else if (element.lightApp != null) {
            this.decodeLightApp(element.lightApp, builder);
        } else if (element.customElem != null) {
            this.decodeCustomElem(element.customElem, builder);
        } else if (element.commonElem != null) {
            this.decodeCommonElem(element.commonElem, builder);
        } else if (element.transElemInfo != null) {
            this.decodeTransElem(element.transElemInfo, builder);
        } else if (element.elemFlags2 == null && element.extraInfo == null && element.generalFlags == null && element.anonGroupMsg == null) {
            UnsupportedMessageImpl unsupportedMessageImpl;
            UnsupportedMessageImpl unsupportedMessageImpl2;
            UnsupportedMessageImpl it = unsupportedMessageImpl2 = new UnsupportedMessageImpl(element);
            boolean bl = false;
            UnsupportedMessageImpl unsupportedMessageImpl3 = unsupportedMessageImpl = !(it.getStruct().length == 0) ? unsupportedMessageImpl2 : null;
            if (unsupportedMessageImpl != null) {
                SingleMessage p0 = (SingleMessage)unsupportedMessageImpl;
                boolean bl2 = false;
                builder.add(p0);
            }
        }
    }

    public final void compressContinuousPlainText(@NotNull MessageChainBuilder $this$compressContinuousPlainText) {
        Intrinsics.checkNotNullParameter((Object)$this$compressContinuousPlainText, (String)"<this>");
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index + 1 < $this$compressContinuousPlainText.size()) {
            SingleMessage elm0 = $this$compressContinuousPlainText.get(index);
            SingleMessage elm1 = $this$compressContinuousPlainText.get(index + 1);
            if (elm0 instanceof PlainText && elm1 instanceof PlainText) {
                int i;
                SingleMessage elm;
                builder.setLength(0);
                int end = -1;
                int n = index;
                int n2 = $this$compressContinuousPlainText.size();
                while (n < n2 && (elm = $this$compressContinuousPlainText.get(i = n++)) instanceof PlainText) {
                    end = i;
                    builder.append(((PlainText)elm).getContent());
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                $this$compressContinuousPlainText.set(index, (SingleMessage)new PlainText(string));
                int index1 = index + 1;
                n2 = end - index;
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    int it = n4 = n3++;
                    boolean bl = false;
                    $this$compressContinuousPlainText.remove(index1);
                }
            }
            int n = index;
            index = n + 1;
        }
        CollectionsKt.removeAll((List)((List)$this$compressContinuousPlainText), (Function1)compressContinuousPlainText.2.INSTANCE);
    }

    @NotNull
    public final MessageChain cleanupRubbishMessageElements(@NotNull MessageChain $this$cleanupRubbishMessageElements) {
        int n;
        int n2;
        MessageChainBuilder messageChainBuilder;
        MessageChainBuilder builder;
        block30: {
            int n3;
            List $this$indexOfFirst$iv;
            int index$iv;
            boolean $i$f$indexOfFirst;
            block29: {
                int vipFaceIndex;
                block28: {
                    int n4;
                    boolean bl;
                    SingleMessage it;
                    block27: {
                        int quoteReplyIndex;
                        block26: {
                            int n5;
                            int quoteReplyIndex2;
                            int exceptedQuoteReplyIndex;
                            int index$iv2;
                            block25: {
                                int n6;
                                int n7;
                                block24: {
                                    MessageChainBuilder messageChainBuilder2;
                                    Intrinsics.checkNotNullParameter((Object)$this$cleanupRubbishMessageElements, (String)"<this>");
                                    MessageChainBuilder it2 = messageChainBuilder2 = new MessageChainBuilder(((Collection)$this$cleanupRubbishMessageElements).size());
                                    boolean bl2 = false;
                                    it2.addAll((Collection)$this$cleanupRubbishMessageElements);
                                    builder = messageChainBuilder2;
                                    boolean bl3 = false;
                                    List $this$indexOfFirst$iv2 = (List)builder;
                                    boolean $i$f$indexOfFirst2 = false;
                                    index$iv2 = 0;
                                    for (Object item$iv : $this$indexOfFirst$iv2) {
                                        it = (SingleMessage)item$iv;
                                        boolean bl4 = false;
                                        if (it instanceof MessageSource) {
                                            n7 = index$iv2;
                                            break block24;
                                        }
                                        ++index$iv2;
                                    }
                                    n7 = -1;
                                }
                                exceptedQuoteReplyIndex = n7 + 1;
                                List $this$indexOfFirst$iv3 = (List)builder;
                                boolean $i$f$indexOfFirst3 = false;
                                int index$iv3 = 0;
                                for (Object item$iv : $this$indexOfFirst$iv3) {
                                    SingleMessage it3 = (SingleMessage)item$iv;
                                    boolean bl5 = false;
                                    if (it3 instanceof QuoteReply) {
                                        n6 = index$iv3;
                                        break block25;
                                    }
                                    ++index$iv3;
                                }
                                n6 = quoteReplyIndex2 = -1;
                            }
                            if (quoteReplyIndex2 >= 1 && quoteReplyIndex2 != exceptedQuoteReplyIndex) {
                                SingleMessage qr = builder.get(quoteReplyIndex2);
                                builder.remove(quoteReplyIndex2);
                                builder.add(exceptedQuoteReplyIndex, qr);
                            }
                            boolean bl6 = false;
                            List $this$indexOfFirst$iv4 = (List)builder;
                            boolean $i$f$indexOfFirst4 = false;
                            index$iv2 = 0;
                            for (Object item$iv : $this$indexOfFirst$iv4) {
                                it = (SingleMessage)item$iv;
                                boolean bl7 = false;
                                if (it instanceof QuoteReply) {
                                    n5 = index$iv2;
                                    break block26;
                                }
                                ++index$iv2;
                            }
                            n5 = quoteReplyIndex = -1;
                        }
                        if (quoteReplyIndex >= 0 && quoteReplyIndex < builder.size() - 1) {
                            SingleMessage elm;
                            if (builder.get(quoteReplyIndex + 1) instanceof At) {
                                builder.remove(quoteReplyIndex + 1);
                            }
                            if (quoteReplyIndex < builder.size() - 1 && (elm = builder.get(quoteReplyIndex + 1)) instanceof PlainText && StringsKt.startsWith$default((CharSequence)((PlainText)elm).getContent(), (char)' ', (boolean)false, (int)2, null)) {
                                if (((PlainText)elm).getContent().length() == 1) {
                                    builder.remove(quoteReplyIndex + 1);
                                } else {
                                    String index$iv3 = ((PlainText)elm).getContent().substring(1);
                                    Intrinsics.checkNotNullExpressionValue((Object)index$iv3, (String)"this as java.lang.String).substring(startIndex)");
                                    builder.set(quoteReplyIndex + 1, (SingleMessage)new PlainText(index$iv3));
                                }
                            }
                        }
                        Iterable $this$any$iv = (Iterable)builder;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                SingleMessage it4 = (SingleMessage)element$iv;
                                boolean bl8 = false;
                                if (!(it4 instanceof Audio)) continue;
                                bl = true;
                                break block27;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        builder.remove((Object)MessageToElemsKt.getUNSUPPORTED_VOICE_MESSAGE_PLAIN());
                    }
                    boolean bl9 = false;
                    List $this$indexOfFirst$iv5 = (List)builder;
                    boolean $i$f$indexOfFirst5 = false;
                    int index$iv4 = 0;
                    for (Object item$iv : $this$indexOfFirst$iv5) {
                        it = (SingleMessage)item$iv;
                        boolean bl10 = false;
                        if (it instanceof VipFace) {
                            n4 = index$iv4;
                            break block28;
                        }
                        ++index$iv4;
                    }
                    n4 = vipFaceIndex = -1;
                }
                if (vipFaceIndex >= 0 && vipFaceIndex < builder.size() - 1) {
                    VipFace l = (VipFace)builder.get(vipFaceIndex);
                    SingleMessage text = builder.get(vipFaceIndex + 1);
                    if (text instanceof PlainText && ((PlainText)text).getContent().length() == 4 + l.getCount() / 10 + l.getKind().getName().length()) {
                        builder.remove(vipFaceIndex + 1);
                    }
                }
                List bl9 = (List)builder;
                messageChainBuilder = builder;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    SingleMessage it = (SingleMessage)item$iv;
                    boolean bl = false;
                    if (it instanceof LongMessageInternal) {
                        n3 = index$iv;
                        break block29;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            n2 = n3;
            ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText(messageChainBuilder, n2, MessageToElemsKt.getUNSUPPORTED_MERGED_MESSAGE_PLAIN());
            $this$indexOfFirst$iv = (List)builder;
            messageChainBuilder = builder;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                SingleMessage it = (SingleMessage)item$iv;
                boolean bl = false;
                if (it instanceof PokeMessage) {
                    n = index$iv;
                    break block30;
                }
                ++index$iv;
            }
            n = -1;
        }
        n2 = n;
        ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText(messageChainBuilder, n2, MessageToElemsKt.getUNSUPPORTED_POKE_MESSAGE_PLAIN());
        this.compressContinuousPlainText(builder);
        return builder.asMessageChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeText(ImMsgBody.Text text, MessageChainBuilder list2) {
        if (text.attr6Buf.length == 0) {
            list2.add((SingleMessage)new PlainText(text.str));
        } else {
            void $this$withUse$iv$iv;
            long id = 0L;
            byte[] $this$read$iv = text.attr6Buf;
            boolean $i$f$read = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
            boolean $i$f$withUse = false;
            void var7_9 = $this$withUse$iv$iv;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeText_u24lambda_u2d13 = (ByteReadPacket)var7_9;
                boolean bl = false;
                InputKt.discardExact((Input)((Input)$this$decodeText_u24lambda_u2d13), (int)7);
                Input $this$readUInt$iv = (Input)$this$decodeText_u24lambda_u2d13;
                boolean $i$f$readUInt = false;
                int n = $this$readUInt$iv.readInt();
                id = (long)UInt.constructor-impl((int)n) & 0xFFFFFFFFL;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var7_9, (Throwable)throwable);
            }
            if (id == 0L) {
                list2.add((SingleMessage)AtAll.INSTANCE);
            } else {
                list2.add((SingleMessage)new At(id));
            }
        }
    }

    private final void decodeSrcMsg(ImMsgBody.SourceMsg srcMsg, MessageChainBuilder list2, Bot bot, MessageSourceKind messageSourceKind, long groupIdOrZero) {
        list2.add((SingleMessage)new QuoteReply((MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(srcMsg, bot, messageSourceKind, groupIdOrZero)));
    }

    private final void decodeCustomFace(ImMsgBody.CustomFace customFace, MessageChainBuilder builder) {
        builder.add((SingleMessage)new OnlineGroupImageImpl(customFace));
        byte[] it = customFace.pbReserve;
        boolean bl = false;
        if (!(it.length == 0) && ((CustomFace.ResvAttr)SerializationUtils.loadAs$default((byte[])it, (DeserializationStrategy)((DeserializationStrategy)CustomFace.ResvAttr.Companion.serializer()), (int)0, (int)2, null)).msgImageShow != null) {
            builder.add((SingleMessage)ShowImageFlag.INSTANCE);
        }
    }

    private final void decodeLightApp(ImMsgBody.LightAppElem lightApp, MessageChainBuilder list2) {
        Object object;
        String context$iv = "\u89e3\u6790 lightApp";
        boolean $i$f$runWithBugReport = false;
        try {
            String string;
            boolean bl = false;
            switch (lightApp.data[0]) {
                case 0: {
                    string = StringsKt.decodeToString$default((byte[])lightApp.data, (int)1, (int)0, (boolean)false, (int)6, null);
                    break;
                }
                case 1: {
                    string = StringsKt.decodeToString((byte[])MiraiUtils.unzip$default((byte[])lightApp.data, (int)1, (int)0, (int)2, null));
                    break;
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"unknown compression flag=", (Object)lightApp.data[0]).toString());
                }
            }
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            String string = context$iv;
            boolean bl2 = false;
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string, "resId=" + lightApp.msgResid + "data=" + MiraiUtils.toUHexString$default((byte[])lightApp.data, null, (int)0, (int)0, (int)7, null), it$iv, null, 8, null);
        }
        String content = (String)object;
        list2.add((SingleMessage)new LightAppInternal(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeCustomElem(ImMsgBody.CustomElem customElem, MessageChainBuilder list2) {
        void $this$withUse$iv$iv;
        byte[] $this$read$iv = customElem.data;
        boolean $i$f$read = false;
        Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
        int offset$iv$iv = 0;
        int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
        byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
        boolean $i$f$toReadPacket = false;
        boolean $i$f$ByteReadPacket = false;
        boolean $i$f$ByteReadPacket2 = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
        $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
            final /* synthetic */ byte[] $array;
            {
                this.$array = byArray;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                byte[] it2 = this.$array;
                boolean bl = false;
            }
        }));
        boolean $i$f$withUse = false;
        void var7_8 = $this$withUse$iv$iv;
        Throwable throwable = null;
        try {
            Object object;
            ByteReadPacket $this$decodeCustomElem_u24lambda_u2d20 = (ByteReadPacket)var7_8;
            boolean bl = false;
            try {
                boolean bl2 = false;
                object = Result.constructor-impl((Object)CustomMessage.Companion.load($this$decodeCustomElem_u24lambda_u2d20));
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) {
                CustomMessage it = (CustomMessage)object;
                boolean bl3 = false;
                if (it != null) {
                    list2.add((SingleMessage)it);
                }
            } else {
                Throwable it = throwable3;
                boolean bl4 = false;
                if (it instanceof CustomMessage.Companion.CustomMessageFullDataDeserializeInternalException) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Internal error: exception while deserializing CustomMessage head data, data=", (Object)MiraiUtils.toUHexString$default((byte[])customElem.data, null, (int)0, (int)0, (int)7, null)), it);
                }
                CustomMessage.Companion.CustomMessageFullDataDeserializeUserException cfr_ignored_0 = (CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it;
                throw new IllegalStateException(Intrinsics.stringPlus((String)"User error: exception while deserializing CustomMessage body, body=", (Object)MiraiUtils.toUHexString$default((byte[])((CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it).getBody(), null, (int)0, (int)0, (int)7, null)), it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var7_8, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeTransElem(ImMsgBody.TransElem transElement, MessageChainBuilder list2) {
        if (transElement.elemType == 24) {
            void $this$withUse$iv$iv;
            byte[] $this$read$iv = transElement.elemValue;
            boolean $i$f$read = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
            boolean $i$f$withUse = false;
            void var7_8 = $this$withUse$iv$iv;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeTransElem_u24lambda_u2d21 = (ByteReadPacket)var7_8;
                boolean bl = false;
                byte var7 = $this$decodeTransElem_u24lambda_u2d21.readByte();
                if (var7 == 1) {
                    while ($this$decodeTransElem_u24lambda_u2d21.getRemaining() > 2L) {
                        ObjMsg.MsgContentInfo.MsgFile file;
                        Input $this$readUShort$iv = (Input)$this$decodeTransElem_u24lambda_u2d21;
                        boolean $i$f$readUShort = false;
                        short s = $this$readUShort$iv.readShort();
                        ObjMsg.ObjMsg proto = (ObjMsg.ObjMsg)SerializationUtils.readProtoBuf($this$decodeTransElem_u24lambda_u2d21, (DeserializationStrategy)ObjMsg.ObjMsg.Companion.serializer(), UShort.constructor-impl((short)s) & 0xFFFF);
                        ObjMsg.MsgContentInfo msgContentInfo = (ObjMsg.MsgContentInfo)CollectionsKt.firstOrNull(proto.msgContentInfo);
                        if ((msgContentInfo == null ? null : msgContentInfo.msgFile) == null) continue;
                        file = file;
                        list2.add((SingleMessage)new FileMessageImpl(file.filePath, file.busId, file.fileName, file.fileSize, false, 16, null));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var7_8, (Throwable)throwable);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void decodeCommonElem(ImMsgBody.CommonElem commonElem, MessageChainBuilder list) {
        switch (commonElem.serviceType) {
            case 23: {
                proto = (HummerCommelem.MsgElemInfoServtype23)SerializationUtils.loadAs$default(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype23.Companion.serializer(), 0, 2, null);
                list.add((SingleMessage)new VipFace(new VipFace.Kind(proto.faceType, proto.faceSummary), proto.faceBubbleCount));
                break;
            }
            case 2: {
                proto = (HummerCommelem.MsgElemInfoServtype2)SerializationUtils.loadAs$default(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype2.Companion.serializer(), 0, 2, null);
                var6_8 = var5_7 = proto.vaspokeName;
                var14_9 = list;
                $i$a$-takeIf-ReceiveMessageTransformer$decodeCommonElem$1 = false;
                var15_11 = ((CharSequence)it).length() > 0;
                v0 = var14_9;
                v1 = var4_12 = var15_11 != false ? var5_7 : null;
                if (var4_12 != null) ** GOTO lbl32
                it = PokeMessage.values;
                var14_9 = v0;
                $i$f$firstOrNull = false;
                for (void element$iv : $this$firstOrNull$iv) {
                    it = element$iv;
                    $i$a$-firstOrNull-ReceiveMessageTransformer$decodeCommonElem$2 = false;
                    if (!(it.getId() == proto.vaspokeId && it.getPokeType() == proto.pokeType)) continue;
                    v2 = element$iv;
                    ** GOTO lbl27
                }
                v2 = null;
lbl27:
                // 2 sources

                v0 = var14_9;
                v3 /* !! */  = v2 == null ? null : v2.getName();
                if (v3 /* !! */  == null) {
                    v3 /* !! */  = "";
                }
                ** GOTO lbl33
lbl32:
                // 1 sources

                v3 /* !! */  = var4_12;
lbl33:
                // 2 sources

                var16_19 = proto.vaspokeId;
                var17_20 = proto.pokeType;
                var18_21 = v3 /* !! */ ;
                v0.add((SingleMessage)new PokeMessage(var18_21, var17_20, var16_19));
                break;
            }
            case 3: {
                proto = (HummerCommelem.MsgElemInfoServtype3)SerializationUtils.loadAs$default(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype3.Companion.serializer(), 0, 2, null);
                if (proto.flashTroopPic != null) {
                    list.add((SingleMessage)new FlashImage((Image)new OnlineGroupImageImpl(proto.flashTroopPic)));
                }
                if (proto.flashC2cPic == null) break;
                list.add((SingleMessage)new FlashImage((Image)new OnlineFriendImageImpl(proto.flashC2cPic)));
                break;
            }
            case 33: {
                proto = (HummerCommelem.MsgElemInfoServtype33)SerializationUtils.loadAs$default(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype33.Companion.serializer(), 0, 2, null);
                list.add((SingleMessage)new Face(proto.index));
            }
        }
    }

    private final void decodeRichMessage(ImMsgBody.RichMsg richMsg, MessageChainBuilder builder) {
        int n;
        Object object;
        String context$iv = "\u89e3\u6790 richMsg";
        boolean $i$f$runWithBugReport = false;
        try {
            String string;
            boolean bl = false;
            switch (richMsg.template1[0]) {
                case 0: {
                    string = StringsKt.decodeToString$default((byte[])richMsg.template1, (int)1, (int)0, (boolean)false, (int)6, null);
                    break;
                }
                case 1: {
                    string = StringsKt.decodeToString((byte[])MiraiUtils.unzip$default((byte[])richMsg.template1, (int)1, (int)0, (int)2, null));
                    break;
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"unknown compression flag=", (Object)richMsg.template1[0]).toString());
                }
            }
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            String string = context$iv;
            boolean bl2 = false;
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string, MiraiUtils.toUHexString$default((byte[])richMsg.template1, null, (int)0, (int)0, (int)7, null), it$iv, null, 8, null);
        }
        String content = (String)object;
        int sid = richMsg.serviceId;
        if (sid == 0) {
            String serviceIdStr = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "serviceID");
            if (((CharSequence)serviceIdStr).length() == 0 || StringsKt.isBlank((CharSequence)serviceIdStr)) {
                n = 0;
            } else {
                Integer n2 = StringsKt.toIntOrNull((String)serviceIdStr);
                n = n2 == null ? 0 : n2;
            }
        } else {
            n = sid;
        }
        int serviceId = n;
        switch (serviceId) {
            case 1: {
                builder.add((SingleMessage)new SimpleServiceMessage(1, content));
                break;
            }
            case 35: {
                ServiceMessage serviceMessage;
                String string;
                String resId = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "m_resid");
                String it = string = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "m_fileName");
                boolean bl = false;
                String fileName = ((CharSequence)it).length() > 0 ? string : null;
                if (((CharSequence)resId).length() == 0) {
                    serviceMessage = fileName != null && Intrinsics.areEqual((Object)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "action"), (Object)"viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content, null, fileName, null, 8, null) : (ServiceMessage)new SimpleServiceMessage(35, content);
                } else {
                    Integer n3;
                    Integer n4 = n3 = StringsKt.toIntOrNull((String)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "multiMsgFlag"));
                    int n5 = 1;
                    if (n4 != null && n4 == n5) {
                        serviceMessage = (ServiceMessage)new LongMessageInternal(content, resId);
                    } else {
                        Integer n6 = n3;
                        n5 = 0;
                        serviceMessage = n6 != null && n6 == 0 ? (ServiceMessage)new ForwardMessageInternal(content, resId, fileName, null, 8, null) : (Intrinsics.areEqual((Object)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "action"), (Object)"viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content, resId, fileName, null, 8, null) : (ServiceMessage)new SimpleServiceMessage(35, content));
                    }
                }
                ServiceMessage msg = serviceMessage;
                builder.add((SingleMessage)msg);
                break;
            }
            default: {
                builder.add((SingleMessage)new SimpleServiceMessage(serviceId, content));
            }
        }
    }

    @NotNull
    public final OnlineAudioImpl toAudio(@NotNull ImMsgBody.Ptt $this$toAudio) {
        Intrinsics.checkNotNullParameter((Object)$this$toAudio, (String)"<this>");
        return new OnlineAudioImpl(StringsKt.decodeToString((byte[])$this$toAudio.fileName), $this$toAudio.fileMd5, MiraiUtils.toLongUnsigned((int)$this$toAudio.fileSize), AudioCodec.Companion.fromId($this$toAudio.format), StringsKt.decodeToString((byte[])$this$toAudio.downPara), MiraiUtils.toLongUnsigned((int)$this$toAudio.time), $this$toAudio);
    }

    private static final void cleanupRubbishMessageElements$removeSuffixText(MessageChainBuilder builder, int index, PlainText text) {
        if (index >= 0 && index < builder.size() - 1 && Intrinsics.areEqual((Object)builder.get(index + 1), (Object)text)) {
            builder.remove(index + 1);
        }
    }

    private static final String decodeRichMessage$findStringProperty(String content, String name) {
        return StringsKt.substringBefore((String)StringsKt.substringAfter((String)content, (String)Intrinsics.stringPlus((String)name, (Object)"=\""), (String)""), (String)"\"", (String)"");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageSourceKind.values().length];
            nArray[MessageSourceKind.TEMP.ordinal()] = 1;
            nArray[MessageSourceKind.GROUP.ordinal()] = 2;
            nArray[MessageSourceKind.FRIEND.ordinal()] = 3;
            nArray[MessageSourceKind.STRANGER.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

