/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.frontendbase;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.console.frontendbase.FrontendBase;
import net.mamoe.mirai.console.frontendbase.RepipedMessageForward;
import net.mamoe.mirai.console.frontendbase.logging.AsyncLogRecorderForwarded;
import net.mamoe.mirai.console.frontendbase.logging.DailySplitLogRecorder;
import net.mamoe.mirai.console.frontendbase.logging.LogRecorder;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020\u0013H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\"H\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J.\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010-\u001a\u00020\n2\u0014\b\u0002\u0010.\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\"0/H\u0016J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020'H&J\u0010\u00102\u001a\u00020\"2\u0006\u00101\u001a\u00020'H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\b\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\b\u001a\u0004\b\u001c\u0010\u0006R\u0012\u0010\u001e\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010\u00a8\u00063"}, d2={"Lnet/mamoe/mirai/console/frontendbase/FrontendBase;", "", "()V", "daemonThreadGroup", "Ljava/lang/ThreadGroup;", "getDaemonThreadGroup", "()Ljava/lang/ThreadGroup;", "daemonThreadGroup$delegate", "Lkotlin/Lazy;", "logDropAnsi", "", "getLogDropAnsi", "()Z", "loggingDirectory", "Ljava/nio/file/Path;", "getLoggingDirectory", "()Ljava/nio/file/Path;", "loggingDirectory$delegate", "loggingRecorder", "Lnet/mamoe/mirai/console/frontendbase/logging/LogRecorder;", "getLoggingRecorder", "()Lnet/mamoe/mirai/console/frontendbase/logging/LogRecorder;", "loggingRecorder$delegate", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "threadGroup", "getThreadGroup", "threadGroup$delegate", "workingDirectory", "getWorkingDirectory", "initLogRecorder", "initScreen_forwardStdToMiraiLogger", "", "initScreen_forwardStdToScreen", "newDaemon", "Ljava/lang/Thread;", "name", "", "task", "Ljava/lang/Runnable;", "newThread", "newThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "isDemon", "postSetup", "Lkotlin/Function1;", "printToScreenDirectly", "msg", "recordToLogging", "mirai-console-frontend-base"})
public abstract class FrontendBase {
    @NotNull
    private final Lazy threadGroup$delegate = LazyKt.lazy((Function0)threadGroup.2.INSTANCE);
    @NotNull
    private final Lazy daemonThreadGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ThreadGroup>(this){
        final /* synthetic */ FrontendBase this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final ThreadGroup invoke() {
            return new ThreadGroup(this.this$0.getThreadGroup(), "Mirai Console FrontEnd Daemon Threads");
        }
    }));
    @NotNull
    private final Lazy loggingRecorder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogRecorder>(this){
        final /* synthetic */ FrontendBase this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final LogRecorder invoke() {
            return this.this$0.initLogRecorder();
        }
    }));
    @NotNull
    private final Lazy loggingDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
        final /* synthetic */ FrontendBase this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Path invoke() {
            return this.this$0.getWorkingDirectory().resolve("logs");
        }
    }));

    @NotNull
    public abstract CoroutineScope getScope();

    @NotNull
    public ThreadGroup getThreadGroup() {
        Lazy lazy = this.threadGroup$delegate;
        return (ThreadGroup)lazy.getValue();
    }

    @NotNull
    public ThreadGroup getDaemonThreadGroup() {
        Lazy lazy = this.daemonThreadGroup$delegate;
        return (ThreadGroup)lazy.getValue();
    }

    @NotNull
    public LogRecorder getLoggingRecorder() {
        Lazy lazy = this.loggingRecorder$delegate;
        return (LogRecorder)lazy.getValue();
    }

    @NotNull
    public abstract Path getWorkingDirectory();

    @NotNull
    public Path getLoggingDirectory() {
        Lazy lazy = this.loggingDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-loggingDirectory>(...)");
        return (Path)object;
    }

    public boolean getLogDropAnsi() {
        return true;
    }

    @NotNull
    public Thread newThread(@NotNull String name, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return new Thread(this.getThreadGroup(), task, name);
    }

    @NotNull
    public Thread newDaemon(@NotNull String name, @NotNull Runnable task) {
        Thread thread;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Thread $this$newDaemon_u24lambda_u240 = thread = new Thread(this.getDaemonThreadGroup(), task, name);
        boolean bl = false;
        $this$newDaemon_u24lambda_u240.setDaemon(true);
        return thread;
    }

    @NotNull
    public ThreadFactory newThreadFactory(@NotNull String name, boolean isDemon, @NotNull Function1<? super Thread, Unit> postSetup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(postSetup, (String)"postSetup");
        return new ThreadFactory(isDemon, this, name, postSetup){
            @NotNull
            private final ThreadGroup group;
            @NotNull
            private final AtomicInteger counter;
            final /* synthetic */ boolean $isDemon;
            final /* synthetic */ String $name;
            final /* synthetic */ Function1<Thread, Unit> $postSetup;
            {
                this.$isDemon = $isDemon;
                this.$name = $name;
                this.$postSetup = $postSetup;
                this.group = new ThreadGroup($isDemon ? $receiver.getDaemonThreadGroup() : $receiver.getThreadGroup(), $name);
                this.counter = new AtomicInteger();
            }

            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Thread thread = new Thread(this.group, r, this.$name + '#' + this.counter.getAndIncrement());
                boolean bl = this.$isDemon;
                Thread it = thread;
                boolean bl2 = false;
                it.setDaemon(bl);
                this.$postSetup.invoke((Object)thread);
                return thread;
            }
        };
    }

    public static /* synthetic */ ThreadFactory newThreadFactory$default(FrontendBase frontendBase, String string, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newThreadFactory");
        }
        if ((n & 4) != 0) {
            function1 = newThreadFactory.1.INSTANCE;
        }
        return frontendBase.newThreadFactory(string, bl, (Function1<? super Thread, Unit>)function1);
    }

    public abstract void printToScreenDirectly(@NotNull String var1);

    protected void initScreen_forwardStdToScreen() {
        RepipedMessageForward forwarder2 = new RepipedMessageForward((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ FrontendBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.this$0.printToScreenDirectly(msg);
                this.this$0.recordToLogging(msg);
            }
        }));
        PrintStream printer = new PrintStream(forwarder2.getPipedOutputStream$mirai_console_frontend_base(), true, "UTF-8");
        System.setOut(printer);
    }

    protected void initScreen_forwardStdToMiraiLogger() {
        MiraiLogger logStdout = MiraiLogger.Factory.INSTANCE.create(this.getClass(), "stdout");
        MiraiLogger logStderr = MiraiLogger.Factory.INSTANCE.create(this.getClass(), "stderr");
        RepipedMessageForward forwarderStdout2 = new RepipedMessageForward((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)logStdout){

            public final void invoke(@Nullable String p0) {
                ((MiraiLogger)this.receiver).info(p0);
            }
        }));
        RepipedMessageForward forwarderStderr2 = new RepipedMessageForward((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)logStderr){

            public final void invoke(@Nullable String p0) {
                ((MiraiLogger)this.receiver).warning(p0);
            }
        }));
        System.setOut(new PrintStream(forwarderStdout2.getPipedOutputStream$mirai_console_frontend_base(), true, "UTF-8"));
        System.setErr(new PrintStream(forwarderStderr2.getPipedOutputStream$mirai_console_frontend_base(), true, "UTF-8"));
    }

    public void recordToLogging(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getLoggingRecorder().record(msg);
    }

    @NotNull
    protected LogRecorder initLogRecorder() {
        return new AsyncLogRecorderForwarded(new DailySplitLogRecorder(this.getLoggingDirectory(), this, null, 4, null), this, 0, 4, null);
    }
}

