/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.frontendbase.logging;

import java.io.Writer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.console.frontendbase.FrontendBase;
import net.mamoe.mirai.console.frontendbase.logging.LogRecorder;
import net.mamoe.mirai.console.util.AnsiMessageBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/console/frontendbase/logging/WriterLogRecorder;", "Lnet/mamoe/mirai/console/frontendbase/logging/LogRecorder;", "writer", "Ljava/io/Writer;", "base", "Lnet/mamoe/mirai/console/frontendbase/FrontendBase;", "(Ljava/io/Writer;Lnet/mamoe/mirai/console/frontendbase/FrontendBase;)V", "getBase", "()Lnet/mamoe/mirai/console/frontendbase/FrontendBase;", "getWriter", "()Ljava/io/Writer;", "record", "", "msg", "", "mirai-console-frontend-base"})
public class WriterLogRecorder
extends LogRecorder {
    @NotNull
    private final Writer writer;
    @NotNull
    private final FrontendBase base;

    public WriterLogRecorder(@NotNull Writer writer, @NotNull FrontendBase base) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.writer = writer;
        this.base = base;
    }

    @NotNull
    protected final Writer getWriter() {
        return this.writer;
    }

    @NotNull
    protected final FrontendBase getBase() {
        return this.base;
    }

    @Override
    public void record(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            this.writer.append(this.base.getLogDropAnsi() ? AnsiMessageBuilder.Companion.dropAnsi(msg) : msg).append('\n').flush();
        }
        catch (Throwable e) {
            this.base.printToScreenDirectly(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }
}

