/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.HashFunction;
import io.ktor.util.HashFunctionKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ktor/util/Sha1;", "Lio/ktor/util/HashFunction;", "()V", "h0", "", "h1", "h2", "h3", "h4", "messageLength", "", "unprocessed", "", "unprocessedLimit", "words", "", "digest", "processChunk", "", "input", "pos", "reset", "update", "offset", "length", "ktor-utils"})
public final class Sha1
implements HashFunction {
    private long messageLength;
    @NotNull
    private final byte[] unprocessed = new byte[64];
    private int unprocessedLimit;
    @NotNull
    private final int[] words = new int[80];
    private int h0 = 1732584193;
    private int h1 = -271733879;
    private int h2 = -1732584194;
    private int h3 = 271733878;
    private int h4 = -1009589776;

    @Override
    public void update(@NotNull byte[] input, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.messageLength += (long)length;
        int pos = offset;
        int limit = pos + length;
        byte[] unprocessed = this.unprocessed;
        int unprocessedLimit = this.unprocessedLimit;
        if (unprocessedLimit > 0) {
            if (unprocessedLimit + length < 64) {
                ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)unprocessedLimit, (int)pos, (int)limit);
                this.unprocessedLimit = unprocessedLimit + length;
                return;
            }
            int consumeByteCount = 64 - unprocessedLimit;
            ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)unprocessedLimit, (int)pos, (int)(pos + consumeByteCount));
            this.processChunk(unprocessed, 0);
            this.unprocessedLimit = 0;
            pos += consumeByteCount;
        }
        while (pos < limit) {
            int nextPos = pos + 64;
            if (nextPos > limit) {
                ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)0, (int)pos, (int)limit);
                this.unprocessedLimit = limit - pos;
                return;
            }
            this.processChunk(input, pos);
            pos = nextPos;
        }
    }

    private final void processChunk(byte[] input, int pos) {
        int w;
        int[] words = this.words;
        int currentPosition = pos;
        for (w = 0; w < 16; ++w) {
            words[w] = (input[currentPosition++] & 0xFF) << 24 | (input[currentPosition++] & 0xFF) << 16 | (input[currentPosition++] & 0xFF) << 8 | input[currentPosition++] & 0xFF;
        }
        for (w = 16; w < 80; ++w) {
            words[w] = HashFunctionKt.access$leftRotate(words[w - 3] ^ words[w - 8] ^ words[w - 14] ^ words[w - 16], 1);
        }
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        for (int i = 0; i < 80; ++i) {
            int n;
            int k;
            int f;
            if (i < 20) {
                f = d ^ b & (c ^ d);
                k = 1518500249;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + k + words[i];
            } else if (i < 40) {
                f = b ^ c ^ d;
                k = 1859775393;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + k + words[i];
            } else if (i < 60) {
                f = b & c | b & d | c & d;
                k = -1894007588;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + k + words[i];
            } else {
                f = b ^ c ^ d;
                k = -899497514;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + k + words[i];
            }
            int a2 = n;
            e = d;
            d = c;
            c = HashFunctionKt.access$leftRotate(b, 30);
            b = a;
            a = a2;
        }
        this.h0 += a;
        this.h1 += b;
        this.h2 += c;
        this.h3 += d;
        this.h4 += e;
    }

    @Override
    @NotNull
    public byte[] digest() {
        byte[] unprocessed = this.unprocessed;
        int unprocessedLimit = this.unprocessedLimit;
        long messageLengthBits = this.messageLength * (long)8;
        unprocessed[unprocessedLimit++] = -128;
        if (unprocessedLimit > 56) {
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)unprocessedLimit, (int)64);
            this.processChunk(unprocessed, 0);
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)0, (int)unprocessedLimit);
        } else {
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)unprocessedLimit, (int)56);
        }
        unprocessed[56] = (byte)(messageLengthBits >>> 56);
        unprocessed[57] = (byte)(messageLengthBits >>> 48);
        unprocessed[58] = (byte)(messageLengthBits >>> 40);
        unprocessed[59] = (byte)(messageLengthBits >>> 32);
        unprocessed[60] = (byte)(messageLengthBits >>> 24);
        unprocessed[61] = (byte)(messageLengthBits >>> 16);
        unprocessed[62] = (byte)(messageLengthBits >>> 8);
        unprocessed[63] = (byte)messageLengthBits;
        this.processChunk(unprocessed, 0);
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        this.reset();
        byte[] byArray = new byte[]{(byte)(a >> 24), (byte)(a >> 16), (byte)(a >> 8), (byte)a, (byte)(b >> 24), (byte)(b >> 16), (byte)(b >> 8), (byte)b, (byte)(c >> 24), (byte)(c >> 16), (byte)(c >> 8), (byte)c, (byte)(d >> 24), (byte)(d >> 16), (byte)(d >> 8), (byte)d, (byte)(e >> 24), (byte)(e >> 16), (byte)(e >> 8), (byte)e};
        return byArray;
    }

    private final void reset() {
        this.messageLength = 0L;
        ArraysKt.fill$default((byte[])this.unprocessed, (byte)0, (int)0, (int)0, (int)6, null);
        this.unprocessedLimit = 0;
        ArraysKt.fill$default((int[])this.words, (int)0, (int)0, (int)0, (int)6, null);
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }
}

