/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.application.Application;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationEngineKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.StartupInfo;
import io.ktor.server.engine.internal.ApplicationUtilsKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "pipeline", "Lio/ktor/server/engine/EnginePipeline;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/ktor/server/engine/EnginePipeline;)V", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "resolvedConnectors", "Lkotlinx/coroutines/CompletableDeferred;", "", "Lio/ktor/server/engine/EngineConnectorConfig;", "getResolvedConnectors", "()Lkotlinx/coroutines/CompletableDeferred;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Configuration", "ktor-server-host-common"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EnginePipeline pipeline;
    @NotNull
    private final CompletableDeferred<List<EngineConnectorConfig>> resolvedConnectors;

    public BaseApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        this.environment = environment2;
        this.pipeline = pipeline;
        this.resolvedConnectors = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        final ApplicationEngineEnvironment environment3 = this.environment;
        final StartupInfo info = new StartupInfo();
        final EnginePipeline pipeline2 = this.pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(pipeline2.getSendPipeline());
        environment3.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!info.isFirstLoading()) {
                    info.setInitializedStartAt(ApplicationUtilsKt.currentTimeMillisBridge());
                }
                it.getReceivePipeline().merge(pipeline2.getReceivePipeline());
                it.getSendPipeline().merge(pipeline2.getSendPipeline());
                DefaultTransformKt.installDefaultTransformations(it.getReceivePipeline());
                DefaultTransformKt.installDefaultTransformations(it.getSendPipeline());
                BaseApplicationEngineKt.access$installDefaultInterceptors(it);
                BaseApplicationEngineKt.access$installDefaultTransformationChecker(it);
            }
        });
        environment3.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarted(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                long finishedAt = ApplicationUtilsKt.currentTimeMillisBridge();
                double elapsedTimeInSeconds = (double)(finishedAt - info.getInitializedStartAt()) / 1000.0;
                if (info.isFirstLoading()) {
                    environment3.getLog().info("Application started in " + elapsedTimeInSeconds + " seconds.");
                    info.setFirstLoading(false);
                } else {
                    environment3.getLog().info("Application auto-reloaded in " + elapsedTimeInSeconds + " seconds.");
                }
            }
        });
        CompletableDeferred<List<EngineConnectorConfig>> connectors = this.resolvedConnectors;
        Logger log = environment3.getLog();
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)environment3.getApplication().getCoroutineContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectors, log, null){
            int label;
            final /* synthetic */ CompletableDeferred<List<EngineConnectorConfig>> $connectors;
            final /* synthetic */ Logger $log;
            {
                this.$connectors = $connectors;
                this.$log = $log;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$connectors.await((Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.$log;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (EngineConnectorConfig)element$iv;
                            $i$a$-forEach-BaseApplicationEngine$3$1 = false;
                            v1 = new StringBuilder().append("Responding at ");
                            v2 = it.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                            var3_4.info(v1.append(v2).append("://").append(it.getHost()).append(':').append(it.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEngineEnvironment);
        }
        this(applicationEngineEnvironment, enginePipeline);
    }

    @Override
    @NotNull
    public final ApplicationEngineEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    @NotNull
    protected final CompletableDeferred<List<EngineConnectorConfig>> getResolvedConnectors() {
        return this.resolvedConnectors;
    }

    @Override
    @Nullable
    public Object resolvedConnectors(@NotNull Continuation<? super List<? extends EngineConnectorConfig>> $completion) {
        return this.resolvedConnectors.await($completion);
    }

    @Override
    @NotNull
    public Application getApplication() {
        return ApplicationEngine.DefaultImpls.getApplication(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "()V", "ktor-server-host-common"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

