/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.Headers;
import io.ktor.http.HttpMethod;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Request;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.request.ApplicationRequestKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.utils.io.ByteReadChannel;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010%\u001a\u00020\tH\u0016J\r\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(R\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0007\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0012\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0012\u001a\u0004\b#\u0010 R\u0016\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/ktor/server/cio/CIOApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "call", "Lio/ktor/server/application/ApplicationCall;", "remoteAddress", "Ljava/net/SocketAddress;", "Lio/ktor/util/network/NetworkAddress;", "localAddress", "input", "Lio/ktor/utils/io/ByteReadChannel;", "request", "Lio/ktor/http/cio/Request;", "(Lio/ktor/server/application/ApplicationCall;Ljava/net/SocketAddress;Ljava/net/SocketAddress;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/http/cio/Request;)V", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "cookies$delegate", "Lkotlin/Lazy;", "headers", "Lio/ktor/http/Headers;", "getHeaders$annotations", "()V", "getHeaders", "()Lio/ktor/http/Headers;", "local", "Lio/ktor/http/RequestConnectionPoint;", "getLocal", "()Lio/ktor/http/RequestConnectionPoint;", "queryParameters", "Lio/ktor/http/Parameters;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "queryParameters$delegate", "rawQueryParameters", "getRawQueryParameters", "rawQueryParameters$delegate", "receiveChannel", "release", "", "release$ktor_server_cio", "ktor-server-cio"})
public final class CIOApplicationRequest
extends BaseApplicationRequest {
    @Nullable
    private final SocketAddress remoteAddress;
    @Nullable
    private final SocketAddress localAddress;
    @NotNull
    private final ByteReadChannel input;
    @NotNull
    private final Request request;
    @NotNull
    private final Lazy cookies$delegate;
    @NotNull
    private final Headers headers;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final Lazy rawQueryParameters$delegate;
    @NotNull
    private final RequestConnectionPoint local;

    public CIOApplicationRequest(@NotNull ApplicationCall call, @Nullable SocketAddress remoteAddress, @Nullable SocketAddress localAddress, @NotNull ByteReadChannel input, @NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        super(call);
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.input = input;
        this.request = request2;
        this.cookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RequestCookies>(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RequestCookies invoke() {
                return new RequestCookies(this.this$0);
            }
        }));
        this.headers = new CIOHeaders(this.request.getHeaders());
        this.queryParameters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Parameters>(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Parameters invoke() {
                return ApplicationRequestKt.encodeParameters(this.this$0, this.this$0.getRawQueryParameters());
            }
        }));
        this.rawQueryParameters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Parameters>(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Parameters invoke() {
                String uri2 = ((Object)CIOApplicationRequest.access$getRequest$p(this.this$0).getUri()).toString();
                Integer n = StringsKt.indexOf$default((CharSequence)uri2, (char)'?', (int)0, (boolean)false, (int)6, null);
                int it = ((Number)n).intValue();
                boolean bl = false;
                Integer n2 = it != -1 ? n : null;
                if (n2 == null) {
                    return Parameters.Companion.getEmpty();
                }
                int queryStartIndex = n2;
                return QueryKt.parseQueryString$default(uri2, queryStartIndex + 1, 0, false, 4, null);
            }
        }));
        this.local = new RequestConnectionPoint(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getScheme() {
                return "http";
            }

            @NotNull
            public String getVersion() {
                return ((Object)CIOApplicationRequest.access$getRequest$p(this.this$0).getVersion()).toString();
            }

            @NotNull
            public String getUri() {
                return ((Object)CIOApplicationRequest.access$getRequest$p(this.this$0).getUri()).toString();
            }

            @NotNull
            public String getHost() {
                Object object = CIOApplicationRequest.access$getLocalAddress$p(this.this$0);
                if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
                    CharSequence charSequence = CIOApplicationRequest.access$getRequest$p(this.this$0).getHeaders().get("Host");
                    object = charSequence != null && (charSequence = ((Object)charSequence).toString()) != null ? StringsKt.substringBefore$default((String)charSequence, (String)":", null, (int)2, null) : "localhost";
                }
                return object;
            }

            public int getPort() {
                String string;
                String string2;
                CharSequence charSequence;
                SocketAddress socketAddress = CIOApplicationRequest.access$getLocalAddress$p(this.this$0);
                return socketAddress != null ? NetworkAddressJvmKt.getPort(socketAddress) : ((charSequence = CIOApplicationRequest.access$getRequest$p(this.this$0).getHeaders().get("Host")) != null && (string2 = ((Object)charSequence).toString()) != null && (string = StringsKt.substringAfter((String)string2, (String)":", (String)"80")) != null ? Integer.parseInt(string) : 80);
            }

            @NotNull
            public HttpMethod getMethod() {
                return HttpMethod.Companion.parse(CIOApplicationRequest.access$getRequest$p(this.this$0).getMethod().getValue());
            }

            @NotNull
            public String getRemoteHost() {
                Object object = CIOApplicationRequest.access$getRemoteAddress$p(this.this$0);
                if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
                    object = "unknown";
                }
                return object;
            }
        };
    }

    @Override
    @NotNull
    public RequestCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (RequestCookies)lazy.getValue();
    }

    @Override
    @NotNull
    public ByteReadChannel receiveChannel() {
        return this.input;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    public static /* synthetic */ void getHeaders$annotations() {
    }

    @Override
    @NotNull
    public Parameters getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @Override
    @NotNull
    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @Override
    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    public final void release$ktor_server_cio() {
        this.request.release();
    }

    public static final /* synthetic */ Request access$getRequest$p(CIOApplicationRequest $this) {
        return $this.request;
    }

    public static final /* synthetic */ SocketAddress access$getLocalAddress$p(CIOApplicationRequest $this) {
        return $this.localAddress;
    }

    public static final /* synthetic */ SocketAddress access$getRemoteAddress$p(CIOApplicationRequest $this) {
        return $this.remoteAddress;
    }
}

