/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.Parameters;
import io.ktor.http.URLProtocol;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b,\u0018\u0000 ;2\u00020\u0001:\u0001;Ba\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u0013\u00107\u001a\u00020\u00102\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00109\u001a\u00020\u0007H\u0016J\b\u0010:\u001a\u00020\u0005H\u0016R\u001b\u0010\u0013\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015R\u001b\u0010\u001b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001c\u0010\u0015R\u001b\u0010\u001e\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0017\u001a\u0004\b\u001f\u0010\u0015R\u001b\u0010!\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0017\u001a\u0004\b\"\u0010\u0015R\u001d\u0010$\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0017\u001a\u0004\b%\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00100R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0015\u00a8\u0006<"}, d2={"Lio/ktor/http/Url;", "", "protocol", "Lio/ktor/http/URLProtocol;", "host", "", "specifiedPort", "", "pathSegments", "", "parameters", "Lio/ktor/http/Parameters;", "fragment", "user", "password", "trailingQuery", "", "urlString", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "encodedFragment", "getEncodedFragment", "()Ljava/lang/String;", "encodedFragment$delegate", "Lkotlin/Lazy;", "encodedPassword", "getEncodedPassword", "encodedPassword$delegate", "encodedPath", "getEncodedPath", "encodedPath$delegate", "encodedPathAndQuery", "getEncodedPathAndQuery", "encodedPathAndQuery$delegate", "encodedQuery", "getEncodedQuery", "encodedQuery$delegate", "encodedUser", "getEncodedUser", "encodedUser$delegate", "getFragment", "getHost", "getParameters", "()Lio/ktor/http/Parameters;", "getPassword", "getPathSegments", "()Ljava/util/List;", "port", "getPort", "()I", "getProtocol", "()Lio/ktor/http/URLProtocol;", "getSpecifiedPort", "getTrailingQuery", "()Z", "getUser", "equals", "other", "hashCode", "toString", "Companion", "ktor-http"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URLProtocol protocol;
    @NotNull
    private final String host;
    private final int specifiedPort;
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String fragment;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final boolean trailingQuery;
    @NotNull
    private final String urlString;
    @NotNull
    private final Lazy encodedPath$delegate;
    @NotNull
    private final Lazy encodedQuery$delegate;
    @NotNull
    private final Lazy encodedPathAndQuery$delegate;
    @NotNull
    private final Lazy encodedUser$delegate;
    @NotNull
    private final Lazy encodedPassword$delegate;
    @NotNull
    private final Lazy encodedFragment$delegate;

    public Url(@NotNull URLProtocol protocol, @NotNull String host2, int specifiedPort, @NotNull List<String> pathSegments, @NotNull Parameters parameters2, @NotNull String fragment, @Nullable String user, @Nullable String password, boolean trailingQuery, @NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        this.protocol = protocol;
        this.host = host2;
        this.specifiedPort = specifiedPort;
        this.pathSegments = pathSegments;
        this.parameters = parameters2;
        this.fragment = fragment;
        this.user = user;
        this.password = password;
        this.trailingQuery = trailingQuery;
        this.urlString = urlString;
        int n = this.specifiedPort;
        if (!((0 <= n ? n < 65536 : false) || this.specifiedPort == 0)) {
            boolean bl = false;
            String string = "port must be between 0 and 65535, or 0 if not set";
            throw new IllegalArgumentException(string.toString());
        }
        this.encodedPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                if (this.this$0.getPathSegments().isEmpty()) {
                    return "";
                }
                int pathStartIndex = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'/', (int)(this.this$0.getProtocol().getName().length() + 3), (boolean)false, (int)4, null);
                if (pathStartIndex == -1) {
                    return "";
                }
                char[] cArray = new char[]{'?', '#'};
                int pathEndIndex = StringsKt.indexOfAny$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char[])cArray, (int)pathStartIndex, (boolean)false, (int)4, null);
                if (pathEndIndex == -1) {
                    String string = Url.access$getUrlString$p(this.this$0).substring(pathStartIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    return string;
                }
                String string = Url.access$getUrlString$p(this.this$0).substring(pathStartIndex, pathEndIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
        }));
        this.encodedQuery$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                int queryStart = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
                if (queryStart == 0) {
                    return "";
                }
                int queryEnd = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'#', (int)queryStart, (boolean)false, (int)4, null);
                if (queryEnd == -1) {
                    String string = Url.access$getUrlString$p(this.this$0).substring(queryStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    return string;
                }
                String string = Url.access$getUrlString$p(this.this$0).substring(queryStart, queryEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
        }));
        this.encodedPathAndQuery$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                int pathStart = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'/', (int)(this.this$0.getProtocol().getName().length() + 3), (boolean)false, (int)4, null);
                if (pathStart == -1) {
                    return "";
                }
                int queryEnd = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'#', (int)pathStart, (boolean)false, (int)4, null);
                if (queryEnd == -1) {
                    String string = Url.access$getUrlString$p(this.this$0).substring(pathStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    return string;
                }
                String string = Url.access$getUrlString$p(this.this$0).substring(pathStart, queryEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
        }));
        this.encodedUser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                if (this.this$0.getUser() == null) {
                    return null;
                }
                if (((CharSequence)this.this$0.getUser()).length() == 0) {
                    return "";
                }
                int usernameStart = this.this$0.getProtocol().getName().length() + 3;
                char[] cArray = new char[]{':', '@'};
                int usernameEnd = StringsKt.indexOfAny$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char[])cArray, (int)usernameStart, (boolean)false, (int)4, null);
                String string = Url.access$getUrlString$p(this.this$0).substring(usernameStart, usernameEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
        }));
        this.encodedPassword$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                if (this.this$0.getPassword() == null) {
                    return null;
                }
                if (((CharSequence)this.this$0.getPassword()).length() == 0) {
                    return "";
                }
                int passwordStart = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)':', (int)(this.this$0.getProtocol().getName().length() + 3), (boolean)false, (int)4, null) + 1;
                int passwordEnd = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'@', (int)0, (boolean)false, (int)6, null);
                String string = Url.access$getUrlString$p(this.this$0).substring(passwordStart, passwordEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
        }));
        this.encodedFragment$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Url this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                int fragmentStart = StringsKt.indexOf$default((CharSequence)Url.access$getUrlString$p(this.this$0), (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
                if (fragmentStart == 0) {
                    return "";
                }
                String string = Url.access$getUrlString$p(this.this$0).substring(fragmentStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                return string;
            }
        }));
    }

    @NotNull
    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    @NotNull
    public final List<String> getPathSegments() {
        return this.pathSegments;
    }

    @NotNull
    public final Parameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    public final int getPort() {
        Integer n = this.specifiedPort;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        return n2 != null ? n2.intValue() : this.protocol.getDefaultPort();
    }

    @NotNull
    public final String getEncodedPath() {
        Lazy lazy = this.encodedPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedQuery() {
        Lazy lazy = this.encodedQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedPathAndQuery() {
        Lazy lazy = this.encodedPathAndQuery$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedUser() {
        Lazy lazy = this.encodedUser$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedPassword() {
        Lazy lazy = this.encodedPassword$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedFragment() {
        Lazy lazy = this.encodedFragment$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.urlString;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        Url cfr_ignored_0 = (Url)other;
        return Intrinsics.areEqual((Object)this.urlString, (Object)((Url)other).urlString);
    }

    public int hashCode() {
        return this.urlString.hashCode();
    }

    public static final /* synthetic */ String access$getUrlString$p(Url $this) {
        return $this.urlString;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/http/Url$Companion;", "", "()V", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

