/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.api.http.context.session.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.api.http.context.MahContext;
import net.mamoe.mirai.api.http.context.session.ListenableSessionWrapper;
import net.mamoe.mirai.api.http.context.session.Session;
import net.mamoe.mirai.api.http.context.session.StandardSession;
import net.mamoe.mirai.api.http.context.session.manager.SessionManager;
import net.mamoe.mirai.api.http.context.session.manager.UtilKt;
import net.mamoe.mirai.api.http.setting.MainSetting;
import net.mamoe.mirai.api.http.spi.persistence.Persistence;
import net.mamoe.mirai.api.http.spi.persistence.PersistenceFactory;
import net.mamoe.mirai.api.http.spi.persistence.PersistenceManager;
import net.mamoe.mirai.event.events.BotEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010'\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0013\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010*\u001a\u00020\bH\u0016J\u0019\u0010+\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\bH\u0096\u0002R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lnet/mamoe/mirai/api/http/context/session/manager/DefaultSessionManager;", "Lnet/mamoe/mirai/api/http/context/session/manager/SessionManager;", "verifyKey", "", "context", "Lnet/mamoe/mirai/api/http/context/MahContext;", "(Ljava/lang/String;Lnet/mamoe/mirai/api/http/context/MahContext;)V", "_emptySession", "Lnet/mamoe/mirai/api/http/context/session/Session;", "get_emptySession", "()Lnet/mamoe/mirai/api/http/context/session/Session;", "_emptySession$delegate", "Lkotlin/Lazy;", "cacheMap", "", "", "Lnet/mamoe/mirai/api/http/spi/persistence/Persistence;", "getContext", "()Lnet/mamoe/mirai/api/http/context/MahContext;", "persistenceFactory", "Lnet/mamoe/mirai/api/http/spi/persistence/PersistenceFactory;", "persistenceFactoryName", "persistenceManager", "Lnet/mamoe/mirai/api/http/spi/persistence/PersistenceManager;", "sessionMap", "getVerifyKey", "()Ljava/lang/String;", "authSession", "bot", "Lnet/mamoe/mirai/Bot;", "tempSessionKey", "authedSessions", "", "close", "", "closeSession", "key", "createOneTimeSession", "Lnet/mamoe/mirai/api/http/context/session/StandardSession;", "createTempSession", "get", "getCache", "getEmptySession", "set", "session", "mirai-api-http"})
public final class DefaultSessionManager
implements SessionManager {
    @NotNull
    private final String verifyKey;
    @NotNull
    private final MahContext context;
    @NotNull
    private final String persistenceFactoryName;
    @NotNull
    private final PersistenceManager persistenceManager;
    @NotNull
    private final PersistenceFactory persistenceFactory;
    @NotNull
    private final Map<String, Session> sessionMap;
    @NotNull
    private final Map<Long, Persistence> cacheMap;
    @NotNull
    private final Lazy _emptySession$delegate;

    public DefaultSessionManager(@NotNull String verifyKey, @NotNull MahContext context) {
        Intrinsics.checkNotNullParameter((Object)verifyKey, (String)"verifyKey");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.verifyKey = verifyKey;
        this.context = context;
        this.persistenceFactoryName = MainSetting.INSTANCE.getPersistenceFactory();
        this.persistenceManager = new PersistenceManager(this.persistenceFactoryName);
        this.persistenceFactory = this.persistenceManager.loadFactory();
        this.sessionMap = new LinkedHashMap();
        this.cacheMap = new LinkedHashMap();
        this._emptySession$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StandardSession>(this){
            final /* synthetic */ DefaultSessionManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final StandardSession invoke() {
                return new StandardSession("empty", (SessionManager)this.this$0);
            }
        }));
    }

    @NotNull
    public String getVerifyKey() {
        return this.verifyKey;
    }

    @NotNull
    public final MahContext getContext() {
        return this.context;
    }

    private final Session get_emptySession() {
        Lazy lazy = this._emptySession$delegate;
        return (Session)lazy.getValue();
    }

    @NotNull
    public Session getEmptySession() {
        return this.get_emptySession();
    }

    @NotNull
    public StandardSession createOneTimeSession(@NotNull Bot bot) {
        StandardSession standardSession;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        StandardSession oneTimeSession = standardSession = new StandardSession("", (SessionManager)this);
        boolean bl = false;
        oneTimeSession.authWith(bot, this.getCache(bot));
        return standardSession;
    }

    @NotNull
    public Session createTempSession() {
        return this.createTempSession(UtilKt.generateSessionKey(this));
    }

    @NotNull
    public Session createTempSession(@NotNull String key) {
        StandardSession standardSession;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StandardSession newTempSession = standardSession = new StandardSession(key, (SessionManager)this);
        boolean bl = false;
        ListenableSessionWrapper proxy = new ListenableSessionWrapper((Session)newTempSession);
        ListenableSessionWrapper.startExpiredCountdown$default((ListenableSessionWrapper)proxy, (long)180000L, null, (int)2, null);
        this.sessionMap.put(newTempSession.getKey(), (Session)proxy);
        return (Session)standardSession;
    }

    @NotNull
    public Session authSession(@NotNull Bot bot, @NotNull String tempSessionKey) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)tempSessionKey, (String)"tempSessionKey");
        Session session = this.get(tempSessionKey);
        if (session == null) {
            throw new NoSuchElementException();
        }
        Session session2 = session;
        if (session2.isAuthed()) {
            return session2;
        }
        session2.ref();
        session2.putExtElement(ListenableSessionWrapper.Key.getBotEventHandler(), (Object)new Function2<Session, BotEvent, Unit>((Object)this.context){

            public final void invoke(@NotNull Session p0, @NotNull BotEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((MahContext)this.receiver).handleBotEvent(p0, p1);
            }
        });
        session2.authWith(bot, this.getCache(bot));
        return session2;
    }

    @Nullable
    public Session get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sessionMap.get(key);
    }

    public void set(@NotNull String key, @NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionMap.put(key, session);
    }

    public void closeSession(@NotNull String key) {
        block1: {
            Session session;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Session session2 = this.sessionMap.get(key);
            if (session2 == null) break block1;
            Session $this$closeSession_u24lambda_u2d2 = session = session2;
            boolean bl = false;
            $this$closeSession_u24lambda_u2d2.close();
            if ($this$closeSession_u24lambda_u2d2.getRefCount() <= 0) {
                this.sessionMap.remove(key);
            }
        }
    }

    public void close() {
        Map<String, Session> $this$forEach$iv = this.sessionMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Session>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Session> element$iv;
            Map.Entry<String, Session> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            this.closeSession(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Session> authedSessions() {
        void $this$mapTo$iv$iv;
        Map<String, Session> $this$filterValues$iv = this.sessionMap;
        boolean $i$f$filterValues = false;
        Map<String, Session> result$iv = new LinkedHashMap();
        for (Map.Entry<String, Session> entry$iv : $this$filterValues$iv.entrySet()) {
            Session it = entry$iv.getValue();
            boolean bl = false;
            if (!it.isAuthed()) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Session)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Persistence getCache(@NotNull Bot bot) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Persistence persistence = this.cacheMap.computeIfAbsent(bot.getId(), arg_0 -> DefaultSessionManager.getCache$lambda-6(this, bot, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)persistence, (String)"cacheMap.computeIfAbsent\u2026Factory.getService(bot) }");
        return persistence;
    }

    private static final Persistence getCache$lambda-6(DefaultSessionManager this$0, Bot $bot, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bot, (String)"$bot");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.persistenceFactory.getService($bot);
    }
}

