/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okio.BufferedSink;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lokhttp3/internal/http/CallServerInterceptor;", "Lokhttp3/Interceptor;", "forWebSocket", "", "(Z)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "okhttp"})
public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response2;
        int code;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Exchange exchange = realChain.getExchange$okhttp();
        Intrinsics.checkNotNull((Object)exchange);
        Exchange exchange2 = exchange;
        Request request2 = realChain.getRequest$okhttp();
        RequestBody requestBody = request2.body();
        long sentRequestMillis = System.currentTimeMillis();
        exchange2.writeRequestHeaders(request2);
        boolean invokeStartEvent = true;
        Response.Builder responseBuilder = null;
        if (HttpMethod.permitsRequestBody(request2.method()) && requestBody != null) {
            if (StringsKt.equals((String)"100-continue", (String)request2.header("Expect"), (boolean)true)) {
                exchange2.flushRequest();
                responseBuilder = exchange2.readResponseHeaders(true);
                exchange2.responseHeadersStart();
                invokeStartEvent = false;
            }
            if (responseBuilder == null) {
                BufferedSink bufferedRequestBody;
                if (requestBody.isDuplex()) {
                    exchange2.flushRequest();
                    bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request2, true));
                    requestBody.writeTo(bufferedRequestBody);
                } else {
                    bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request2, false));
                    requestBody.writeTo(bufferedRequestBody);
                    bufferedRequestBody.close();
                }
            } else {
                exchange2.noRequestBody();
                if (!exchange2.getConnection$okhttp().isMultiplexed$okhttp()) {
                    exchange2.noNewExchangesOnConnection();
                }
            }
        } else {
            exchange2.noRequestBody();
        }
        if (requestBody == null || !requestBody.isDuplex()) {
            exchange2.finishRequest();
        }
        if (responseBuilder == null) {
            Response.Builder builder = exchange2.readResponseHeaders(false);
            Intrinsics.checkNotNull((Object)builder);
            responseBuilder = builder;
            if (invokeStartEvent) {
                exchange2.responseHeadersStart();
                invokeStartEvent = false;
            }
        }
        if ((code = (response2 = responseBuilder.request(request2).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build()).code()) == 100) {
            Response.Builder builder = exchange2.readResponseHeaders(false);
            Intrinsics.checkNotNull((Object)builder);
            responseBuilder = builder;
            if (invokeStartEvent) {
                exchange2.responseHeadersStart();
            }
            response2 = responseBuilder.request(request2).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
            code = response2.code();
        }
        exchange2.responseHeadersEnd(response2);
        Response response3 = response2 = this.forWebSocket && code == 101 ? response2.newBuilder().body(Util.EMPTY_RESPONSE).build() : response2.newBuilder().body(exchange2.openResponseBody(response2)).build();
        if (StringsKt.equals((String)"close", (String)response2.request().header("Connection"), (boolean)true) || StringsKt.equals((String)"close", (String)Response.header$default(response2, "Connection", null, 2, null), (boolean)true)) {
            exchange2.noNewExchangesOnConnection();
        }
        if (code == 204 || code == 205) {
            ResponseBody responseBody = response2.body();
            if ((responseBody != null ? responseBody.contentLength() : -1L) > 0L) {
                ResponseBody responseBody2 = response2.body();
                throw (Throwable)new ProtocolException("HTTP " + code + " had non-zero Content-Length: " + (responseBody2 != null ? Long.valueOf(responseBody2.contentLength()) : null));
            }
        }
        return response2;
    }

    public CallServerInterceptor(boolean forWebSocket) {
        this.forWebSocket = forWebSocket;
    }
}

