/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.Hash;
import io.ktor.util.InternalAPI;
import io.ktor.util.Lock;
import io.ktor.util.collections.ConcurrentMap;
import io.ktor.utils.io.NativeUtilsJvmKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u001f\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0016\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lio/ktor/util/collections/ConcurrentSet;", "Key", "", "", "lock", "Lio/ktor/util/Lock;", "delegate", "Lio/ktor/util/collections/ConcurrentMap;", "", "(Lio/ktor/util/Lock;Lio/ktor/util/collections/ConcurrentMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "contains", "containsAll", "equals", "other", "hashCode", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "toString", "", "ktor-utils"})
public final class ConcurrentSet<Key>
implements Set<Key>,
KMutableSet {
    @NotNull
    private final Lock lock;
    @NotNull
    private final ConcurrentMap<Key, Unit> delegate;

    public ConcurrentSet(@NotNull Lock lock, @NotNull ConcurrentMap<Key, Unit> delegate2) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter(delegate2, (String)"delegate");
        this.lock = lock;
        this.delegate = delegate2;
        NativeUtilsJvmKt.makeShared(this);
    }

    public /* synthetic */ ConcurrentSet(Lock lock, ConcurrentMap concurrentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lock = new Lock();
        }
        if ((n & 2) != 0) {
            concurrentMap = new ConcurrentMap(lock, 0, 2, null);
        }
        this(lock, concurrentMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NotNull Key element2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Lock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        try {
            $this$withLock$iv.lock();
            boolean bl2 = false;
            boolean result2 = !((Map)this.delegate).containsKey(element2);
            Map map2 = this.delegate;
            Unit unit = Unit.INSTANCE;
            map2.put(element2, unit);
            bl = result2;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Key> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean result2 = false;
        for (Key item : elements) {
            result2 = this.add(item) || result2;
        }
        return result2;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Iterator<Key> iterator() {
        return new Iterator<Key>(this){
            @NotNull
            private final Iterator<Map.Entry<Key, Unit>> iterator;
            final /* synthetic */ ConcurrentSet<Key> this$0;
            {
                this.this$0 = $receiver;
                this.iterator = ConcurrentSet.access$getDelegate$p(this.this$0).iterator$ktor_utils();
            }

            @NotNull
            public final Iterator<Map.Entry<Key, Unit>> getIterator() {
                return this.iterator;
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @NotNull
            public Key next() {
                return this.iterator.next().getKey();
            }

            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public boolean remove(@Nullable Object element2) {
        if (element2 == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.delegate.remove(element2), (Object)Unit.INSTANCE);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.remove(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean modified = false;
        Iterator<Key> $this$retainAll_u24lambda_u2d2 = this.iterator();
        boolean bl = false;
        while ($this$retainAll_u24lambda_u2d2.hasNext()) {
            if (elements.contains($this$retainAll_u24lambda_u2d2.next())) continue;
            $this$retainAll_u24lambda_u2d2.remove();
            modified = true;
        }
        return modified;
    }

    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public boolean contains(@Nullable Object element2) {
        if (element2 == null) {
            return false;
        }
        return this.delegate.containsKey(element2);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (((Map)this.delegate).containsKey(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        Lock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        try {
            StringBuilder stringBuilder;
            $this$withLock$iv.lock();
            boolean bl = false;
            StringBuilder $this$toString_u24lambda_u2d6_u24lambda_u2d5 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$toString_u24lambda_u2d6_u24lambda_u2d5.append("[");
            Iterable $this$forEachIndexed$iv = this;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void item;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean bl3 = false;
                $this$toString_u24lambda_u2d6_u24lambda_u2d5.append(String.valueOf(item));
                if (index == this.size() - 1) continue;
                $this$toString_u24lambda_u2d6_u24lambda_u2d5.append(", ");
            }
            $this$toString_u24lambda_u2d6_u24lambda_u2d5.append("]");
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            string = string2;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        Lock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        try {
            boolean bl2;
            block6: {
                $this$withLock$iv.lock();
                boolean bl3 = false;
                if (other == null || !(other instanceof Set) || ((Set)other).size() != this.size()) {
                    bl2 = false;
                } else {
                    for (Key item : this) {
                        if (((Set)other).contains(item)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            bl = bl2;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int n;
        Lock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        try {
            $this$withLock$iv.lock();
            boolean bl = false;
            int result2 = 0;
            result2 = 7;
            Iterable $this$forEach$iv = this;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl2 = false;
                Object[] objectArray = new Object[]{it.hashCode(), result2};
                result2 = Hash.INSTANCE.combine(objectArray);
            }
            n = result2;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return n;
    }

    public ConcurrentSet() {
        this(null, null, 3, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

