/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CollectionsJvmKt;
import io.ktor.util.CollectionsKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010 \n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0006\u0010\u001d\u001a\u00020\u0014J\u0011\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000fH\u0086\u0002J\u0016\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0#0\"0!J\u0013\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0086\u0002J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010#2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u0003J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0!J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\u0016\u0010(\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010)\u001a\u00020\u0014J\u0019\u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0086\u0002J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0014J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0014R\u001a\u0010\u0007\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lio/ktor/util/StringValuesBuilder;", "", "caseInsensitiveName", "", "size", "", "(ZI)V", "built", "getBuilt", "()Z", "setBuilt", "(Z)V", "getCaseInsensitiveName", "values", "", "", "", "getValues", "()Ljava/util/Map;", "append", "", "name", "value", "appendAll", "stringValues", "Lio/ktor/util/StringValues;", "", "appendMissing", "build", "clear", "contains", "ensureListForKey", "entries", "", "", "", "get", "getAll", "isEmpty", "names", "remove", "removeKeysWithNoEntries", "set", "validateName", "validateValue", "ktor-utils"})
public class StringValuesBuilder {
    private final boolean caseInsensitiveName;
    @NotNull
    private final Map<String, List<String>> values;
    private boolean built;

    public StringValuesBuilder(boolean caseInsensitiveName, int size2) {
        this.caseInsensitiveName = caseInsensitiveName;
        this.values = this.caseInsensitiveName ? CollectionsKt.caseInsensitiveMap() : (Map)new LinkedHashMap(size2);
    }

    public /* synthetic */ StringValuesBuilder(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        this(bl, n);
    }

    public final boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @NotNull
    protected final Map<String, List<String>> getValues() {
        return this.values;
    }

    protected final boolean getBuilt() {
        return this.built;
    }

    protected final void setBuilt(boolean bl) {
        this.built = bl;
    }

    @Nullable
    public final List<String> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.get(name);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.containsKey(name);
    }

    public final boolean contains(@NotNull String name, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<String> list2 = this.values.get(name);
        return list2 == null ? false : (bl = list2.contains(value));
    }

    @NotNull
    public final Set<String> names() {
        return this.values.keySet();
    }

    public final boolean isEmpty() {
        return this.values.isEmpty();
    }

    @NotNull
    public final Set<Map.Entry<String, List<String>>> entries() {
        return CollectionsJvmKt.unmodifiable(this.values.entrySet());
    }

    public final void set(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.validateValue(value);
        List<String> list2 = this.ensureListForKey(name, 1);
        list2.clear();
        list2.add(value);
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<String> list2 = this.getAll(name);
        return list2 == null ? null : (String)kotlin.collections.CollectionsKt.firstOrNull(list2);
    }

    public final void append(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.validateValue(value);
        this.ensureListForKey(name, 1).add(value);
    }

    public final void appendAll(@NotNull StringValues stringValues) {
        Intrinsics.checkNotNullParameter((Object)stringValues, (String)"stringValues");
        stringValues.forEach((Function2<? super String, ? super List<String>, Unit>)((Function2)new Function2<String, List<? extends String>, Unit>(this){
            final /* synthetic */ StringValuesBuilder this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<String> values2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(values2, (String)"values");
                this.this$0.appendAll(name, (Iterable<String>)values2);
            }
        }));
    }

    public final void appendMissing(@NotNull StringValues stringValues) {
        Intrinsics.checkNotNullParameter((Object)stringValues, (String)"stringValues");
        stringValues.forEach((Function2<? super String, ? super List<String>, Unit>)((Function2)new Function2<String, List<? extends String>, Unit>(this){
            final /* synthetic */ StringValuesBuilder this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<String> values2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(values2, (String)"values");
                this.this$0.appendMissing(name, (Iterable<String>)values2);
            }
        }));
    }

    public final void appendAll(@NotNull String name, @NotNull Iterable<String> values2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Collection collection = values2 instanceof Collection ? (Collection)values2 : null;
        List<String> list2 = this.ensureListForKey(name, collection == null ? 2 : (n = collection.size()));
        boolean bl = false;
        Iterable<String> $this$forEach$iv = values2;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String value = element$iv = iterator2.next();
            boolean bl2 = false;
            this.validateValue(value);
            list2.add(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendMissing(@NotNull String name, @NotNull Iterable<String> values2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        List<String> list2 = this.values.get(name);
        Set set = list2 == null ? null : kotlin.collections.CollectionsKt.toSet((Iterable)list2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set existing = set;
        Iterable<String> iterable = values2;
        String string = name;
        StringValuesBuilder stringValuesBuilder = this;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!existing.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        stringValuesBuilder.appendAll(string, list3);
    }

    public final void remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.values.remove(name);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeKeysWithNoEntries() {
        void $this$filterTo$iv$iv;
        Map<String, List<String>> $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map<String, List<String>> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((List)it.getValue()).isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterator iterator3 = destination$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            String k = (String)iterator3.next().getKey();
            this.remove(k);
        }
    }

    public final boolean remove(@NotNull String name, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<String> list2 = this.values.get(name);
        return list2 == null ? false : (bl = list2.remove(value));
    }

    public final void clear() {
        this.values.clear();
    }

    @NotNull
    public StringValues build() {
        if (!(!this.built)) {
            boolean bl = false;
            String string = "ValueMapBuilder can only build a single ValueMap";
            throw new IllegalArgumentException(string.toString());
        }
        this.built = true;
        return new StringValuesImpl(this.caseInsensitiveName, this.values);
    }

    protected void validateName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    protected void validateValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    private final List<String> ensureListForKey(String name, int size2) {
        List list2;
        if (this.built) {
            throw new IllegalStateException("Cannot modify a builder after build() function already invoked. Make sure you call build() last.");
        }
        List list3 = this.values.get(name);
        if (list3 == null) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(size2);
            boolean bl = false;
            this.validateName(name);
            this.getValues().put(name, it);
            list2 = arrayList;
        } else {
            list2 = list3;
        }
        return list2;
    }

    public StringValuesBuilder() {
        this(false, 0, 3, null);
    }
}

