/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.routing;

import io.ktor.application.ApplicationCall;
import io.ktor.routing.Route;
import io.ktor.routing.RoutingResolveResult;
import io.ktor.routing.RoutingResolveTrace;
import io.ktor.routing.RoutingResolveTraceEntry;
import io.ktor.routing.Stack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0006J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bJ\u001a\u0010\u001f\u001a\u00020\u00142\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u0005J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bJ\b\u0010!\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/ktor/routing/RoutingResolveTrace;", "", "call", "Lio/ktor/application/ApplicationCall;", "segments", "", "", "(Lio/ktor/application/ApplicationCall;Ljava/util/List;)V", "getCall", "()Lio/ktor/application/ApplicationCall;", "finalResult", "Lio/ktor/routing/RoutingResolveResult;", "routing", "Lio/ktor/routing/RoutingResolveTraceEntry;", "getSegments", "()Ljava/util/List;", "stack", "Lio/ktor/routing/Stack;", "successResults", "begin", "", "route", "Lio/ktor/routing/Route;", "segmentIndex", "", "buildText", "finish", "result", "register", "entry", "registerFinalResult", "registerSuccessResults", "skip", "toString", "ktor-server-core"})
public final class RoutingResolveTrace {
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final List<String> segments;
    @NotNull
    private final Stack<RoutingResolveTraceEntry> stack;
    @Nullable
    private RoutingResolveTraceEntry routing;
    private List<? extends List<? extends RoutingResolveResult>> successResults;
    private RoutingResolveResult finalResult;

    public RoutingResolveTrace(@NotNull ApplicationCall call2, @NotNull List<String> segments2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(segments2, (String)"segments");
        this.call = call2;
        this.segments = segments2;
        this.stack = new Stack();
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    private final void register(RoutingResolveTraceEntry entry) {
        if (this.stack.empty()) {
            this.routing = entry;
        } else {
            this.stack.peek().append(entry);
        }
    }

    public final void begin(@NotNull Route route, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.stack.push(new RoutingResolveTraceEntry(route, segmentIndex, null, 4, null));
    }

    public final void finish(@NotNull Route route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        RoutingResolveTraceEntry entry = this.stack.pop();
        if (!Intrinsics.areEqual((Object)entry.getRoute(), (Object)route)) {
            boolean $i$a$-require-RoutingResolveTrace$finish$32 = false;
            String $i$a$-require-RoutingResolveTrace$finish$32 = "end should be called for the same route as begin";
            throw new IllegalArgumentException($i$a$-require-RoutingResolveTrace$finish$32.toString());
        }
        if (!(entry.getSegmentIndex() == segmentIndex)) {
            boolean bl = false;
            String string = "end should be called for the same segmentIndex as begin";
            throw new IllegalArgumentException(string.toString());
        }
        entry.setResult(result2);
        this.register(entry);
    }

    public final void skip(@NotNull Route route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.register(new RoutingResolveTraceEntry(route, segmentIndex, result2));
    }

    public final void registerSuccessResults(@NotNull List<? extends List<? extends RoutingResolveResult>> successResults) {
        Intrinsics.checkNotNullParameter(successResults, (String)"successResults");
        this.successResults = successResults;
    }

    public final void registerFinalResult(@NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.finalResult = result2;
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"Trace for ", this.segments);
    }

    @NotNull
    public final String buildText() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildText_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$buildText_u24lambda_u2d2.append(this.toString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        RoutingResolveTraceEntry routingResolveTraceEntry = this.routing;
        if (routingResolveTraceEntry != null) {
            routingResolveTraceEntry.buildText($this$buildText_u24lambda_u2d2, 0);
        }
        if (this.successResults != null) {
            stringBuilder2 = $this$buildText_u24lambda_u2d2.append("Matched routes:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            List<? extends List<? extends RoutingResolveResult>> list2 = this.successResults;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"successResults");
                list2 = null;
            }
            if (list2.isEmpty()) {
                stringBuilder2 = $this$buildText_u24lambda_u2d2.append("  No results");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                stringBuilder3 = stringBuilder2.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            } else {
                List<? extends List<? extends RoutingResolveResult>> list3 = this.successResults;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"successResults");
                    list3 = null;
                }
                stringBuilder2 = $this$buildText_u24lambda_u2d2.append(CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n", null, null, (int)0, null, (Function1)buildText.1.2.INSTANCE, (int)30, null));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                stringBuilder3 = stringBuilder2.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            }
            stringBuilder2 = $this$buildText_u24lambda_u2d2.append("Route resolve result:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            RoutingResolveResult routingResolveResult = this.finalResult;
            if (routingResolveResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalResult");
                routingResolveResult = null;
            }
            stringBuilder2 = $this$buildText_u24lambda_u2d2.append(Intrinsics.stringPlus((String)"  ", (Object)routingResolveResult));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

