/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.routing;

import io.ktor.features.BadRequestException;
import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.routing.RouteSelector;
import io.ktor.routing.RouteSelectorEvaluation;
import io.ktor.routing.RoutingResolveContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lio/ktor/routing/HttpAcceptRouteSelector;", "Lio/ktor/routing/RouteSelector;", "contentType", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)V", "getContentType", "()Lio/ktor/http/ContentType;", "component1", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/routing/RoutingResolveContext;", "segmentIndex", "", "hashCode", "toString", "", "ktor-server-core"})
public final class HttpAcceptRouteSelector
extends RouteSelector {
    @NotNull
    private final ContentType contentType;

    public HttpAcceptRouteSelector(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.contentType = contentType2;
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String acceptHeaderContent = context.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getAccept());
        try {
            Object v0;
            block5: {
                List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortContentTypeHeader(acceptHeaderContent);
                if (parsedHeaders.isEmpty()) {
                    return RouteSelectorEvaluation.Companion.getMissing();
                }
                Iterable $this$firstOrNull$iv = parsedHeaders;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HeaderValue it = (HeaderValue)element$iv;
                    boolean bl = false;
                    if (!this.getContentType().match(it.getValue())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            HeaderValue header = v0;
            if (header != null) {
                return new RouteSelectorEvaluation(true, header.getQuality(), null, 0, 12, null);
            }
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        catch (BadContentTypeFormatException failedToParse) {
            throw new BadRequestException(Intrinsics.stringPlus((String)"Illegal Accept header format: ", (Object)acceptHeaderContent), failedToParse);
        }
    }

    @NotNull
    public String toString() {
        return "(contentType:" + this.contentType + ')';
    }

    @NotNull
    public final ContentType component1() {
        return this.contentType;
    }

    @NotNull
    public final HttpAcceptRouteSelector copy(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        return new HttpAcceptRouteSelector(contentType2);
    }

    public static /* synthetic */ HttpAcceptRouteSelector copy$default(HttpAcceptRouteSelector httpAcceptRouteSelector, ContentType contentType2, int n, Object object) {
        if ((n & 1) != 0) {
            contentType2 = httpAcceptRouteSelector.contentType;
        }
        return httpAcceptRouteSelector.copy(contentType2);
    }

    public int hashCode() {
        return this.contentType.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpAcceptRouteSelector)) {
            return false;
        }
        HttpAcceptRouteSelector httpAcceptRouteSelector = (HttpAcceptRouteSelector)other;
        return Intrinsics.areEqual((Object)this.contentType, (Object)httpAcceptRouteSelector.contentType);
    }
}

