/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectableBase;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.CIOReaderKt;
import io.ktor.network.sockets.CIOWriterKt;
import io.ktor.network.sockets.ReadWriteSocket;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ReaderJob;
import io.ktor.utils.io.WriterJob;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B1\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u00101\u001a\u0004\u0018\u00010,H\u0002JE\u00102\u001a\u0002H3\"\b\b\u0001\u00103*\u00020(2\u0006\u00104\u001a\u0002052\u0006\u0010\u0007\u001a\u0002062\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H30\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H309H\u0002\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020%2\u0006\u0010\u0007\u001a\u000206J\u000e\u0010<\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u000206J\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020>H\u0016J\u001e\u0010@\u001a\u0004\u0018\u00010,2\b\u0010A\u001a\u0004\u0018\u00010,2\b\u0010B\u001a\u0004\u0018\u00010,H\u0002J\b\u0010C\u001a\u00020>H\u0016R\u0016\u0010\u0007\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010&\u001a\u00020'*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010(0\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R*\u0010+\u001a\u0004\u0018\u00010,*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010(0\u001c8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u0006D"}, d2={"Lio/ktor/network/sockets/NIOSocketImpl;", "S", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/SelectableChannel;", "Lio/ktor/network/sockets/ReadWriteSocket;", "Lio/ktor/network/selector/SelectableBase;", "Lkotlinx/coroutines/CoroutineScope;", "channel", "selector", "Lio/ktor/network/selector/SelectorManager;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "socketOptions", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/selector/SelectorManager;Lio/ktor/utils/io/pool/ObjectPool;Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;)V", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "Ljava/nio/channels/SelectableChannel;", "closeFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "readerJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/ktor/utils/io/ReaderJob;", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "socketContext", "Lkotlinx/coroutines/CompletableJob;", "getSocketContext", "()Lkotlinx/coroutines/CompletableJob;", "writerJob", "Lio/ktor/utils/io/WriterJob;", "completedOrNotStarted", "", "Lkotlinx/coroutines/Job;", "getCompletedOrNotStarted", "(Ljava/util/concurrent/atomic/AtomicReference;)Z", "exception", "", "getException$annotations", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getException", "(Ljava/util/concurrent/atomic/AtomicReference;)Ljava/lang/Throwable;", "actualClose", "attachFor", "J", "name", "", "Lio/ktor/utils/io/ByteChannel;", "ref", "producer", "Lkotlin/Function0;", "(Ljava/lang/String;Lio/ktor/utils/io/ByteChannel;Ljava/util/concurrent/atomic/AtomicReference;Lkotlin/jvm/functions/Function0;)Lkotlinx/coroutines/Job;", "attachForReading", "attachForWriting", "checkChannels", "", "close", "combine", "e1", "e2", "dispose", "ktor-network"})
public abstract class NIOSocketImpl<S extends SelectableChannel>
extends SelectableBase
implements ReadWriteSocket,
CoroutineScope {
    @NotNull
    private final S channel;
    @NotNull
    private final SelectorManager selector;
    @Nullable
    private final ObjectPool<ByteBuffer> pool;
    @Nullable
    private final SocketOptions.TCPClientSocketOptions socketOptions;
    @NotNull
    private final AtomicBoolean closeFlag;
    @NotNull
    private final AtomicReference<ReaderJob> readerJob;
    @NotNull
    private final AtomicReference<WriterJob> writerJob;
    @NotNull
    private final CompletableJob socketContext;

    public NIOSocketImpl(@NotNull S channel2, @NotNull SelectorManager selector, @Nullable ObjectPool<ByteBuffer> pool, @Nullable SocketOptions.TCPClientSocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        super((SelectableChannel)channel2);
        this.channel = channel2;
        this.selector = selector;
        this.pool = pool;
        this.socketOptions = socketOptions;
        this.closeFlag = new AtomicBoolean();
        this.readerJob = new AtomicReference();
        this.writerJob = new AtomicReference();
        this.socketContext = JobKt.Job$default(null, (int)1, null);
    }

    public /* synthetic */ NIOSocketImpl(SelectableChannel selectableChannel, SelectorManager selectorManager, ObjectPool objectPool, SocketOptions.TCPClientSocketOptions tCPClientSocketOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tCPClientSocketOptions = null;
        }
        this(selectableChannel, selectorManager, objectPool, tCPClientSocketOptions);
    }

    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Nullable
    public final ObjectPool<ByteBuffer> getPool() {
        return this.pool;
    }

    @NotNull
    public CompletableJob getSocketContext() {
        return this.socketContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.getSocketContext();
    }

    @Override
    @NotNull
    public final WriterJob attachForReading(@NotNull ByteChannel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        return this.attachFor("reading", channel2, this.writerJob, (Function0)new Function0<WriterJob>(this, channel2){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            final /* synthetic */ ByteChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(0);
            }

            @NotNull
            public final WriterJob invoke() {
                return this.this$0.getPool() != null ? CIOReaderKt.attachForReadingImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), this.this$0.getPool(), NIOSocketImpl.access$getSocketOptions$p(this.this$0)) : CIOReaderKt.attachForReadingDirectImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), NIOSocketImpl.access$getSocketOptions$p(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public final ReaderJob attachForWriting(@NotNull ByteChannel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        return this.attachFor("writing", channel2, this.readerJob, (Function0)new Function0<ReaderJob>(this, channel2){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            final /* synthetic */ ByteChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(0);
            }

            @NotNull
            public final ReaderJob invoke() {
                return CIOWriterKt.attachForWritingDirectImpl(this.this$0, this.$channel, (WritableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), NIOSocketImpl.access$getSocketOptions$p(this.this$0));
            }
        });
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (this.closeFlag.compareAndSet(false, true)) {
            ReaderJob readerJob2 = this.readerJob.get();
            if (readerJob2 != null) {
                ByteWriteChannel byteWriteChannel = readerJob2.getChannel();
                if (byteWriteChannel != null) {
                    ByteWriteChannelKt.close(byteWriteChannel);
                }
            }
            WriterJob writerJob = this.writerJob.get();
            if (writerJob != null) {
                Job.DefaultImpls.cancel$default((Job)writerJob, null, (int)1, null);
            }
            this.checkChannels();
        }
    }

    private final <J extends Job> J attachFor(String name, ByteChannel channel2, AtomicReference<J> ref, Function0<? extends J> producer) {
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            channel2.close(e);
            throw e;
        }
        Job j = (Job)producer.invoke();
        if (!ref.compareAndSet(null, j)) {
            IllegalStateException e = new IllegalStateException(Intrinsics.stringPlus((String)name, (Object)" channel has already been set"));
            Job.DefaultImpls.cancel$default((Job)j, null, (int)1, null);
            throw e;
        }
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            Job.DefaultImpls.cancel$default((Job)j, null, (int)1, null);
            channel2.close(e);
            throw e;
        }
        channel2.attachJob(j);
        j.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                NIOSocketImpl.access$checkChannels(this.this$0);
            }
        });
        return (J)j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable actualClose() {
        Throwable throwable;
        try {
            ((java.nio.channels.ByteChannel)this.getChannel()).close();
            super.close();
            throwable = null;
        }
        catch (Throwable cause) {
            throwable = cause;
        }
        finally {
            this.selector.notifyClosed(this);
        }
        return throwable;
    }

    private final void checkChannels() {
        if (this.closeFlag.get() && this.getCompletedOrNotStarted(this.readerJob) && this.getCompletedOrNotStarted(this.writerJob)) {
            Throwable e1 = this.getException(this.readerJob);
            Throwable e2 = this.getException(this.writerJob);
            Throwable e3 = this.actualClose();
            Throwable combined = this.combine(this.combine(e1, e2), e3);
            if (combined == null) {
                this.getSocketContext().complete();
            } else {
                this.getSocketContext().completeExceptionally(combined);
            }
        }
    }

    private final Throwable combine(Throwable e1, Throwable e2) {
        Throwable throwable;
        if (e1 == null) {
            throwable = e2;
        } else if (e2 == null) {
            throwable = e1;
        } else if (e1 == e2) {
            throwable = e1;
        } else {
            ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e2);
            throwable = e1;
        }
        return throwable;
    }

    private final boolean getCompletedOrNotStarted(AtomicReference<? extends Job> $this$completedOrNotStarted) {
        Job it = $this$completedOrNotStarted.get();
        boolean bl = false;
        return it == null || it.isCompleted();
    }

    private final Throwable getException(AtomicReference<? extends Job> $this$exception) {
        Throwable throwable;
        Job job2 = $this$exception.get();
        if (job2 == null) {
            throwable = null;
        } else {
            Job job3;
            Job job4;
            Job it = job4 = job2;
            boolean bl = false;
            Object object = job3 = it.isCancelled() ? job4 : null;
            if (job3 == null) {
                throwable = null;
            } else {
                CancellationException cancellationException = job3.getCancellationException();
                throwable = cancellationException == null ? null : cancellationException.getCause();
            }
        }
        return throwable;
    }

    private static /* synthetic */ void getException$annotations(AtomicReference atomicReference) {
    }

    public static final /* synthetic */ SocketOptions.TCPClientSocketOptions access$getSocketOptions$p(NIOSocketImpl $this) {
        return $this.socketOptions;
    }

    public static final /* synthetic */ void access$checkChannels(NIOSocketImpl $this) {
        $this.checkChannels();
    }
}

