/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.Frame;
import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.AbstractInput;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"readBytes", "", "Lio/ktor/http/cio/websocket/Frame;", "readReason", "Lio/ktor/http/cio/websocket/CloseReason;", "Lio/ktor/http/cio/websocket/Frame$Close;", "readText", "", "Lio/ktor/http/cio/websocket/Frame$Text;", "ktor-http-cio"})
public final class FrameCommonKt {
    @NotNull
    public static final String readText(@NotNull Frame.Text $this$readText) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        if (!$this$readText.getFin()) {
            boolean $i$a$-require-FrameCommonKt$readText$22 = false;
            String $i$a$-require-FrameCommonKt$readText$22 = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException($i$a$-require-FrameCommonKt$readText$22.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"UTF_8.newDecoder()");
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$readText_u24lambda_u2d1 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readText_u24lambda_u2d1, $this$readText.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return EncodingKt.decode$default(charsetDecoder2, byteReadPacket, 0, 2, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Frame $this$readBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        byte[] byArray = $this$readBytes.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
        return byArray2;
    }

    @Nullable
    public static final CloseReason readReason(@NotNull Frame.Close $this$readReason) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$readReason, (String)"<this>");
        if ($this$readReason.getData().length < 2) {
            return null;
        }
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$readReason_u24lambda_u2d2 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readReason_u24lambda_u2d2, $this$readReason.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        short code = InputPrimitivesKt.readShort(packet);
        String message2 = AbstractInput.readText$default(packet, 0, 0, 3, null);
        return new CloseReason(code, message2);
    }
}

