/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.ApplicationCall;
import io.ktor.features.Compression;
import io.ktor.features.CompressionEncoderBuilder;
import io.ktor.features.CompressionKt;
import io.ktor.features.ConditionsHolderBuilder;
import io.ktor.features.DeflateEncoder;
import io.ktor.features.GzipEncoder;
import io.ktor.features.IdentityEncoder;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.OutgoingContent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u001a)\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u001d\u0010\u0005\u001a\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\b\n\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a%\u0010\f\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a#\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\u001a%\u0010\u0016\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a%\u0010\u0017\u001a\u00020\u0003*\u00020\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\b\n\u001a\f\u0010\u0018\u001a\u00020\t*\u00020\u0007H\u0002\u001a#\u0010\u0019\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u001a\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DEFAULT_MINIMAL_COMPRESSION_SIZE", "", "condition", "", "Lio/ktor/features/ConditionsHolderBuilder;", "predicate", "Lkotlin/Function2;", "Lio/ktor/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "defaultConditions", "deflate", "Lio/ktor/features/Compression$Configuration;", "block", "Lkotlin/Function1;", "Lio/ktor/features/CompressionEncoderBuilder;", "excludeContentType", "mimeTypes", "", "Lio/ktor/http/ContentType;", "(Lio/ktor/features/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "gzip", "identity", "isCompressionSuppressed", "matchContentType", "minimumSize", "minSize", "ktor-server-core"})
public final class CompressionKt {
    public static final long DEFAULT_MINIMAL_COMPRESSION_SIZE = 200L;

    private static final boolean isCompressionSuppressed(ApplicationCall $this$isCompressionSuppressed) {
        return $this$isCompressionSuppressed.getAttributes().contains(Compression.Feature.getSuppressionAttribute());
    }

    public static final void gzip(@NotNull Compression.Configuration $this$gzip, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$gzip.encoder("gzip", GzipEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void gzip$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = gzip.1.INSTANCE;
        }
        CompressionKt.gzip(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void deflate(@NotNull Compression.Configuration $this$deflate, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$deflate, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$deflate.encoder("deflate", DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)((Function1)new Function1<CompressionEncoderBuilder, Unit>(block2){
            final /* synthetic */ Function1<CompressionEncoderBuilder, Unit> $block;
            {
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull CompressionEncoderBuilder $this$encoder) {
                Intrinsics.checkNotNullParameter((Object)$this$encoder, (String)"$this$encoder");
                $this$encoder.setPriority(0.9);
                this.$block.invoke((Object)$this$encoder);
            }
        }));
    }

    public static /* synthetic */ void deflate$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = deflate.1.INSTANCE;
        }
        CompressionKt.deflate(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void identity(@NotNull Compression.Configuration $this$identity, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$identity, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        $this$identity.encoder("identity", IdentityEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void identity$default(Compression.Configuration configuration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = identity.1.INSTANCE;
        }
        CompressionKt.identity(configuration, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $this$condition, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        $this$condition.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $this$minimumSize, long minSize) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumSize, (String)"<this>");
        CompressionKt.condition($this$minimumSize, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(minSize){
            final /* synthetic */ long $minSize;
            {
                this.$minSize = $minSize;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Long l = content2.getContentLength();
                if (l == null) {
                    bl = true;
                } else {
                    boolean bl2;
                    Long l2 = l;
                    long l3 = this.$minSize;
                    long it = ((Number)l2).longValue();
                    boolean bl3 = false;
                    bl = bl2 = it >= l3;
                }
                return bl;
            }
        }));
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $this$matchContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$matchContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($this$matchContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        return false;
                    }
                    ContentType contentType3 = contentType2;
                    ContentType[] $this$any$iv = this.$mimeTypes;
                    boolean $i$f$any = false;
                    for (ContentType element$iv : $this$any$iv) {
                        ContentType it = element$iv;
                        boolean bl2 = false;
                        if (!contentType3.match(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }
        }));
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $this$excludeContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        CompressionKt.condition($this$excludeContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        ContentType contentType3;
                        String string = $this$condition.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                        if (string == null) {
                            contentType3 = null;
                        } else {
                            String it = string;
                            boolean bl2 = false;
                            contentType3 = ContentType.Companion.parse(it);
                        }
                        ContentType contentType4 = contentType3;
                        if (contentType4 == null) {
                            return true;
                        }
                        contentType2 = contentType4;
                    }
                    ContentType contentType5 = contentType2;
                    ContentType[] $this$none$iv = this.$mimeTypes;
                    boolean $i$f$none = false;
                    for (ContentType element$iv : $this$none$iv) {
                        ContentType excludePattern = element$iv;
                        boolean bl3 = false;
                        if (!contentType5.match(excludePattern)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private static final void defaultConditions(ConditionsHolderBuilder $this$defaultConditions) {
        ContentType[] contentTypeArray = new ContentType[]{ContentType.Video.INSTANCE.getAny(), ContentType.Image.INSTANCE.getJPEG(), ContentType.Image.INSTANCE.getPNG(), ContentType.Audio.INSTANCE.getAny(), ContentType.MultiPart.INSTANCE.getAny(), ContentType.Text.INSTANCE.getEventStream()};
        CompressionKt.excludeContentType($this$defaultConditions, contentTypeArray);
        CompressionKt.minimumSize($this$defaultConditions, 200L);
    }

    public static final /* synthetic */ boolean access$isCompressionSuppressed(ApplicationCall $receiver) {
        return CompressionKt.isCompressionSuppressed($receiver);
    }

    public static final /* synthetic */ void access$defaultConditions(ConditionsHolderBuilder $receiver) {
        CompressionKt.defaultConditions($receiver);
    }
}

