/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.cache;

import io.ktor.client.HttpClient;
import io.ktor.client.call.SavedHttpCall;
import io.ktor.client.call.SavedHttpRequest;
import io.ktor.client.call.SavedHttpResponse;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.util.date.GMTDate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lio/ktor/client/features/cache/HttpCacheEntry;", "", "expires", "Lio/ktor/util/date/GMTDate;", "varyKeys", "", "", "response", "Lio/ktor/client/statement/HttpResponse;", "body", "", "(Lio/ktor/util/date/GMTDate;Ljava/util/Map;Lio/ktor/client/statement/HttpResponse;[B)V", "getBody", "()[B", "getExpires", "()Lio/ktor/util/date/GMTDate;", "getResponse", "()Lio/ktor/client/statement/HttpResponse;", "responseHeaders", "Lio/ktor/http/Headers;", "getResponseHeaders$ktor_client_core", "()Lio/ktor/http/Headers;", "getVaryKeys", "()Ljava/util/Map;", "equals", "", "other", "hashCode", "", "produceResponse", "produceResponse$ktor_client_core", "ktor-client-core"})
public final class HttpCacheEntry {
    @NotNull
    private final GMTDate expires;
    @NotNull
    private final Map<String, String> varyKeys;
    @NotNull
    private final HttpResponse response;
    @NotNull
    private final byte[] body;
    @NotNull
    private final Headers responseHeaders;

    /*
     * WARNING - void declaration
     */
    public HttpCacheEntry(@NotNull GMTDate expires, @NotNull Map<String, String> varyKeys, @NotNull HttpResponse response2, @NotNull byte[] body) {
        void $this$responseHeaders_u24lambda_u2d0;
        HeadersBuilder headersBuilder;
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter(varyKeys, (String)"varyKeys");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.expires = expires;
        this.varyKeys = varyKeys;
        this.response = response2;
        this.body = body;
        Headers.Companion this_$iv = Headers.Companion;
        boolean $i$f$build = false;
        HeadersBuilder headersBuilder2 = headersBuilder = new HeadersBuilder(0, 1, null);
        HttpCacheEntry httpCacheEntry = this;
        boolean bl = false;
        $this$responseHeaders_u24lambda_u2d0.appendAll(this.getResponse().getHeaders());
        httpCacheEntry.responseHeaders = headersBuilder.build();
    }

    @NotNull
    public final GMTDate getExpires() {
        return this.expires;
    }

    @NotNull
    public final Map<String, String> getVaryKeys() {
        return this.varyKeys;
    }

    @NotNull
    public final HttpResponse getResponse() {
        return this.response;
    }

    @NotNull
    public final byte[] getBody() {
        return this.body;
    }

    @NotNull
    public final Headers getResponseHeaders$ktor_client_core() {
        return this.responseHeaders;
    }

    @NotNull
    public final HttpResponse produceResponse$ktor_client_core() {
        HttpClient httpClient = this.response.getCall().getClient();
        if (httpClient == null) {
            throw new IllegalStateException("Failed to save response in cache in different thread.".toString());
        }
        HttpClient currentClient = httpClient;
        SavedHttpCall call2 = new SavedHttpCall(currentClient, this.body);
        call2.setResponse$ktor_client_core(new SavedHttpResponse(call2, this.body, this.response));
        call2.setRequest$ktor_client_core(new SavedHttpRequest(call2, this.response.getCall().getRequest()));
        return call2.getResponse();
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof HttpCacheEntry)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return Intrinsics.areEqual(this.varyKeys, ((HttpCacheEntry)other).varyKeys);
    }

    public int hashCode() {
        return ((Object)this.varyKeys).hashCode();
    }
}

