/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.api.http.util;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a,\u0010\r\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a$\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0010\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0011\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0013\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "parseFile", "slashCount", "parseFragment", "parseMailto", "parseQuery", "smartTakeFrom", "takeFromUnsafe", "mirai-api-http"})
public final class UrlKt {
    @NotNull
    public static final URLBuilder smartTakeFrom(@NotNull URLBuilder $this$smartTakeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$smartTakeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = UrlKt.takeFromUnsafe($this$smartTakeFrom, urlString);
        }
        catch (Throwable cause) {
            throw new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    private static final URLBuilder takeFromUnsafe(URLBuilder $this$takeFromUnsafe, String urlString) {
        String string;
        int delimiter;
        int it;
        int n;
        int startIndex;
        block22: {
            int n2;
            int n3;
            block21: {
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                n3 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    char it2 = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it2))) continue;
                    n2 = index$iv;
                    break block21;
                }
                n2 = -1;
            }
            startIndex = n2;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it3 = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it3))) continue;
                    n = index$iv;
                    break block22;
                } while (0 <= n3);
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = UrlKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String string2 = urlString.substring(startIndex, startIndex + schemeLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String scheme = string2;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = UrlKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            UrlKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            UrlKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        char[] cArray = "@/\\?#".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] delimiterArr = cArray;
        if (slashCount >= 2) {
            while (true) {
                Integer n4 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])delimiterArr, (int)startIndex, (boolean)false, (int)4, null);
                it = ((Number)n4).intValue();
                boolean bl = false;
                Integer n5 = it > 0 ? n4 : null;
                int n6 = delimiter = n5 != null ? n5 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = UrlKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    String string3 = urlString.substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default((String)string3, (int)0, (int)0, null, (int)7, null));
                    String string4 = urlString.substring(passwordIndex + 1, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setPassword(CodecsKt.decodeURLPart$default((String)string4, (int)0, (int)0, null, (int)7, null));
                } else {
                    String string5 = urlString.substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default((String)string5, (int)0, (int)0, null, (int)7, null));
                }
                startIndex = delimiter + 1;
            }
            UrlKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        } else if (slashCount == 0) {
            Integer n7 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])delimiterArr, (int)startIndex, (boolean)false, (int)4, null);
            it = ((Number)n7).intValue();
            boolean bl = false;
            Integer n8 = it > 0 ? n7 : null;
            delimiter = n8 != null ? n8 : endIndex;
            UrlKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter + 1;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPath(urlString.charAt(endIndex - 1) == '/' ? "/" : "");
            return $this$takeFromUnsafe;
        }
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$this$takeFromUnsafe.getEncodedPath(), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIndex != $this$takeFromUnsafe.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String string6 = $this$takeFromUnsafe.getEncodedPath().substring(0, lastSlashIndex + 1);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = "/";
                }
            } else {
                string = $this$takeFromUnsafe.getEncodedPath();
            }
        } else {
            string = "";
        }
        $this$takeFromUnsafe.setEncodedPath(string);
        CharSequence charSequence = urlString;
        char[] cArray2 = "?#".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        Integer n9 = StringsKt.indexOfAny$default((CharSequence)charSequence, (char[])cArray2, (int)startIndex, (boolean)false, (int)4, null);
        it = ((Number)n9).intValue();
        boolean bl = false;
        Integer n10 = it > 0 ? n9 : null;
        int pathEnd = n10 != null ? n10 : endIndex;
        String string7 = urlString.substring(startIndex, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String rawPath = string7;
        $this$takeFromUnsafe.setEncodedPath($this$takeFromUnsafe.getEncodedPath() + CodecsKt.encodeURLPath((String)rawPath));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = UrlKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        UrlKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        switch (slashCount) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$parseFile.setHost(string);
                    return;
                }
                String string = urlString.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setHost(string);
                String string2 = urlString.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(string2);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string = urlString.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(stringBuilder.append(string).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid file url: " + urlString);
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default((String)string, (int)0, (int)0, null, (int)7, null));
        String string2 = urlString.substring(delimiter + 1, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setHost(string2);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int fragmentStart = n2 != null ? n2 : endIndex;
        String string = urlString.substring(startIndex + 1, fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Parameters rawParameters = QueryKt.parseQueryString$default((String)string, (int)0, (int)0, (int)6, null);
        rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($this$parseQuery){
            final /* synthetic */ URLBuilder $this_parseQuery;
            {
                this.$this_parseQuery = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String key, @NotNull List<String> values) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.$this_parseQuery.getParameters().appendAll(key, (Iterable)values);
            }
        });
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$parseFragment.setFragment(string);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        int n;
        Integer n2 = UrlKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it > 0 ? n2 : null;
        int colonIndex = n3 != null ? n3 : endIndex;
        String string = urlString.substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            String string2 = urlString.substring(colonIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            n = Integer.parseInt(string2);
        } else {
            n = 0;
        }
        $this$fillHost.setPort(n);
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar < '{' : false)) {
            if (!('A' <= firstChar ? firstChar < '[' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':' && current + 2 < endIndex && urlString.charAt(current + 2) == '/' && urlString.charAt(current + 1) == '/') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException("Illegal character in scheme at position " + incorrectSchemePosition);
                }
                return current - startIndex;
            }
            if (c == '/' || c == '?' || c == '#') {
                return -1;
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c < '{' : false)) {
                    if (!('A' <= c ? c < '[' : false)) {
                        if (!('0' <= c ? c < ':' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        for (int index = startIndex; index < endIndex; ++index) {
            char c = $this$indexOfColonInHostPort.charAt(index);
            if (c == '[') {
                skip = true;
                continue;
            }
            if (c == ']') {
                skip = false;
                continue;
            }
            if (c != ':' || skip) continue;
            return index;
        }
        return -1;
    }
}

