/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.api.http.context.session.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.api.http.context.MahContext;
import net.mamoe.mirai.api.http.context.session.ListenableSessionWrapper;
import net.mamoe.mirai.api.http.context.session.Session;
import net.mamoe.mirai.api.http.context.session.StandardSession;
import net.mamoe.mirai.api.http.context.session.manager.SessionManager;
import net.mamoe.mirai.api.http.context.session.manager.UtilKt;
import net.mamoe.mirai.api.http.setting.MainSetting;
import net.mamoe.mirai.api.http.spi.persistence.Persistence;
import net.mamoe.mirai.api.http.spi.persistence.PersistenceFactory;
import net.mamoe.mirai.api.http.spi.persistence.PersistenceManager;
import net.mamoe.mirai.event.events.BotEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0013\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0019\u0010%\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0013H\u0096\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lnet/mamoe/mirai/api/http/context/session/manager/DefaultSessionManager;", "Lnet/mamoe/mirai/api/http/context/session/manager/SessionManager;", "verifyKey", "", "context", "Lnet/mamoe/mirai/api/http/context/MahContext;", "(Ljava/lang/String;Lnet/mamoe/mirai/api/http/context/MahContext;)V", "cacheMap", "", "", "Lnet/mamoe/mirai/api/http/spi/persistence/Persistence;", "getContext", "()Lnet/mamoe/mirai/api/http/context/MahContext;", "persistenceFactory", "Lnet/mamoe/mirai/api/http/spi/persistence/PersistenceFactory;", "persistenceFactoryName", "persistenceManager", "Lnet/mamoe/mirai/api/http/spi/persistence/PersistenceManager;", "sessionMap", "Lnet/mamoe/mirai/api/http/context/session/Session;", "getVerifyKey", "()Ljava/lang/String;", "authSession", "bot", "Lnet/mamoe/mirai/Bot;", "tempSessionKey", "authedSessions", "", "close", "", "closeSession", "key", "createOneTimeSession", "Lnet/mamoe/mirai/api/http/context/session/StandardSession;", "createTempSession", "get", "getCache", "set", "session", "mirai-api-http"})
public final class DefaultSessionManager
implements SessionManager {
    @NotNull
    private final String verifyKey;
    @NotNull
    private final MahContext context;
    @NotNull
    private final String persistenceFactoryName;
    @NotNull
    private final PersistenceManager persistenceManager;
    @NotNull
    private final PersistenceFactory persistenceFactory;
    @NotNull
    private final Map<String, Session> sessionMap;
    @NotNull
    private final Map<Long, Persistence> cacheMap;

    public DefaultSessionManager(@NotNull String verifyKey, @NotNull MahContext context) {
        Intrinsics.checkNotNullParameter((Object)verifyKey, (String)"verifyKey");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.verifyKey = verifyKey;
        this.context = context;
        this.persistenceFactoryName = MainSetting.INSTANCE.getPersistenceFactory();
        this.persistenceManager = new PersistenceManager(this.persistenceFactoryName);
        this.persistenceFactory = this.persistenceManager.loadFactory();
        this.sessionMap = new LinkedHashMap();
        this.cacheMap = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String getVerifyKey() {
        return this.verifyKey;
    }

    @NotNull
    public final MahContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public StandardSession createOneTimeSession(@NotNull Bot bot) {
        StandardSession standardSession;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        StandardSession oneTimeSession = standardSession = new StandardSession("", this);
        boolean bl = false;
        oneTimeSession.authWith(bot, this.getCache(bot));
        return standardSession;
    }

    @Override
    @NotNull
    public Session createTempSession() {
        return this.createTempSession(UtilKt.generateSessionKey(this));
    }

    @Override
    @NotNull
    public Session createTempSession(@NotNull String key) {
        StandardSession standardSession;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StandardSession newTempSession = standardSession = new StandardSession(key, this);
        boolean bl = false;
        ListenableSessionWrapper proxy = new ListenableSessionWrapper(newTempSession);
        ListenableSessionWrapper.startExpiredCountdown$default(proxy, 180000L, null, 2, null);
        this.sessionMap.put(newTempSession.getKey(), proxy);
        return standardSession;
    }

    @Override
    @NotNull
    public Session authSession(@NotNull Bot bot, @NotNull String tempSessionKey) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)tempSessionKey, (String)"tempSessionKey");
        Session session2 = this.get(tempSessionKey);
        if (session2 == null) {
            throw new NoSuchElementException();
        }
        Session session3 = session2;
        if (session3.isAuthed()) {
            return session3;
        }
        session3.ref();
        session3.putExtElement(ListenableSessionWrapper.Key.getBotEventHandler(), new Function2<Session, BotEvent, Unit>((Object)this.context){

            public final void invoke(@NotNull Session p0, @NotNull BotEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((MahContext)this.receiver).handleBotEvent(p0, p1);
            }
        });
        session3.authWith(bot, this.getCache(bot));
        return session3;
    }

    @Override
    @Nullable
    public Session get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sessionMap.get(key);
    }

    @Override
    public void set(@NotNull String key, @NotNull Session session2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.sessionMap.put(key, session2);
    }

    @Override
    public void closeSession(@NotNull String key) {
        block1: {
            Session session2;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Session session3 = this.sessionMap.get(key);
            if (session3 == null) break block1;
            Session $this$closeSession_u24lambda_u2d2 = session2 = session3;
            boolean bl = false;
            $this$closeSession_u24lambda_u2d2.close();
            if ($this$closeSession_u24lambda_u2d2.getRefCount() <= 0) {
                this.sessionMap.remove(key);
            }
        }
    }

    @Override
    public void close() {
        Map<String, Session> $this$forEach$iv = this.sessionMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Session>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Session> element$iv;
            Map.Entry<String, Session> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            this.closeSession(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Session> authedSessions() {
        void $this$mapTo$iv$iv;
        Map<String, Session> $this$filterValues$iv = this.sessionMap;
        boolean $i$f$filterValues = false;
        Map<String, Session> result$iv = new LinkedHashMap();
        for (Map.Entry<String, Session> entry$iv : $this$filterValues$iv.entrySet()) {
            Session it = entry$iv.getValue();
            boolean bl = false;
            if (!it.isAuthed()) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Session)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Persistence getCache(@NotNull Bot bot) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Persistence cache = null;
        cache = this.cacheMap.get(bot.getId());
        if (cache == null) {
            DefaultSessionManager defaultSessionManager = this;
            synchronized (defaultSessionManager) {
                boolean bl = false;
                cache = this.persistenceFactory.getService(bot);
                Long l = bot.getId();
                Persistence persistence = cache;
                Intrinsics.checkNotNull((Object)persistence);
                this.cacheMap.put(l, persistence);
                Unit unit = Unit.INSTANCE;
            }
        }
        return cache;
    }
}

