/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.ApplicationConfigValue;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.PlatformUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        String string;
        Config config2;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        File file2;
        URL uRL;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Iterator element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string2 = (String)argsMap.get("-jar");
        if (string2 == null) {
            uRL = null;
        } else {
            String it = string2;
            boolean bl = false;
            uRL = StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
        }
        URL jar2 = uRL;
        String string3 = (String)argsMap.get("-config");
        if (string3 == null) {
            file2 = null;
        } else {
            String it = string3;
            boolean bl = false;
            file2 = new File(it);
        }
        File configFile = file2;
        Map $this$filterKeys$iv = argsMap;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"-P:", (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl4 = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            String string4 = StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)"-P:");
            Map map3 = map2;
            boolean bl5 = false;
            it = it$iv$iv.getValue();
            map3.put(string4, it);
        }
        Map commandLineMap = destination$iv$iv2;
        Config environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
        File file3 = configFile;
        if (file3 == null) {
            config2 = null;
        } else {
            File it = file3;
            boolean bl = false;
            config2 = ConfigFactory.parseFile(it);
        }
        Config config3 = config2;
        if (config2 == null) {
            config3 = ConfigFactory.load();
        }
        Config fileConfig = config3;
        Config argConfig = ConfigFactory.parseMap(commandLineMap, "Command-line options");
        Config combinedConfig = argConfig.withFallback(fileConfig).withFallback(environmentConfig).resolve();
        String applicationIdPath = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String rootPathPath = "ktor.deployment.rootPath";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        String developmentModeKey = "ktor.development";
        Intrinsics.checkNotNullExpressionValue((Object)combinedConfig, (String)"combinedConfig");
        String string5 = HoconApplicationConfigKt.tryGetString(combinedConfig, applicationIdPath);
        if (string5 == null) {
            string5 = "Application";
        }
        String applicationId = string5;
        Logger appLog = LoggerFactory.getLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        if ((string = (String)argsMap.get("-path")) == null && (string = HoconApplicationConfigKt.tryGetString(combinedConfig, rootPathPath)) == null) {
            string = "";
        }
        String rootPath = string;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar2, combinedConfig, rootPath, (Map<String, String>)argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, developmentModeKey, hostWatchPaths){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map<String, String> $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $developmentModeKey;
            final /* synthetic */ String $hostWatchPaths;
            {
                this.$appLog = $appLog;
                this.$jar = $jar;
                this.$combinedConfig = $combinedConfig;
                this.$rootPath = $rootPath;
                this.$argsMap = $argsMap;
                this.$hostConfigPath = $hostConfigPath;
                this.$hostPortPath = $hostPortPath;
                this.$hostSslPortPath = $hostSslPortPath;
                this.$hostSslKeyStore = $hostSslKeyStore;
                this.$hostSslKeyStorePassword = $hostSslKeyStorePassword;
                this.$hostSslPrivateKeyPassword = $hostSslPrivateKeyPassword;
                this.$hostSslKeyAlias = $hostSslKeyAlias;
                this.$developmentModeKey = $developmentModeKey;
                this.$hostWatchPaths = $hostWatchPaths;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                List<String> list2;
                List<String> list3;
                Config $this$sslConnector$iv;
                String[] keyStore$iv;
                Object it;
                Boolean bl;
                String string;
                String sslPort;
                String string2;
                String port2;
                String string3;
                String host2;
                Config it2;
                String string4;
                ClassLoader classLoader;
                Object object;
                List<EngineConnectorConfig> list4;
                URLClassLoader uRLClassLoader;
                Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$this$applicationEngineEnvironment");
                Object object2 = this.$appLog;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"appLog");
                $this$applicationEngineEnvironment.setLog((Logger)object2);
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                URL uRL = this.$jar;
                if (uRL == null) {
                    uRLClassLoader = null;
                } else {
                    URL uRL2 = uRL;
                    URL uRL3 = this.$jar;
                    URL uRL4 = uRL2;
                    list4 = applicationEngineEnvironmentBuilder;
                    boolean bl2 = false;
                    object = new URL[]{uRL3};
                    uRLClassLoader = new URLClassLoader((URL[])object, ApplicationEnvironment.class.getClassLoader());
                    applicationEngineEnvironmentBuilder = list4;
                }
                object2 = uRLClassLoader;
                if (object2 == null) {
                    ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
                    classLoader = classLoader2;
                } else {
                    classLoader = (ClassLoader)object2;
                }
                applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
                object2 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"combinedConfig");
                $this$applicationEngineEnvironment.setConfig(new HoconApplicationConfig((Config)object2));
                $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef("***", "Content hidden");
                if (this.$combinedConfig.hasPath("ktor")) {
                    $this$applicationEngineEnvironment.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                } else {
                    $this$applicationEngineEnvironment.getLog().trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
                }
                if ((string4 = this.$argsMap.get("-host")) == null) {
                    it2 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"combinedConfig");
                    string4 = HoconApplicationConfigKt.tryGetString(it2, this.$hostConfigPath);
                    if (string4 == null) {
                        string4 = host2 = "0.0.0.0";
                    }
                }
                if ((string3 = this.$argsMap.get("-port")) == null) {
                    it2 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"combinedConfig");
                    string3 = port2 = HoconApplicationConfigKt.tryGetString(it2, this.$hostPortPath);
                }
                if ((string2 = this.$argsMap.get("-sslPort")) == null) {
                    Config bl2 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"combinedConfig");
                    string2 = sslPort = HoconApplicationConfigKt.tryGetString(bl2, this.$hostSslPortPath);
                }
                if ((string = this.$argsMap.get("-sslKeyStore")) == null) {
                    object = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"combinedConfig");
                    string = HoconApplicationConfigKt.tryGetString((Config)object, this.$hostSslKeyStore);
                }
                String sslKeyStorePath = string;
                Object object3 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"combinedConfig");
                object = HoconApplicationConfigKt.tryGetString((Config)object3, this.$hostSslKeyStorePassword);
                String sslKeyStorePassword = object == null ? null : ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                Config config2 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"combinedConfig");
                object3 = HoconApplicationConfigKt.tryGetString(config2, this.$hostSslPrivateKeyPassword);
                String sslPrivateKeyPassword = object3 == null ? null : ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                Object object4 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"combinedConfig");
                String string5 = HoconApplicationConfigKt.tryGetString((Config)object4, this.$hostSslKeyAlias);
                if (string5 == null) {
                    string5 = "mykey";
                }
                String sslKeyAlias = string5;
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = $this$applicationEngineEnvironment;
                Object object5 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"combinedConfig");
                object4 = HoconApplicationConfigKt.tryGetString((Config)object5, this.$developmentModeKey);
                if (object4 == null) {
                    bl = null;
                } else {
                    Object object6 = object4;
                    list4 = applicationEngineEnvironmentBuilder2;
                    boolean bl3 = false;
                    bl = Boolean.parseBoolean((String)it);
                    applicationEngineEnvironmentBuilder2 = list4;
                }
                config2 = bl;
                applicationEngineEnvironmentBuilder2.setDevelopmentMode(config2 == null ? PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE() : ((Boolean)((Object)config2)).booleanValue());
                if (port2 != null) {
                    void $this$invoke_u24lambda_u2d2;
                    ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                    boolean $i$f$connector = false;
                    it = object5 = new EngineConnectorBuilder(null, 1, null);
                    list4 = $this$connector$iv.getConnectors();
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u2d2.setHost(host2);
                    $this$invoke_u24lambda_u2d2.setPort(Integer.parseInt(port2));
                    list4.add((EngineConnectorConfig)object5);
                }
                if (sslPort != null) {
                    void $this$invoke_u24lambda_u2d7;
                    void keyStorePassword$iv;
                    Object object7;
                    if (sslKeyStorePath == null) {
                        throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                    }
                    if (sslKeyStorePassword == null) {
                        throw new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                    }
                    if (sslPrivateKeyPassword == null) {
                        throw new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                    }
                    Object file2 = new File(sslKeyStorePath);
                    boolean bl5 = false;
                    File keyStoreFile = ((File)file2).exists() || ((File)file2).isAbsolute() ? file2 : new File(".", sslKeyStorePath).getAbsoluteFile();
                    Object $this$invoke_u24lambda_u2d6 = file2 = KeyStore.getInstance("JKS");
                    boolean $i$a$-apply-CommandLineKt$commandLineEnvironment$environment$1$keyStore$22 = false;
                    Closeable closeable = new FileInputStream(keyStoreFile);
                    Object object8 = null;
                    try {
                        FileInputStream it3 = (FileInputStream)closeable;
                        boolean bl6 = false;
                        InputStream inputStream2 = it3;
                        char[] cArray = sslKeyStorePassword.toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                        ((KeyStore)$this$invoke_u24lambda_u2d6).load(inputStream2, cArray);
                        object7 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object8 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object8);
                    }
                    object8 = sslPrivateKeyPassword.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"this as java.lang.String).toCharArray()");
                    if (((KeyStore)$this$invoke_u24lambda_u2d6).getKey(sslKeyAlias, (char[])object8) == null) {
                        boolean $i$a$-requireNotNull-CommandLineKt$commandLineEnvironment$environment$1$keyStore$1$32 = false;
                        String $i$a$-requireNotNull-CommandLineKt$commandLineEnvironment$environment$1$keyStore$1$32 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
                        throw new IllegalArgumentException($i$a$-requireNotNull-CommandLineKt$commandLineEnvironment$environment$1$keyStore$1$32.toString());
                    }
                    Object keyStore = file2;
                    file2 = $this$applicationEngineEnvironment;
                    Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keyStore");
                    $this$invoke_u24lambda_u2d6 = keyStore;
                    Function0 $i$a$-apply-CommandLineKt$commandLineEnvironment$environment$1$keyStore$22 = (Function0)new Function0<char[]>(sslKeyStorePassword){
                        final /* synthetic */ String $sslKeyStorePassword;
                        {
                            this.$sslKeyStorePassword = $sslKeyStorePassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            char[] cArray = this.$sslKeyStorePassword.toCharArray();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    Function0 privateKeyPassword$iv = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
                        final /* synthetic */ String $sslPrivateKeyPassword;
                        {
                            this.$sslPrivateKeyPassword = $sslPrivateKeyPassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            char[] cArray = this.$sslPrivateKeyPassword.toCharArray();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    boolean $i$f$sslConnector = false;
                    Object bl6 = object7 = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
                    list4 = ((ApplicationEngineEnvironmentBuilder)((Object)$this$sslConnector$iv)).getConnectors();
                    boolean bl7 = false;
                    $this$invoke_u24lambda_u2d7.setHost(host2);
                    $this$invoke_u24lambda_u2d7.setPort(Integer.parseInt(sslPort));
                    $this$invoke_u24lambda_u2d7.setKeyStorePath(keyStoreFile);
                    list4.add((EngineConnectorConfig)object7);
                }
                if (port2 == null && sslPort == null) {
                    throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                }
                String string6 = this.$argsMap.get("-watch");
                if (string6 == null) {
                    list3 = null;
                } else {
                    keyStore$iv = new String[]{","};
                    list3 = list2 = StringsKt.split$default((CharSequence)string6, (String[])keyStore$iv, (boolean)false, (int)0, (int)6, null);
                }
                if (list3 == null) {
                    $this$sslConnector$iv = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$sslConnector$iv, (String)"combinedConfig");
                    list2 = HoconApplicationConfigKt.tryGetStringList($this$sslConnector$iv, this.$hostWatchPaths);
                }
                if (list2 != null) {
                    List<String> it4 = list2;
                    boolean bl8 = false;
                    $this$applicationEngineEnvironment.setWatchPaths(it4);
                }
            }
        }));
        return environment2;
    }

    private static final Pair<String, String> splitPair(String $this$splitPair, char ch) {
        int idx = StringsKt.indexOf$default((CharSequence)$this$splitPair, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        return idx == -1 ? null : new Pair((Object)StringsKt.take((String)$this$splitPair, (int)idx), (Object)StringsKt.drop((String)$this$splitPair, (int)(idx + 1)));
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        int it;
        int n;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loadCommonConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deploymentConfig, (String)"deploymentConfig");
        ApplicationConfigValue applicationConfigValue = deploymentConfig.propertyOrNull("callGroupSize");
        if (applicationConfigValue != null && (string = applicationConfigValue.getString()) != null) {
            it = n = Integer.parseInt(string);
            boolean bl = false;
            $this$loadCommonConfiguration.setCallGroupSize(it);
        }
        ApplicationConfigValue applicationConfigValue2 = deploymentConfig.propertyOrNull("connectionGroupSize");
        if (applicationConfigValue2 != null && (string = applicationConfigValue2.getString()) != null) {
            it = n = Integer.parseInt(string);
            boolean bl = false;
            $this$loadCommonConfiguration.setConnectionGroupSize(it);
        }
        ApplicationConfigValue applicationConfigValue3 = deploymentConfig.propertyOrNull("workerGroupSize");
        if (applicationConfigValue3 != null && (string = applicationConfigValue3.getString()) != null) {
            it = n = Integer.parseInt(string);
            boolean bl = false;
            $this$loadCommonConfiguration.setWorkerGroupSize(it);
        }
    }
}

