/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.FrameType;
import io.ktor.http.cio.websocket.WebSocketInternalAPI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocketInternalAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R$\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006R\u001e\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010$0$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/ktor/http/cio/websocket/FrameParser;", "", "()V", "bodyReady", "", "getBodyReady", "()Z", "<set-?>", "fin", "getFin", "frameType", "Lio/ktor/http/cio/websocket/FrameType;", "getFrameType", "()Lio/ktor/http/cio/websocket/FrameType;", "lastOpcode", "", "", "length", "getLength", "()J", "lengthLength", "mask", "getMask", "maskKey", "getMaskKey", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "opcode", "rsv1", "getRsv1", "rsv2", "getRsv2", "rsv3", "getRsv3", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/ktor/http/cio/websocket/FrameParser$State;", "kotlin.jvm.PlatformType", "bodyComplete", "", "frame", "bb", "Ljava/nio/ByteBuffer;", "handleStep", "parseHeader1", "parseLength", "parseMaskKey", "State", "ktor-http-cio"})
public final class FrameParser {
    @NotNull
    private final AtomicReference<State> state = new AtomicReference<State>(State.HEADER0);
    private boolean fin;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;
    private boolean mask;
    private int opcode;
    private int lastOpcode;
    private int lengthLength;
    private long length;
    @Nullable
    private Integer maskKey;

    public final boolean getFin() {
        return this.fin;
    }

    public final boolean getRsv1() {
        return this.rsv1;
    }

    public final boolean getRsv2() {
        return this.rsv2;
    }

    public final boolean getRsv3() {
        return this.rsv3;
    }

    public final boolean getMask() {
        return this.mask;
    }

    public final long getLength() {
        return this.length;
    }

    @Nullable
    public final Integer getMaskKey() {
        return this.maskKey;
    }

    @NotNull
    public final FrameType getFrameType() {
        FrameType frameType = FrameType.Companion.get(this.opcode);
        if (frameType == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unsupported opcode ", (Object)Integer.toHexString(this.opcode)));
        }
        return frameType;
    }

    public final boolean getBodyReady() {
        return this.state.get() == State.BODY;
    }

    public final void bodyComplete() {
        if (!this.state.compareAndSet(State.BODY, State.HEADER0)) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"It should be state BODY but it is ", (Object)((Object)this.state.get())));
        }
        this.opcode = 0;
        this.length = 0L;
        this.lengthLength = 0;
        this.maskKey = null;
    }

    public final void frame(@NotNull ByteBuffer bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        if (!Intrinsics.areEqual((Object)bb.order(), (Object)ByteOrder.BIG_ENDIAN)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Buffer order should be BIG_ENDIAN but it is ", (Object)bb.order());
            throw new IllegalArgumentException(string.toString());
        }
        while (this.handleStep(bb)) {
        }
    }

    private final boolean handleStep(ByteBuffer bb) {
        boolean bl;
        State state = this.state.get();
        Intrinsics.checkNotNull((Object)((Object)state));
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                bl = this.parseHeader1(bb);
                break;
            }
            case 2: {
                bl = this.parseLength(bb);
                break;
            }
            case 3: {
                bl = this.parseMaskKey(bb);
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseHeader1(ByteBuffer bb) {
        int n;
        void new_;
        if (bb.remaining() < 2) {
            return false;
        }
        byte flagsAndOpcode = bb.get();
        byte maskAndLength1 = bb.get();
        this.fin = (flagsAndOpcode & 0x80) != 0;
        this.rsv1 = (flagsAndOpcode & 0x40) != 0;
        this.rsv2 = (flagsAndOpcode & 0x20) != 0;
        this.rsv3 = (flagsAndOpcode & 0x10) != 0;
        int n2 = flagsAndOpcode & 0xF;
        FrameParser frameParser = this;
        boolean bl = false;
        int n3 = new_ == false ? this.lastOpcode : new_;
        frameParser.opcode = n3;
        if (!this.getFrameType().getControlFrame()) {
            this.lastOpcode = this.opcode;
        }
        this.mask = (maskAndLength1 & 0x80) != 0;
        int length1 = maskAndLength1 & 0x7F;
        switch (length1) {
            case 126: {
                n = 2;
                break;
            }
            case 127: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.lengthLength = n;
        this.length = this.lengthLength == 0 ? (long)length1 : 0L;
        if (this.lengthLength > 0) {
            this.state.set(State.LENGTH);
        } else if (this.mask) {
            this.state.set(State.MASK_KEY);
        } else {
            this.state.set(State.BODY);
        }
        return true;
    }

    private final boolean parseLength(ByteBuffer bb) {
        long l;
        if (bb.remaining() < this.lengthLength) {
            return false;
        }
        switch (this.lengthLength) {
            case 2: {
                l = (long)bb.getShort() & 0xFFFFL;
                break;
            }
            case 8: {
                l = bb.getLong();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.length = l;
        State mask = this.mask ? State.MASK_KEY : State.BODY;
        this.state.set(mask);
        return true;
    }

    private final boolean parseMaskKey(ByteBuffer bb) {
        if (bb.remaining() < 4) {
            return false;
        }
        this.maskKey = bb.getInt();
        this.state.set(State.BODY);
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/http/cio/websocket/FrameParser$State;", "", "(Ljava/lang/String;I)V", "HEADER0", "LENGTH", "MASK_KEY", "BODY", "ktor-http-cio"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER0 = new State();
        public static final /* enum */ State LENGTH = new State();
        public static final /* enum */ State MASK_KEY = new State();
        public static final /* enum */ State BODY = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.HEADER0, State.LENGTH, State.MASK_KEY, State.BODY};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.HEADER0.ordinal()] = 1;
            nArray[State.LENGTH.ordinal()] = 2;
            nArray[State.MASK_KEY.ordinal()] = 3;
            nArray[State.BODY.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

