/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0007H\u0002\u001a,\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a$\u0010\u0011\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0013\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0016"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "parseFile", "slashCount", "parseFragment", "parseMailto", "parseQuery", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        String string;
        int it222;
        int n;
        int startIndex;
        int index$iv;
        block20: {
            int n2;
            char it;
            int n3;
            block19: {
                Intrinsics.checkNotNullParameter((Object)$this$takeFromUnsafe, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                int n4 = 0;
                n3 = $this$indexOfFirst$iv.length();
                while (n4 < n3) {
                    index$iv = n4++;
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    n2 = index$iv;
                    break block19;
                }
                n2 = -1;
            }
            startIndex = n2;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    index$iv = n3--;
                    it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    n = index$iv;
                    break block20;
                } while (0 <= n3);
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String string2 = urlString;
            index$iv = startIndex + schemeLength;
            String string3 = string2.substring(startIndex, index$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String scheme2 = string3;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme2));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            if (!(slashCount == 0)) {
                String index$iv2 = "Failed requirement.";
                throw new IllegalArgumentException(index$iv2.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                Object object = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray("@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                it222 = ((Number)object).intValue();
                boolean bl2 = false;
                Object object2 = it222 > 0 ? object : null;
                int n5 = delimiter = object2 == null ? endIndex : (Integer)object2;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    String it222 = urlString.substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)it222, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(it222, 0, 0, null, 7, null));
                    object = urlString;
                    int it222 = passwordIndex + 1;
                    String bl2 = ((String)object).substring(it222, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setPassword(CodecsKt.decodeURLPart$default(bl2, 0, 0, null, 7, null));
                } else {
                    String it222 = urlString.substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)it222, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(it222, 0, 0, null, 7, null));
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPath(urlString.charAt(endIndex - 1) == '/' ? "/" : "");
            return $this$takeFromUnsafe;
        }
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$this$takeFromUnsafe.getEncodedPath(), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIndex != $this$takeFromUnsafe.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String passwordIndex = $this$takeFromUnsafe.getEncodedPath();
                    int n6 = 0;
                    it222 = lastSlashIndex + 1;
                    String bl2 = passwordIndex.substring(n6, it222);
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string = bl2;
                } else {
                    string = "/";
                }
            } else {
                string = $this$takeFromUnsafe.getEncodedPath();
            }
        } else {
            string = "";
        }
        $this$takeFromUnsafe.setEncodedPath(string);
        Integer n7 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray("?#"), (int)startIndex, (boolean)false, (int)4, null);
        it222 = ((Number)n7).intValue();
        boolean bl = false;
        Integer n8 = it222 > 0 ? n7 : null;
        int pathEnd = n8 == null ? endIndex : n8;
        String string4 = urlString.substring(startIndex, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String rawPath = string4;
        $this$takeFromUnsafe.setEncodedPath(Intrinsics.stringPlus((String)$this$takeFromUnsafe.getEncodedPath(), (Object)CodecsKt.encodeURLPath(rawPath)));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        switch (slashCount) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$parseFile.setHost(string);
                    return;
                }
                String string = urlString.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setHost(string);
                string = urlString.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(string);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                String string = urlString.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(Intrinsics.stringPlus((String)"/", (Object)string));
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid file url: ", (Object)urlString));
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        String string2 = urlString;
        int n = delimiter + 1;
        String string3 = string2.substring(n, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setHost(string3);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int fragmentStart = n2 == null ? endIndex : n2;
        ParametersBuilder parametersBuilder = $this$parseQuery.getParameters();
        String string = urlString;
        int n3 = startIndex + 1;
        String string2 = string.substring(n3, fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        QueryKt.parseQueryStringTo$default(parametersBuilder, string2, 0, 0, 12, null);
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString;
            int n = startIndex + 1;
            String string2 = string.substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$parseFragment.setFragment(string2);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        Object object = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object object2 = it > 0 ? object : null;
        int colonIndex = object2 == null ? endIndex : (Integer)object2;
        object = urlString.substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$fillHost.setHost((String)object);
        if (colonIndex + 1 < endIndex) {
            String string = urlString;
            int n = colonIndex + 1;
            String string2 = string.substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$fillHost.setPort(Integer.parseInt(string2));
        } else {
            $this$fillHost.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar < '{' : false)) {
            if (!('A' <= firstChar ? firstChar < '[' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal character in scheme at position ", (Object)incorrectSchemePosition));
                }
                return current - startIndex;
            }
            if (c == '/' || c == '?' || c == '#') {
                return -1;
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c < '{' : false)) {
                    if (!('A' <= c ? c < '[' : false)) {
                        if (!('0' <= c ? c < ':' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result2 = 0;
        while (startIndex + result2 < endIndex && urlString.charAt(startIndex + result2) == c) {
            int n = result2;
            result2 = n + 1;
        }
        return result2;
    }

    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        while (n < endIndex) {
            int index;
            char c;
            if ((c = $this$indexOfColonInHostPort.charAt(index = n++)) == '[') {
                skip = true;
                continue;
            }
            if (c == ']') {
                skip = false;
                continue;
            }
            if (c != ':' || skip) continue;
            return index;
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = Character.toLowerCase($this$isLetter);
        return 'a' <= c ? c < '{' : false;
    }
}

