/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.URLDecodeException;
import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0017H\u0002\u001a8\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$j\u0002`%H\u0002\u001a0\u0010&\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$j\u0002`%H\u0002\u001a,\u0010'\u001a\u00020\u001c*\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u00172\f\b\u0002\u0010#\u001a\u00060$j\u0002`%\u001a6\u0010(\u001a\u00020\u001c*\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\"2\f\b\u0002\u0010#\u001a\u00060$j\u0002`%\u001a\n\u0010)\u001a\u00020\u001c*\u00020\u001c\u001a\u0014\u0010*\u001a\u00020\u001c*\u00020\u001c2\b\b\u0002\u0010+\u001a\u00020\"\u001a\f\u0010,\u001a\u00020\u001c*\u00020\u001cH\u0000\u001a\n\u0010-\u001a\u00020\u001c*\u00020\u001c\u001a,\u0010.\u001a\u00020\u001c*\u00020\u001c2\b\b\u0002\u0010/\u001a\u00020\"2\b\b\u0002\u0010+\u001a\u00020\"2\f\b\u0002\u0010#\u001a\u00060$j\u0002`%\u001a \u00100\u001a\u000201*\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020104H\u0002\u001a\f\u00105\u001a\u00020\u001c*\u00020\nH\u0002\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0004\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\"\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0004\"\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0004\"\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0004\"\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0004\u00a8\u00066"}, d2={"HEX_ALPHABET", "", "", "getHEX_ALPHABET$annotations", "()V", "LETTERS_AND_NUMBERS", "", "getLETTERS_AND_NUMBERS", "()Ljava/util/Set;", "OAUTH_SYMBOLS", "", "getOAUTH_SYMBOLS$annotations", "TOKENS", "getTOKENS", "URL_ALPHABET", "getURL_ALPHABET$annotations", "URL_ALPHABET_CHARS", "getURL_ALPHABET_CHARS$annotations", "URL_PROTOCOL_PART", "getURL_PROTOCOL_PART$annotations", "VALID_PATH_PART", "getVALID_PATH_PART$annotations", "charToHexDigit", "", "c2", "hexDigitToChar", "digit", "decodeImpl", "", "", "start", "end", "prefixEnd", "plusIsSpace", "", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "decodeScan", "decodeURLPart", "decodeURLQueryComponent", "encodeOAuth", "encodeURLParameter", "spaceToPlus", "encodeURLParameterValue", "encodeURLPath", "encodeURLQueryComponent", "encodeFull", "forEach", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "block", "Lkotlin/Function1;", "percentEncode", "ktor-http"})
public final class CodecsKt {
    @NotNull
    private static final List<Byte> URL_ALPHABET;
    @NotNull
    private static final List<Character> URL_ALPHABET_CHARS;
    @NotNull
    private static final List<Character> HEX_ALPHABET;
    @NotNull
    private static final List<Byte> URL_PROTOCOL_PART;
    @NotNull
    private static final List<Character> VALID_PATH_PART;
    @NotNull
    private static final List<Byte> OAUTH_SYMBOLS;
    @NotNull
    private static final Set<Character> LETTERS_AND_NUMBERS;
    @NotNull
    private static final Set<Character> TOKENS;

    private static /* synthetic */ void getURL_ALPHABET$annotations() {
    }

    private static /* synthetic */ void getURL_ALPHABET_CHARS$annotations() {
    }

    private static /* synthetic */ void getHEX_ALPHABET$annotations() {
    }

    private static /* synthetic */ void getURL_PROTOCOL_PART$annotations() {
    }

    private static /* synthetic */ void getVALID_PATH_PART$annotations() {
    }

    private static /* synthetic */ void getOAUTH_SYMBOLS$annotations() {
    }

    @NotNull
    public static final Set<Character> getLETTERS_AND_NUMBERS() {
        return LETTERS_AND_NUMBERS;
    }

    @NotNull
    public static final Set<Character> getTOKENS() {
        return TOKENS;
    }

    @NotNull
    public static final String encodeURLQueryComponent(@NotNull String $this$encodeURLQueryComponent, boolean encodeFull, boolean spaceToPlus, @NotNull Charset charset) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLQueryComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuilder $this$encodeURLQueryComponent_u24lambda_u2d3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
        ByteReadPacket content2 = EncodingKt.encode$default(charsetEncoder, $this$encodeURLQueryComponent, 0, 0, 6, null);
        CodecsKt.forEach(content2, (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(spaceToPlus, $this$encodeURLQueryComponent_u24lambda_u2d3, encodeFull){
            final /* synthetic */ boolean $spaceToPlus;
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ boolean $encodeFull;
            {
                this.$spaceToPlus = $spaceToPlus;
                this.$this_buildString = $receiver;
                this.$encodeFull = $encodeFull;
                super(1);
            }

            public final void invoke(byte it) {
                if (it == 32) {
                    if (this.$spaceToPlus) {
                        this.$this_buildString.append('+');
                    } else {
                        this.$this_buildString.append("%20");
                    }
                } else if (CodecsKt.access$getURL_ALPHABET$p().contains(it) || !this.$encodeFull && CodecsKt.access$getURL_PROTOCOL_PART$p().contains(it)) {
                    this.$this_buildString.append((char)it);
                } else {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }
        }));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String encodeURLQueryComponent$default(String string, boolean bl, boolean bl2, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.encodeURLQueryComponent(string, bl, bl2, charset);
    }

    @NotNull
    public static final String encodeURLPath(@NotNull String $this$encodeURLPath) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLPath, (String)"<this>");
        StringBuilder $this$encodeURLPath_u24lambda_u2d4 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        int index = 0;
        while (index < $this$encodeURLPath.length()) {
            char current = $this$encodeURLPath.charAt(index);
            if (current == '/' || URL_ALPHABET_CHARS.contains(Character.valueOf(current)) || VALID_PATH_PART.contains(Character.valueOf(current))) {
                $this$encodeURLPath_u24lambda_u2d4.append(current);
                int n = index;
                index = n + 1;
                continue;
            }
            if (current == '%' && index + 2 < $this$encodeURLPath.length() && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index + 1))) && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index + 2)))) {
                $this$encodeURLPath_u24lambda_u2d4.append(current);
                $this$encodeURLPath_u24lambda_u2d4.append($this$encodeURLPath.charAt(index + 1));
                $this$encodeURLPath_u24lambda_u2d4.append($this$encodeURLPath.charAt(index + 2));
                index += 3;
                continue;
            }
            int symbolSize = CharsKt.isSurrogate((char)current) ? 2 : 1;
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            CodecsKt.forEach(EncodingKt.encode(charsetEncoder, $this$encodeURLPath, index, index + symbolSize), (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>($this$encodeURLPath_u24lambda_u2d4){
                final /* synthetic */ StringBuilder $this_buildString;
                {
                    this.$this_buildString = $receiver;
                    super(1);
                }

                public final void invoke(byte it) {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }));
            index += symbolSize;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String encodeOAuth(@NotNull String $this$encodeOAuth) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeOAuth, (String)"<this>");
        return CodecsKt.encodeURLParameter$default($this$encodeOAuth, false, 1, null);
    }

    @NotNull
    public static final String encodeURLParameter(@NotNull String $this$encodeURLParameter, boolean spaceToPlus) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLParameter, (String)"<this>");
        StringBuilder $this$encodeURLParameter_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = Charsets.UTF_8.newEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"UTF_8.newEncoder()");
        ByteReadPacket content2 = EncodingKt.encode$default(charsetEncoder, $this$encodeURLParameter, 0, 0, 6, null);
        CodecsKt.forEach(content2, (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>($this$encodeURLParameter_u24lambda_u2d5, spaceToPlus){
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ boolean $spaceToPlus;
            {
                this.$this_buildString = $receiver;
                this.$spaceToPlus = $spaceToPlus;
                super(1);
            }

            public final void invoke(byte it) {
                if (CodecsKt.access$getURL_ALPHABET$p().contains(it) || CodecsKt.access$getOAUTH_SYMBOLS$p().contains(it)) {
                    this.$this_buildString.append((char)it);
                } else if (this.$spaceToPlus && it == 32) {
                    this.$this_buildString.append('+');
                } else {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }
        }));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String encodeURLParameter$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CodecsKt.encodeURLParameter(string, bl);
    }

    @NotNull
    public static final String encodeURLParameterValue(@NotNull String $this$encodeURLParameterValue) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLParameterValue, (String)"<this>");
        return CodecsKt.encodeURLParameter($this$encodeURLParameterValue, true);
    }

    @NotNull
    public static final String decodeURLQueryComponent(@NotNull String $this$decodeURLQueryComponent, int start2, int end2, boolean plusIsSpace, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeURLQueryComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CodecsKt.decodeScan($this$decodeURLQueryComponent, start2, end2, plusIsSpace, charset);
    }

    public static /* synthetic */ String decodeURLQueryComponent$default(String string, int n, int n2, boolean bl, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLQueryComponent(string, n, n2, bl, charset);
    }

    @NotNull
    public static final String decodeURLPart(@NotNull String $this$decodeURLPart, int start2, int end2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeURLPart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CodecsKt.decodeScan($this$decodeURLPart, start2, end2, false, charset);
    }

    public static /* synthetic */ String decodeURLPart$default(String string, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLPart(string, n, n2, charset);
    }

    private static final String decodeScan(String $this$decodeScan, int start2, int end2, boolean plusIsSpace, Charset charset) {
        String string;
        int n = start2;
        while (n < end2) {
            int index;
            char ch;
            if ((ch = $this$decodeScan.charAt(index = n++)) != '%' && (!plusIsSpace || ch != '+')) continue;
            return CodecsKt.decodeImpl($this$decodeScan, start2, end2, index, plusIsSpace, charset);
        }
        if (start2 == 0 && end2 == $this$decodeScan.length()) {
            string = $this$decodeScan.toString();
        } else {
            String string2 = $this$decodeScan.substring(start2, end2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string2;
        }
        return string;
    }

    private static final String decodeImpl(CharSequence $this$decodeImpl, int start2, int end2, int prefixEnd, boolean plusIsSpace, Charset charset) {
        int length = end2 - start2;
        int sbSize = length > 255 ? length / 3 : length;
        StringBuilder sb = new StringBuilder(sbSize);
        if (prefixEnd > start2) {
            sb.append($this$decodeImpl, start2, prefixEnd);
        }
        int index = prefixEnd;
        byte[] bytes = null;
        while (index < end2) {
            int n;
            char c = $this$decodeImpl.charAt(index);
            if (plusIsSpace && c == '+') {
                sb.append(' ');
                n = index;
                index = n + 1;
                continue;
            }
            if (c == '%') {
                if (bytes == null) {
                    bytes = new byte[(end2 - index) / 3];
                }
                int count = 0;
                while (index < end2 && $this$decodeImpl.charAt(index) == '%') {
                    if (index + 2 >= end2) {
                        CharSequence charSequence = $this$decodeImpl;
                        int n2 = charSequence.length();
                        throw new URLDecodeException("Incomplete trailing HEX escape: " + ((Object)charSequence.subSequence(index, n2)).toString() + ", in " + $this$decodeImpl + " at " + index);
                    }
                    int digit1 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index + 1));
                    int digit2 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index + 2));
                    if (digit1 == -1 || digit2 == -1) {
                        throw new URLDecodeException("Wrong HEX escape: %" + $this$decodeImpl.charAt(index + 1) + $this$decodeImpl.charAt(index + 2) + ", in " + $this$decodeImpl + ", at " + index);
                    }
                    int n3 = count;
                    count = n3 + 1;
                    bytes[n3] = (byte)(digit1 * 16 + digit2);
                    index += 3;
                }
                int offset$iv = 0;
                boolean $i$f$String = false;
                sb.append(new String(bytes, offset$iv, count, charset));
                continue;
            }
            sb.append(c);
            n = index;
            index = n + 1;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final String percentEncode(byte $this$percentEncode) {
        StringBuilder stringBuilder;
        int n = 3;
        StringBuilder $this$percentEncode_u24lambda_u2d6 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int code = $this$percentEncode & 0xFF;
        $this$percentEncode_u24lambda_u2d6.append('%');
        $this$percentEncode_u24lambda_u2d6.append(CodecsKt.hexDigitToChar(code >> 4));
        $this$percentEncode_u24lambda_u2d6.append(CodecsKt.hexDigitToChar(code & 0xF));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    private static final int charToHexDigit(char c2) {
        int n;
        block1: {
            char c;
            block0: {
                c = c2;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = c2 - 48;
                break block1;
            }
            n = ('A' <= c ? c < 'G' : false) ? c2 - 65 + 10 : (('a' <= c ? c < 'g' : false) ? c2 - 97 + 10 : -1);
        }
        return n;
    }

    private static final char hexDigitToChar(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? (char)(48 + digit) : (char)((char)(65 + digit) - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void forEach(ByteReadPacket $this$forEach, Function1<? super Byte, Unit> block2) {
        Input $this$takeWhile$iv = $this$forEach;
        boolean $i$f$takeWhile = false;
        boolean release$iv = true;
        ChunkBuffer chunkBuffer = UnsafeKt.prepareReadFirstHead($this$takeWhile$iv, 1);
        if (chunkBuffer != null) {
            ChunkBuffer current$iv = chunkBuffer;
            try {
                while (true) {
                    ChunkBuffer next$iv;
                    Buffer buffer = current$iv;
                    boolean bl = false;
                    while (true) {
                        Buffer $this$canRead$iv = buffer;
                        boolean $i$f$canRead = false;
                        if (!($this$canRead$iv.getWritePosition() > $this$canRead$iv.getReadPosition())) break;
                        block2.invoke((Object)buffer.readByte());
                    }
                    if (!true) {
                        break;
                    }
                    release$iv = false;
                    if (UnsafeKt.prepareReadNextHead($this$takeWhile$iv, current$iv) == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                }
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhile$iv, current$iv);
                }
            }
        }
    }

    public static final /* synthetic */ List access$getURL_ALPHABET$p() {
        return URL_ALPHABET;
    }

    public static final /* synthetic */ List access$getURL_PROTOCOL_PART$p() {
        return URL_PROTOCOL_PART;
    }

    public static final /* synthetic */ String access$percentEncode(byte $receiver) {
        return CodecsKt.percentEncode($receiver);
    }

    public static final /* synthetic */ List access$getOAUTH_SYMBOLS$p() {
        return OAUTH_SYMBOLS;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        char it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = (Object[])CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            char c = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_ALPHABET = (List)destination$iv$iv;
        URL_ALPHABET_CHARS = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        HEX_ALPHABET = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'f')), (Iterable)((Iterable)new CharRange('A', 'F'))), (Iterable)((Iterable)new CharRange('0', '9')));
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+')};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_PROTOCOL_PART = (List)destination$iv$iv;
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        VALID_PATH_PART = CollectionsKt.listOf((Object[])$this$map$iv);
        $this$map$iv = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        OAUTH_SYMBOLS = (List)var3_3;
        LETTERS_AND_NUMBERS = SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z')))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9'))));
        Object[] objectArray2 = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        TOKENS = SetsKt.plus((Set)SetsKt.setOf((Object[])objectArray2), (Iterable)LETTERS_AND_NUMBERS);
    }
}

