/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.Application;
import io.ktor.application.ApplicationCall;
import io.ktor.application.ApplicationCallPipeline;
import io.ktor.application.ApplicationEvents;
import io.ktor.application.ApplicationFeature;
import io.ktor.application.ApplicationFeatureKt;
import io.ktor.application.ApplicationKt;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.features.CallLogging;
import io.ktor.features.MDCSurvivalElement;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.InternalAPI;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.event.Level;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0004 !\"#B[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0018\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J!\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001fR \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/ktor/features/CallLogging;", "", "log", "Lorg/slf4j/Logger;", "monitor", "Lio/ktor/application/ApplicationEvents;", "level", "Lorg/slf4j/event/Level;", "filters", "", "Lkotlin/Function1;", "Lio/ktor/application/ApplicationCall;", "", "mdcEntries", "Lio/ktor/features/CallLogging$MDCEntry;", "formatCall", "", "(Lorg/slf4j/Logger;Lio/ktor/application/ApplicationEvents;Lorg/slf4j/event/Level;Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "started", "Lio/ktor/application/Application;", "", "starting", "stopped", "stopping", "cleanupMdc", "cleanupMdc$ktor_server_core", "message", "logSuccess", "call", "setupMdc", "", "setupMdc$ktor_server_core", "Configuration", "Feature", "Internals", "MDCEntry", "ktor-server-core"})
public final class CallLogging {
    @NotNull
    public static final Feature Feature = new Feature(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final ApplicationEvents monitor;
    @NotNull
    private final Level level;
    @NotNull
    private final List<Function1<ApplicationCall, Boolean>> filters;
    @NotNull
    private final List<MDCEntry> mdcEntries;
    @NotNull
    private final Function1<ApplicationCall, String> formatCall;
    @NotNull
    private final Function1<Application, Unit> starting;
    @NotNull
    private final Function1<Application, Unit> started;
    @NotNull
    private final Function1<Application, Unit> stopping;
    @NotNull
    private Function1<? super Application, Unit> stopped;
    @NotNull
    private static final AttributeKey<CallLogging> key = new AttributeKey("Call Logging");

    private CallLogging(Logger log, ApplicationEvents monitor, Level level, List<? extends Function1<? super ApplicationCall, Boolean>> filters, List<MDCEntry> mdcEntries, Function1<? super ApplicationCall, String> formatCall2) {
        this.log = log;
        this.monitor = monitor;
        this.level = level;
        this.filters = filters;
        this.mdcEntries = mdcEntries;
        this.formatCall = formatCall2;
        this.starting = (Function1)new Function1<Application, Unit>(this){
            final /* synthetic */ CallLogging this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CallLogging.access$log(this.this$0, Intrinsics.stringPlus((String)"Application starting: ", (Object)it));
            }
        };
        this.started = (Function1)new Function1<Application, Unit>(this){
            final /* synthetic */ CallLogging this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CallLogging.access$log(this.this$0, Intrinsics.stringPlus((String)"Application started: ", (Object)it));
            }
        };
        this.stopping = (Function1)new Function1<Application, Unit>(this){
            final /* synthetic */ CallLogging this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CallLogging.access$log(this.this$0, Intrinsics.stringPlus((String)"Application stopping: ", (Object)it));
            }
        };
        this.stopped = stopped.1.INSTANCE;
        this.stopped = (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.log(Intrinsics.stringPlus((String)"Application stopped: ", (Object)it));
                monitor.unsubscribe(DefaultApplicationEventsKt.getApplicationStarting(), starting);
                monitor.unsubscribe(DefaultApplicationEventsKt.getApplicationStarted(), started);
                monitor.unsubscribe(DefaultApplicationEventsKt.getApplicationStopping(), stopping);
                monitor.unsubscribe(DefaultApplicationEventsKt.getApplicationStopped(), stopped);
            }
        };
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarting(), this.starting);
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarted(), this.started);
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStopping(), this.stopping);
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStopped(), this.stopped);
    }

    @NotNull
    public final Map<String, String> setupMdc$ktor_server_core(@NotNull ApplicationCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        HashMap result2 = new HashMap();
        Iterable $this$forEach$iv = this.mdcEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String mdcValue;
            MDCEntry entry = (MDCEntry)element$iv;
            boolean bl = false;
            if ((String)entry.getProvider().invoke((Object)call2) == null) continue;
            boolean bl2 = false;
            Map map2 = result2;
            String string = entry.getName();
            map2.put(string, mdcValue);
        }
        return result2;
    }

    public final void cleanupMdc$ktor_server_core() {
        Iterable $this$forEach$iv = this.mdcEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MDCEntry it = (MDCEntry)element$iv;
            boolean bl = false;
            MDC.remove((String)it.getName());
        }
    }

    private final void log(String message2) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
            case 1: {
                this.log.error(message2);
                break;
            }
            case 2: {
                this.log.warn(message2);
                break;
            }
            case 3: {
                this.log.info(message2);
                break;
            }
            case 4: {
                this.log.debug(message2);
                break;
            }
            case 5: {
                this.log.trace(message2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void logSuccess(ApplicationCall call2) {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    if (this.filters.isEmpty()) break block8;
                    Iterable $this$any$iv = this.filters;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Function1 it = (Function1)element$iv;
                            boolean bl2 = false;
                            if (!((Boolean)it.invoke((Object)call2)).booleanValue()) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            this.log((String)this.formatCall.invoke((Object)call2));
        }
    }

    public /* synthetic */ CallLogging(Logger log, ApplicationEvents monitor, Level level, List filters, List mdcEntries, Function1 formatCall2, DefaultConstructorMarker $constructor_marker) {
        this(log, monitor, level, filters, mdcEntries, (Function1<? super ApplicationCall, String>)formatCall2);
    }

    public static final /* synthetic */ void access$logSuccess(CallLogging $this, ApplicationCall call2) {
        $this.logSuccess(call2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/features/CallLogging$MDCEntry;", "", "name", "", "provider", "Lkotlin/Function1;", "Lio/ktor/application/ApplicationCall;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getProvider", "()Lkotlin/jvm/functions/Function1;", "ktor-server-core"})
    public static final class MDCEntry {
        @NotNull
        private final String name;
        @NotNull
        private final Function1<ApplicationCall, String> provider;

        public MDCEntry(@NotNull String name, @NotNull Function1<? super ApplicationCall, String> provider2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            this.name = name;
            this.provider = provider2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Function1<ApplicationCall, String> getProvider() {
            return this.provider;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0006\u0010,\u001a\u00020-J\u001a\u0010.\u001a\u00020-2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u001a\u00100\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005J$\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u000b2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0005J\u0011\u00105\u001a\u00020\u000b*\u000206H\u0000\u00a2\u0006\u0002\b7R&\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\t\u00a8\u00068"}, d2={"Lio/ktor/features/CallLogging$Configuration;", "", "()V", "filters", "", "Lkotlin/Function1;", "Lio/ktor/application/ApplicationCall;", "", "getFilters$ktor_server_core", "()Ljava/util/List;", "formatCall", "", "getFormatCall$ktor_server_core", "()Lkotlin/jvm/functions/Function1;", "setFormatCall$ktor_server_core", "(Lkotlin/jvm/functions/Function1;)V", "isColorsEnabled", "isColorsEnabled$ktor_server_core", "()Z", "setColorsEnabled$ktor_server_core", "(Z)V", "level", "Lorg/slf4j/event/Level;", "getLevel", "()Lorg/slf4j/event/Level;", "setLevel", "(Lorg/slf4j/event/Level;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "mdcEntries", "Lio/ktor/features/CallLogging$MDCEntry;", "getMdcEntries$ktor_server_core", "colored", "status", "Lio/ktor/http/HttpStatusCode;", "value", "color", "Lorg/fusesource/jansi/Ansi$Color;", "defaultFormat", "call", "disableDefaultColors", "", "filter", "predicate", "format", "formatter", "mdc", "name", "provider", "toLogStringWithColors", "Lio/ktor/request/ApplicationRequest;", "toLogStringWithColors$ktor_server_core", "ktor-server-core"})
    public static final class Configuration {
        @NotNull
        private final List<Function1<ApplicationCall, Boolean>> filters = new ArrayList();
        @NotNull
        private final List<MDCEntry> mdcEntries = new ArrayList();
        @NotNull
        private Function1<? super ApplicationCall, String> formatCall = (Function1)new Function1<ApplicationCall, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull ApplicationCall p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Configuration.access$defaultFormat((Configuration)this.receiver, p0);
            }
        };
        private boolean isColorsEnabled = true;
        @NotNull
        private Level level = Level.INFO;
        @Nullable
        private Logger logger;

        @NotNull
        public final List<Function1<ApplicationCall, Boolean>> getFilters$ktor_server_core() {
            return this.filters;
        }

        @NotNull
        public final List<MDCEntry> getMdcEntries$ktor_server_core() {
            return this.mdcEntries;
        }

        @NotNull
        public final Function1<ApplicationCall, String> getFormatCall$ktor_server_core() {
            return this.formatCall;
        }

        public final void setFormatCall$ktor_server_core(@NotNull Function1<? super ApplicationCall, String> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.formatCall = function1;
        }

        public final boolean isColorsEnabled$ktor_server_core() {
            return this.isColorsEnabled;
        }

        public final void setColorsEnabled$ktor_server_core(boolean bl) {
            this.isColorsEnabled = bl;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        public final void setLevel(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"<set-?>");
            this.level = level;
        }

        @Nullable
        public final Logger getLogger() {
            return this.logger;
        }

        public final void setLogger(@Nullable Logger logger2) {
            this.logger = logger2;
        }

        public final void filter(@NotNull Function1<? super ApplicationCall, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            this.filters.add(predicate);
        }

        public final void mdc(@NotNull String name, @NotNull Function1<? super ApplicationCall, String> provider2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            this.mdcEntries.add(new MDCEntry(name, provider2));
        }

        public final void format(@NotNull Function1<? super ApplicationCall, String> formatter) {
            Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
            this.formatCall = formatter;
        }

        public final void disableDefaultColors() {
            this.isColorsEnabled = false;
        }

        private final String defaultFormat(ApplicationCall call2) {
            HttpStatusCode status;
            Object object = call2.getResponse().status();
            if (object == null) {
                object = "Unhandled";
            }
            return Intrinsics.areEqual((Object)(status = object), (Object)HttpStatusCode.Companion.getFound()) ? this.colored(status) + ": " + this.toLogStringWithColors$ktor_server_core(call2.getRequest()) + " -> " + call2.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getLocation()) : (Intrinsics.areEqual((Object)status, (Object)"Unhandled") ? this.colored(status, Ansi.Color.RED) + ": " + this.toLogStringWithColors$ktor_server_core(call2.getRequest()) : this.colored(status) + ": " + this.toLogStringWithColors$ktor_server_core(call2.getRequest()));
        }

        @NotNull
        public final String toLogStringWithColors$ktor_server_core(@NotNull ApplicationRequest $this$toLogStringWithColors) {
            Intrinsics.checkNotNullParameter((Object)$this$toLogStringWithColors, (String)"<this>");
            return this.colored(ApplicationRequestPropertiesKt.getHttpMethod($this$toLogStringWithColors).getValue(), Ansi.Color.CYAN) + " - " + ApplicationRequestPropertiesKt.path($this$toLogStringWithColors);
        }

        private final String colored(HttpStatusCode status) {
            HttpStatusCode httpStatusCode;
            try {
                if (!AnsiConsole.isInstalled()) {
                    AnsiConsole.systemInstall();
                }
            }
            catch (Throwable cause) {
                this.isColorsEnabled = false;
            }
            return (((Intrinsics.areEqual((Object)(httpStatusCode = status), (Object)HttpStatusCode.Companion.getFound()) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getOK())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getAccepted())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getCreated())) ? this.colored(status, Ansi.Color.GREEN) : (((((((Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getContinue()) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getProcessing())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getPartialContent())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getNotModified())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getUseProxy())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getUpgradeRequired())) ? true : Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getNoContent())) ? this.colored(status, Ansi.Color.YELLOW) : this.colored(status, Ansi.Color.RED));
        }

        private final String colored(Object value, Ansi.Color color) {
            String string;
            if (this.isColorsEnabled) {
                String string2 = Ansi.ansi().fg(color).a(value).reset().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ansi().fg(color).a(value).reset().toString()");
                string = string2;
            } else {
                string = value.toString();
            }
            return string;
        }

        public static final /* synthetic */ String access$defaultFormat(Configuration $this, ApplicationCall call2) {
            return $this.defaultFormat(call2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J)\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00022\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000fH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/ktor/features/CallLogging$Feature;", "Lio/ktor/application/ApplicationFeature;", "Lio/ktor/application/Application;", "Lio/ktor/features/CallLogging$Configuration;", "Lio/ktor/features/CallLogging;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "install", "pipeline", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ktor-server-core"})
    public static final class Feature
    implements ApplicationFeature<Application, Configuration, CallLogging> {
        private Feature() {
        }

        @Override
        @NotNull
        public AttributeKey<CallLogging> getKey() {
            return key;
        }

        @Override
        @NotNull
        public CallLogging install(@NotNull Application pipeline, @NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            PipelinePhase loggingPhase = new PipelinePhase("Logging");
            Configuration configuration = new Configuration();
            configure.invoke((Object)configuration);
            Configuration configuration2 = configuration;
            Logger logger2 = configuration2.getLogger();
            if (logger2 == null) {
                logger2 = ApplicationKt.getLog(pipeline);
            }
            CallLogging feature = new CallLogging(logger2, pipeline.getEnvironment().getMonitor(), configuration2.getLevel(), CollectionsKt.toList((Iterable)configuration2.getFilters$ktor_server_core()), CollectionsKt.toList((Iterable)configuration2.getMdcEntries$ktor_server_core()), configuration2.getFormatCall$ktor_server_core(), null);
            pipeline.insertPhaseBefore(ApplicationCallPipeline.ApplicationPhase.getMonitoring(), loggingPhase);
            if (!((Collection)feature.mdcEntries).isEmpty()) {
                pipeline.intercept(loggingPhase, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(feature, null){
                    Object L$1;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ CallLogging $feature;
                    {
                        this.$feature = $feature;
                        super(3, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                                $i$f$getCall = false;
                                call$iv = (ApplicationCall)$this$call$iv.getContext();
                                var4_6 = this.$feature;
                                $i$f$withMDC = false;
                                v0 = (CallLogging)ApplicationFeatureKt.featureOrNull((Pipeline)call$iv.getApplication(), CallLogging.Feature);
                                if (v0 != null) break;
                                (Continuation)this;
                                $i$a$-withMDC-CallLogging$Feature$install$1$1 = false;
                                this.L$0 = $this$intercept;
                                this.L$1 = var4_6;
                                this.label = 1;
                                v1 = $this$intercept.proceed(this);
                                if (v1 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl29
                            }
                            case 1: {
                                $i$f$withMDC = false;
                                $i$a$-withMDC-CallLogging$Feature$install$1$1 = false;
                                var4_6 = (CallLogging)this.L$1;
                                $this$intercept = (PipelineContext)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl29:
                                // 2 sources

                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                CallLogging.access$logSuccess(var4_6, (ApplicationCall)$this$call$iv.getContext());
                                ** GOTO lbl44
                            }
                        }
                        feature$iv = v0;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)new MDCSurvivalElement(feature$iv.setupMdc$ktor_server_core(call$iv))), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(feature$iv, null, $this$intercept, var4_6){
                            int label;
                            final /* synthetic */ CallLogging $feature;
                            final /* synthetic */ PipelineContext $$this$intercept$inlined;
                            final /* synthetic */ CallLogging $feature$inlined;
                            {
                                this.$feature = $feature;
                                this.$$this$intercept$inlined = pipelineContext;
                                this.$feature$inlined = callLogging;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        (Continuation)this;
                                        $i$a$-withMDC-CallLogging$Feature$install$1$1 = false;
                                        this.label = 1;
                                        v0 = this.$$this$intercept$inlined.proceed(this);
                                        ** if (v0 != var2_2) goto lbl14
lbl13:
                                        // 1 sources

                                        return var2_2;
lbl14:
                                        // 1 sources

                                        ** GOTO lbl21
                                    }
                                    case 1: {
                                        $i$a$-withMDC-CallLogging$Feature$install$1$1 = false;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl21:
                                            // 2 sources

                                            $this$call$iv = this.$$this$intercept$inlined;
                                            $i$f$getCall = false;
                                            CallLogging.access$logSuccess(this.$feature$inlined, (ApplicationCall)$this$call$iv.getContext());
                                        }
                                        catch (Throwable var3_7) {
                                            throw var3_7;
                                        }
                                        finally {
                                            this.$feature.cleanupMdc$ktor_server_core();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl44
                        {
                            case 2: {
                                $i$f$withMDC = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl44:
                                // 3 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                        Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p1;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                });
            } else {
                pipeline.intercept(loggingPhase, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(feature, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ CallLogging $feature;
                    {
                        this.$feature = $feature;
                        super(3, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$intercept = (PipelineContext)this.L$0;
                                this.L$0 = $this$intercept;
                                this.label = 1;
                                v0 = $this$intercept.proceed((Continuation)this);
                                if (v0 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                $this$intercept = (PipelineContext)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                CallLogging.access$logSuccess(this.$feature, (ApplicationCall)$this$call$iv.getContext());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                        Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p1;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                });
            }
            return feature;
        }

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @InternalAPI
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001c\u0010\u0007\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJR\u0010\u0003\u001a\u00020\u0004\"\u0012\b\u0000\u0010\u000b*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00060\f*\u0002H\u000b2'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u0002H\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r\u00a2\u0006\u0002\b\u000eH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lio/ktor/features/CallLogging$Internals;", "", "()V", "withMDCBlock", "", "call", "Lio/ktor/application/ApplicationCall;", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lio/ktor/application/ApplicationCall;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "C", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/util/pipeline/PipelineContext;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-core"})
    public static final class Internals {
        @NotNull
        public static final Internals INSTANCE = new Internals();

        private Internals() {
        }

        @InternalAPI
        @Nullable
        public final <C extends PipelineContext<?, ApplicationCall>> Object withMDCBlock(@NotNull C $this$withMDCBlock, @NotNull Function2<? super C, ? super Continuation<? super Unit>, ? extends Object> block2, @NotNull Continuation<? super Unit> $completion) {
            C $this$call$iv = $this$withMDCBlock;
            boolean $i$f$getCall = false;
            Object object = this.withMDCBlock($this$call$iv.getContext(), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(block2, $this$withMDCBlock, null){
                int label;
                final /* synthetic */ Function2<C, Continuation<? super Unit>, Object> $block;
                final /* synthetic */ C $this_withMDCBlock;
                {
                    this.$block = $block;
                    this.$this_withMDCBlock = $receiver;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$block.invoke(this.$this_withMDCBlock, (Object)((Object)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @InternalAPI
        @Nullable
        public final Object withMDCBlock(@NotNull ApplicationCall call2, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> block2, @NotNull Continuation<? super Unit> $completion) {
            boolean $i$f$withMDC = false;
            CallLogging callLogging = (CallLogging)ApplicationFeatureKt.featureOrNull((Pipeline)call2.getApplication(), Feature);
            if (callLogging == null) {
                Object object = block2.invoke($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            } else {
                CallLogging feature$iv = callLogging;
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)new MDCSurvivalElement(feature$iv.setupMdc$ktor_server_core(call2))), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block2, feature$iv, null){
                    int label;
                    final /* synthetic */ Function1 $block;
                    final /* synthetic */ CallLogging $feature;
                    {
                        this.$block = $block;
                        this.$feature = $feature;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$block.invoke((Object)((Object)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                Object object3;
                                try {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    object3 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    this.$feature.cleanupMdc$ktor_server_core();
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            nArray[Level.ERROR.ordinal()] = 1;
            nArray[Level.WARN.ordinal()] = 2;
            nArray[Level.INFO.ordinal()] = 3;
            nArray[Level.DEBUG.ordinal()] = 4;
            nArray[Level.TRACE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

